
{D+}                    {debug information}
{T-}                    {create .TPM file for debugging}
{F-}                    {automatically force far calls}
{V-}                    {var string checking}
{L+}                    {link buffer in memory}
{$R-}                   {range checking}
{$B+}                   {boolean complete evaluation}
{$S+}                   {stack checking}
{$I+}                   {I/O checking}
{$N-}                   {numeric coprocessor}
{$M 65500,0,4000}       {memory sizes}

{***************************************************************************}
{*                                                                         *}
{*      AIMDEMO.PAS         Copyright - Matt Goodrich                      *}
{*                              Jun 29, 1991                               *}
{*                                                                         *}
{*   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -   *}
{*                                                                         *}
{*      Maintenance History :                                              *}
{*                                                                         *}
{*  1.A  MG  6/29/91 - Initial Keyin.                                      *}
{*                                                                         *}
{***************************************************************************}

PROGRAM AIMDEMO;

USES

  CRT, MISCSTUF, AIMUNIT;

CONST
  Version           = '1.A';    {version number of program}

  EOF_Mark          = CHR (26);
  CarrRet           = CHR (13);
  LineFeed          = CHR (10);

VAR
  CharsRead    : INTEGER;
  CharsWrit    : INTEGER;
  DataFile     : FILE;
  Demo         : AimVars;
  I            : INTEGER;
  MyKeyedChar  : INTEGER;
  NewField     : STRING [ 6];
  ReadBuffer   : ARRAY [1..200] OF CHAR;

  TempInteger  : INTEGER;
  TempString03 : STRING [ 3];
  TempString70 : STRING [70];
  TempStringA  : STRING [31];
  TempStringB  : STRING [ 6];
  TempStringC  : STRING [33];

  TextFile     : TEXT;
  TextString   : ARRAY [1..5] OF STRING [70];



{***************************************************************************}

PROCEDURE Anything;

BEGIN

END;

{***************************************************************************}

PROCEDURE HaltDemo (DosErrorLevel : INTEGER);

BEGIN

  GOTOXY (78, 23);
  Cursor_On;
  HALT (DosErrorLevel);

END;

{***************************************************************************}

PROCEDURE PressAnyKeyKeyin;

BEGIN
  Disp_String ('Press any key to continue...', 1, 23, Normal_Video);
  Keyin_Char (MyKeyedChar);
  IF MyKeyedChar = ESC_Key
     THEN HaltDemo (1);

END;

{***************************************************************************}

PROCEDURE ClearSomeOfScreen;

BEGIN
   WINDOW (1, 10, 80, 25);
   CLRSCR;
   WINDOW (1,  1, 80, 25);
END;

{***************************************************************************}

BEGIN    {Main Procedure AimDemo}

  Ins_Mode := Yes;

  RANDOMIZE;

  CLRSCR;

  Disp_String ('Progam ',  1,  1, Normal_Video);
  Disp_String ('Version: ' + Version,  60,  1, Normal_Video);





  Disp_String ('This program is a demo of AIM showing how it might be used',
                      10,  6, Normal_Video);
  Disp_String ('and how to code it.  Since the point of this demo is the',
                      10,  7, Normal_Video);
  Disp_String ('source code, I opted for keeping it as simple as possible.',
                      10,  8, Normal_Video);
  Disp_String ('It may seem a little crude.', 10,  9, Normal_Video);

  Disp_String ('See the file "AIMDEX.DOC" for more information.',
                      10, 11, Normal_Video);

  PressAnyKeyKeyin;

 {**************************************************************************}

  CLRSCR;

  Disp_String ('Here''s the way the datafile looks:', 10, 1, Normal_Video);
  Disp_String ('----------------------------------------------------------' +
                      '------------', 1, 2, Bold_Video);
  Disp_String ('----------------------------------------------------------' +
                      '------------', 1, 8, Bold_Video);


  TextString [1] := '11111 JANE DOE           TIPPLE CORP                ' +
                 'NEW YORK          ';
  TextString [2] := '22222 BOB SMITH          WINGS & FEATHERS, INC      ' +
                 'INDIANA           ';
  TextString [3] := '33333 SAM JONES          LEMON TRUCKS               ' +
                 'NEW YORK          ';
  TextString [4] := '44444 TOM JONES          ACME RANCH                 ' +
                 'MONTANA           ';
  TextString [5] := '55555 BUFFY SIMMONS      FEATHERBEDS, LTD           ' +
                 'FLORIDA           ';


  ASSIGN (TextFile, 'AIMDEMO.TXT');
  REWRITE (TextFile);

  FOR I:= 1 TO 5 DO
    BEGIN
       WRITELN (TextFile, TextString [I]);
       Disp_String (TextString [I], 1, I+2, Normal_Video);
    END;

  WRITE (TextFile, EOF_Mark);
  CLOSE (TextFile);


  { -- Technically speaking, I should also rebuild the aimdex at this point,  }
  { -- but for the purposes of this crude demo program, I don't actually need }
  { -- to.  The old aimdex is still functional.                               }

 {**************************************************************************}
 {**************************************************************************}

  Demo.AimFileName := 'AIMDEMO.AIM';
  Aim_OpenFile (Demo);

  IF Demo.FileOpen = 'A'
    THEN BEGIN
           Disp_String ('Crash!  I could not open AIMDEMO.AIM.', 1, 15,
                               Bold_Video);
           HaltDemo (1);
         END
  ELSE IF Demo.FileOpen = 'D'
    THEN BEGIN
           Disp_String ('Crash!  I could not open AIMDEMO.TXT.', 1, 15,
                               Bold_Video);
           HaltDemo (1);
         END
  ;

  ASSIGN (DataFile, Demo.DataFileName);
  RESET (DataFile, 1);

 {**************************************************************************}
 {**************************************************************************}

  Disp_String ('Let''s start out by saying we have the above datafile ' +
               '(AIMDEMO.TXT) and its', 1, 10, Normal_Video);
  Disp_String ('aimdex file (AIMDEMO.AIM), which was created by doing:',
               1, 11, Normal_Video);

  Disp_String ('AIMDEXP AIMDEMO.TXT AIMDEMO.AIM  7-24,26-51,53-68',
               5, 13, Bold_Video);

  PressAnyKeyKeyin;
  ClearSomeOfScreen;

 {**************************************************************************}

  Disp_String ('Now I''ll do a Read for "Feath" in the 2nd aim field:',
               1, 10, Normal_Video);
  PressAnyKeyKeyin;


  Demo.AimKey [1] := '2Feath';
  Demo.AimKey [2] := '';
  Demo.AimKey [3] := '';
  Aim_Read (Demo);

  IF Demo.Found = Yes
   THEN BEGIN
          SEEK (DataFile, Demo.SeekPosData);
          BLOCKREAD (DataFile, ReadBuffer, 72, CharsRead);
          TempString70 := '';
          FOR I:= 1 TO 70 DO TempString70 := TempString70 + ReadBuffer [I];

          Disp_String ('OK. I found:', 1, 12, Normal_Video);
          Disp_String (TempString70, 1, 14, Reverse_Video);
        END;

  PressAnyKeyKeyin;

 {**************************************************************************}

  Disp_String ('Now I''ll do a ReadKG:', 1, 16, Normal_Video);

  PressAnyKeyKeyin;

  Aim_ReadKG (Demo);
  IF Demo.Found = Yes
   THEN BEGIN
          SEEK (DataFile, Demo.SeekPosData);
          BLOCKREAD (DataFile, ReadBuffer, 72, CharsRead);
          TempString70 := '';
          FOR I:= 1 TO 70 DO TempString70 := TempString70 + ReadBuffer [I];

          Disp_String ('OK. I found:', 1, 18, Normal_Video);
          Disp_String (TempString70, 1, 20, Reverse_Video);
        END;

  PressAnyKeyKeyin;

 {**************************************************************************}

  ClearSomeOfScreen;


  Disp_String ('Let''s do one more ReadKG:', 1, 10, Normal_Video);

  PressAnyKeyKeyin;

  Aim_ReadKG (Demo);
  IF Demo.Found = No
   THEN BEGIN
          Disp_String ('This time I didn''t find anything.', 1, 12,
                           Normal_Video);
          Disp_String ('(we''re at the end of the file.)', 1, 13, Normal_Video);
        END;

  PressAnyKeyKeyin;

 {**************************************************************************}

  Disp_String ('Now let''s do a ReadKP:', 1, 16, Normal_Video);

  PressAnyKeyKeyin;

  Aim_ReadKP (Demo);
  IF Demo.Found = Yes
   THEN BEGIN
          SEEK (DataFile, Demo.SeekPosData);
          BLOCKREAD (DataFile, ReadBuffer, 72, CharsRead);
          TempString70 := '';
          FOR I:= 1 TO 70 DO TempString70 := TempString70 + ReadBuffer [I];

          Disp_String ('OK. I found:', 1, 18, Normal_Video);
          Disp_String (TempString70, 1, 20, Reverse_Video);
        END;

  PressAnyKeyKeyin;


 {**************************************************************************}

  ClearSomeOfScreen;


  Disp_String ('This time I''m going to search for "Jones" in the 1st aim',
                1, 10, Normal_Video);
  Disp_String ('field and "TANA" in the 3rd aim field:', 1, 11, Normal_Video);
  PressAnyKeyKeyin;

  Demo.AimKey [1] := '1Jones';
  Demo.AimKey [2] := '3tana';
  Demo.AimKey [3] := '';
  Aim_Read (Demo);

  IF Demo.Found = Yes
   THEN BEGIN
          SEEK (DataFile, Demo.SeekPosData);
          BLOCKREAD (DataFile, ReadBuffer, 72, CharsRead);
          TempString70 := '';
          FOR I:= 1 TO 70 DO TempString70 := TempString70 + ReadBuffer [I];

          Disp_String ('OK. I found:', 1, 13, Normal_Video);
          Disp_String (TempString70, 1, 15, Reverse_Video);
        END;

  PressAnyKeyKeyin;

 {**************************************************************************}

  ClearSomeOfScreen;


  Disp_String ('OK.  Now let''s change a record.',
                1, 10, Normal_Video);

  Disp_String ('First search for "SAM JONES" in the 1st aim field:',
                1, 12, Normal_Video);
  PressAnyKeyKeyin;

  Demo.AimKey [1] := '1Sam Jones';
  Demo.AimKey [2] := '';
  Demo.AimKey [3] := '';
  Aim_Read (Demo);

  IF Demo.Found = Yes
   THEN BEGIN
          SEEK (DataFile, Demo.SeekPosData);
          BLOCKREAD (DataFile, ReadBuffer, 72, CharsRead);
          TempStringA := '';
          TempStringB := '';
          TempStringC := '';
          FOR I:=  1 TO 31 DO TempStringA := TempStringA + ReadBuffer [I];
          FOR I:= 32 TO 37 DO TempStringB := TempStringB + ReadBuffer [I];
          FOR I:= 38 TO 70 DO TempStringC := TempStringC + ReadBuffer [I];

          Disp_String ('OK. I found:', 1, 14, Normal_Video);
          Disp_String (TempStringA + TempStringB + TempStringC, 1, 16,
                                       Reverse_Video);
        END;

  PressAnyKeyKeyin;

 {**************************************************************************}

  NewField := 'CARS  ';

  Disp_String ('Let''s change the string "TRUCKS" to "' + NewField + '":',
               1, 18, Normal_Video);

  PressAnyKeyKeyin;


  FOR I:=  1 TO 31 DO ReadBuffer [I] := TempStringA [I];
  FOR I:= 32 TO 37 DO ReadBuffer [I] := NewField [I-31];
  FOR I:= 38 TO 70 DO ReadBuffer [I] := TempStringC [I-37];

  SEEK (DataFile, Demo.SeekPosData);
  BLOCKWRITE (DataFile, ReadBuffer, 72, CharsWrit);

  Aim_InsertKey (Demo);

  Disp_String (NewField, 32, 5, Normal_Video);
  Disp_String ('POOF!   I just changed it.', 1, 20, Bold_Video);

  PressAnyKeyKeyin;

 {**************************************************************************}

  ClearSomeOfScreen;


  Disp_String ('Now when I read the "SAM JONES" record, I get:',
                1, 10, Normal_Video);

  PressAnyKeyKeyin;

  Demo.AimKey [1] := '1Sam Jones';
  Demo.AimKey [2] := '';
  Demo.AimKey [3] := '';
  Aim_Read (Demo);

  IF Demo.Found = Yes
   THEN BEGIN
          SEEK (DataFile, Demo.SeekPosData);
          BLOCKREAD (DataFile, ReadBuffer, 72, CharsRead);
          TempString70 := '';
          FOR I:=  1 TO 70 DO TempString70 := TempString70 + ReadBuffer [I];

          Disp_String (TempString70, 1, 12, Reverse_Video);
        END;

  PressAnyKeyKeyin;

 {**************************************************************************}

  ClearSomeOfScreen;

  Disp_String ('Now let''s add a new record.', 1, 11, Normal_Video);

  PressAnyKeyKeyin;


  TempString70 := '66666 GEORGE SMITH       ACME COWS                  ' +
                 'WYOMING           ';

  FOR I:=  1 TO 70 DO ReadBuffer [I] := TempString70 [I];
  ReadBuffer [71] := CarrRet;
  ReadBuffer [72] := LineFeed;

  Demo.SeekPosData := FILESIZE (DataFile) - 1;  {overwrite EOF}
  SEEK (DataFile, Demo.SeekPosData);
  BLOCKWRITE (DataFile, ReadBuffer, 72, CharsWrit);

  ReadBuffer [1] := EOF_Mark;
  BLOCKWRITE (DataFile, ReadBuffer,  1, CharsWrit);



  { -- This flushs the write buffer.  You may want to take this code out  }
  { -- in order to improve performance slightly.  See AIMDEX.DOC for more }
  { -- details.                                                           }
  CLOSE (DataFile);
  RESET (DataFile, 1);



  Aim_InsertKey (Demo);


  Disp_String (TempString70, 1, 8, Normal_Video);


  Disp_String ('----------------------------------------------------------' +
                      '------------', 1, 9, Bold_Video);

  Disp_String ('POOF!   I just added a record.', 1, 13, Bold_Video);

  PressAnyKeyKeyin;

 {**************************************************************************}

  ClearSomeOfScreen;

  Disp_String ('That''s it for this demo!', 1, 16, Bold_Video);

  PressAnyKeyKeyin;




  HaltDemo (0);

END.

{***************************************************************************}
{***                          End of AIMDEMO.PAS                         ***}
{***************************************************************************}
