UNIT TuADs;

INTERFACE
Uses
   MBMDefs,
   WinTypes;  { THandle    Type }

Const
   Err_TypeSize = 100 ; {Type Size Error bad type declaration}

function TbGetCursor(hClient : THandle) : Word;

function CloseCursor(hCursor : THandle): word;

function ClientDone(hClient : THandle  ): word;

function fOpenTable(
      hCursor: THandle;
      FileName : PCHAR;
      IdTable :PCHAR ;
      Mode :Word
   ) : Integer;

function DefineTable(
         hCursor   : THandle;
         IdTable   : PCHAR;
         DataFile  : PCHAR;
         Flags     : Integer;
         NbField   : Integer;
         Fields    : pCharArray;
         Types     : pCharArray;
         MaxRecs   : Word;
         SortFlag  : Byte;
         NumFldSort : Word
         ) : Integer;


function CreateTable(
      hCursor : THandle;
      idTable : PCHAR
   ) :Integer ;

function OpenTable(
      hCursor : THandle;
      IdTable : PCHAR;
      Mode    : Word
   ): Integer;


function CloseTable(
      hCursor : THandle;
      IdTable : PCHAR
   ): Integer;


function SaveTable(
         hCursor : THandle;
         IdTable : PCHAR;
         FileName: PCHAR
         ) : Integer;

function SortTable( hCursor    : THandle;
                      idTable    : PCHAR;
                      SortType  : Word;
                      NbField   : Word) : Integer;

   function GetTableInfo(
      hCursor : THandle;
      IdTable : PCHAR
   ) : PTable;


function ResetTable(
         hCursor : THandle;
         IdTable : PCHAR
         ) : Integer;

function TbResetTable(Table : Ptable ) : Integer;

function RenameTable(hCursor : Thandle; FromidTable: PCHAR;TOidTable: PCHAR): Integer ;

function AddRecord(
      hCursor : THandle;
      IdTable : PCHAR;
      Buffer  : Pointer;
      BufSize : Word;
      Mode    : Word
   ) : Integer;

   function GetRecord(
      hCursor : THandle;
      IdTable : PCHAR;
      RecNb   : Word;
      Buffer  : Pointer;
      BufSize : Word
   ) : Integer;


   function SetRecord(
      hCursor : THandle;
      IdTable : PCHAR;
      RecNb   : Word;
      Buffer  : Pointer;
      BufSize : Word
   ) : Integer;


   function DeleteRecord(
      hCursor : THandle;
      IdTable : PCHAR;
      RecNb   : Word
   ) : Integer;

   function GetField(
      hCursor       : THandle;
      IdTable       : PCHAR;
      idField       : PCHAR;
      PosField      : Word;
      RecNb         : Word;
      FieldBuffer   : Pointer;
      FieldSize     : Word
   ) : Integer;

   function SetField(
      hCursor       : THandle;
      IdTable       : PCHAR;
      idField       : PCHAR;
      PosField      : word;
      RecNb         : Word;
      FieldBuffer   : Pointer;
      FieldSize     : Word
   ) : Integer;

   function GetValue(hCursor: THANDLE;
      Table_Name : PCHAR ;
      Data_Name : PCHAR;
      PosField  : WORD;
      RecNb : WORD;
      FieldBuffer : POINTER;
      Field_Size : WORD
   ) : Integer;


   function SetValue(
      hCursor: THANDLE ;
      Table_Name : PCHAR;
      Data_Name : PCHAR;
      PosField  : WORD;
      RecNb : WORD;
      FieldBuffer : POINTER;
      Field_Size : WORD
   ) : integer;

Function TbGetValue(Table : pTable;
                       PosField : Word;
                       RecNb : WORD;
                       FieldBuffer : POINTER;
                       Field_Size : WORD  ) : Integer;

Function TbSetValue(Table : pTable; Data_Name : PCHAR;
                  PosField : Word;
                  RecNb : WORD; FieldBuffer : POINTER; Field_Size : WORD  ) : integer;

   function TbGetField(Table   : PTable;
                        RecNb  : Word;
                        FR     : Word;
                        Buffer : Pointer;
                        BufSize : Word
                       ) : Integer;

   function TbSetField(Table    : PTable;
                        RecNb   : Word;
                        FR      : Word;
                        Buffer  : Pointer;
                        BufSize : Word
                       ) : Integer;

   function TbGetRecord(Table   : PTable;
                        RecNb   : Word;
                        Buffer  : Pointer;
                        BufSize : Word
                       ) : Integer;

   function TbSetRecord(Table   : PTable;
                        RecNb   : Word;
                        Buffer  : Pointer;
                        BufSize : Word
                       ) : Integer;

   function TbAddRecord(Table   : PTable;
                        Buffer  : Pointer;
                        BufSize : Word;
                        Mode    : Word
                       ) : Integer;

function TbInsRecord(Table   : PTable;
                        Buffer  : Pointer;
                        BufSize : Word;
                        RecNb   : Word
                       ) : Integer;

function TbDeleteRecord(Table   : PTable;
                        RecNb   : Word
                       ) : Integer;


function TbGetFieldAddress( Table   : PTable;
                             RecNb   : Word;
                             FR      : Word
                             ) : Pointer;

function TbGetRecordAddress( Table   : PTable;
                             RecNb   : Word
                             ) : Pointer;

   function SearchRecord(
       hCursor       : THandle;
       IdTable       : PCHAR;
       idField       : PCHAR;
       FieldBuffer   : Pointer;
       FieldSize     : Word;
       RecNb         : Pointer
   ) : Integer;

   function SearchKey(
       hCursor       : THandle;
       IdTable       : PCHAR;
       Nflds         : Word;
       RecBuffer     : Pointer;
       RecNb         : Pointer
   ) : Integer;




function TbSearchKey(
       Table         : PTable;
       Nflds         : Word;
       RecBuffer     : Pointer;
       RecNb         : Pointer
   ) : Integer;


function TbSearchRef(
       Table         : PTable;
       Nflds         : Word;
       RecBuffer     : Pointer
   ) : Word;

   function GetType(Table      : PTable;
                 idField    : FieldString;
                 PosField   : Word;
            var  VarType    : TypeString) : Integer;

   function GetTypeSize(TheType : String) : Integer;

   function GetVarType(Table      : PTable;
                    idField    : Pointer;
                    PosField   : Word;
                    VarType    : Pointer) : Integer;

   function GetDataType(
      hCursor    : THANDLE;
      idTable         : PCHAR;
      idField         : FieldString;
      PosField        : Word;
      var  VarType    : TypeString
   ) : Integer;

function GetFieldPos(Table    : PTable;
                     idField  : FieldString
                     ) : Integer;

function GetFldPos(Table    : PTable;
                     idField  : Pointer
                     ) : Integer;

function GetFldName(Table  : PTable;
                         FR  : Word;
                         fldName : Pointer
                     ) : Integer;

function GetNbRecs(hCursor : THandle;IdTable : PCHAR) : WORD;

function TbGetNbRecs(Table : PTable) : WORD;

Function Register_Runtime(USER : pchar;CODE : pchar; Distributor : pchar) :integer;

{*********************Base management *****************}

function OpenMBase(hCursor : THandle;
                   MBaseFile : PCHAR;
                   Mode      : word
                     ) : ErrType;

function CloseMBase(hCursor : THandle;
                    MBaseFile : PCHAR
                     ) : ErrType;

function SaveMBase(hCursor : THandle;
                    MBaseFile : PCHAR
                     ) : ErrType;
function SortMBase(hCursor : THandle;
                    MBaseFile : PCHAR
                     ) : ErrType;


function DeleteMBase(hCursor : THandle;
                    MBaseFile : PCHAR
                     ) : ErrType;

function SaveASMBase(hCursor : THandle;
                    MBase       : PCHAR ;
                    ASMBaseFile : PCHAR
                     ) : ErrType;


function OpenMBaseTable(hCursor: tHandle;
                        MBaseFile : PCHAR;
                        TableFile : PCHAR): Integer;

function IsBaseModified(hCursor : THandle;
                    MBaseFile : PCHAR
                     ) : Boolean;

function SetBaseModified(hCursor : THandle;
                    MBaseFile : PCHAR;
                    Modified  : Boolean
                     ) : Integer;

function CloseBase(hCursor : THandle;
                    MBaseFile : PCHAR
                     ) : ErrType;

function SortBase(hCursor : THandle;
                    MBaseFile : PCHAR
                     ) : ErrType;

function OpenBase(hCursor : THandle;
                    MBaseFile : PCHAR ;
                    mode       : Word
                     ) : ErrType;


function SaveBase2Tables(hCursor : THandle;
                    BaseName : PCHAR
                     ) : ErrType;

function IsTableInBase(hCursor : THandle;
                    BaseName : PCHAR;
                    TableName : PCHAR
                     ) : Boolean;
function ResetBase(hCursor : THandle;
                    BaseTbFile : PCHAR
                     ) : ErrType;

implementation

   Function OpenBase    ;   EXTERNAL 'ADS'    INDEX   302;
   Function CloseBase   ;   EXTERNAL 'ADS'    INDEX   303;
   Function SortBase    ;   EXTERNAL 'ADS'    INDEX   304;
   function IsBaseModified ;EXTERNAL 'ADS'    INDEX   328;
   function SetBaseModified;EXTERNAL 'ADS'    INDEX   334;
   Function OpenMBase    ;   EXTERNAL 'ADS'    INDEX   311;
   Function CloseMBase   ;   EXTERNAL 'ADS'    INDEX   312;
   Function SortMBase    ;   EXTERNAL 'ADS'    INDEX   313;
   Function DeleteMBase  ;   EXTERNAL 'ADS'    INDEX   314;
   Function SaveMBase    ;   EXTERNAL 'ADS'    INDEX   315;
   function SaveASMBase  ;   EXTERNAL 'ADS'    INDEX   327;
   function OpenMBaseTable;  EXTERNAL 'ADS'    INDEX   332;
   function DefineTable       ;   EXTERNAL 'ADS' INDEX   1;
   function  OpenTable      ;  EXTERNAL 'ADS'    INDEX    2;
   function  CloseTable     ;  EXTERNAL 'ADS'    INDEX    3;
   function  GetTableInfo   ;  EXTERNAL 'ADS'    INDEX    8;
   function GetField       ;   EXTERNAL 'ADS'    INDEX   16;
   function SetField       ;   EXTERNAL 'ADS'    INDEX   17;
   function SearchRecord   ;   EXTERNAL 'ADS'    INDEX   18;
   function GetRecord      ;   EXTERNAL 'ADS'    INDEX   19;
   function SetRecord      ;   EXTERNAL 'ADS'    INDEX   20;
   function AddRecord      ;   EXTERNAL 'ADS'    INDEX   21;
   function DeleteRecord   ;   EXTERNAL 'ADS'    INDEX   22;
   function GetTypeSize    ;   EXTERNAL 'ADS'    INDEX   31;
   function ClientDone          ;   EXTERNAL 'ADS'    INDEX   52;
   function fOpenTable         ;   EXTERNAL 'ADS'    INDEX   53;
   function CreateTable         ;   EXTERNAL  'ADS'   INDEX   54;
   function GetValue            ;   EXTERNAL 'ADS'    INDEX   55;
   function SetValue            ;   EXTERNAL 'ADS'    INDEX   56;
   function GetDataType         ;   EXTERNAL 'ADS'    INDEX   57;
   Function SortTable           ;   EXTERNAL 'ADS'    INDEX   60;
   Function SearchKey           ;   EXTERNAL 'ADS'    INDEX   64;
   Function SaveTable           ;   EXTERNAL 'ADS'    INDEX   65;
   function GetType             ;   EXTERNAL 'ADS'    INDEX   66;
   function tbGetRecord        ;   EXTERNAL 'ADS' INDEX   68;
   function tbSetRecord        ;   EXTERNAL 'ADS' INDEX   69;
   function tbAddRecord        ;   EXTERNAL 'ADS' INDEX   70;
   function tbDeleteRecord     ;   EXTERNAL 'ADS' INDEX   71;
   function tbGetField         ;   EXTERNAL 'ADS' INDEX   72;
   function tbSetField         ;   EXTERNAL 'ADS' INDEX   73;
   Function tbSearchKey        ;   EXTERNAL 'ADS' INDEX   74;
   function TbGetRecordAddress ;   EXTERNAL 'ADS' INDEX   75;
   function TbGetFieldAddress  ;   EXTERNAL 'ADS' INDEX   76;
   Function tbSearchRef        ;   EXTERNAL 'ADS' INDEX   77;
   function TbGetCursor        ;   EXTERNAL 'ADS' INDEX   80;
   function CloseCursor        ;   EXTERNAL 'ADS' INDEX   81;
   function ResetTable        ;   EXTERNAL 'ADS' INDEX   83;
   function TbResetTable      ;   EXTERNAL 'ADS' INDEX   84;
   function GetFieldPos       ;   EXTERNAL 'ADS' INDEX   86;
   function GetFldName        ;   EXTERNAL 'ADS' INDEX   87;
   function TbGetValue        ;   EXTERNAL 'ADS' INDEX   88;
   function TbInsRecord       ;   EXTERNAL 'ADS' INDEX   89;
   function RenameTable       ;   EXTERNAL 'ADS' INDEX   91;
   function TbSetValue        ;   EXTERNAL 'ADS' INDEX   94;
   function GetVarType        ;   EXTERNAL 'ADS' INDEX   102;
   function GetFldPos         ;   EXTERNAL 'ADS' INDEX   103;
   function GetNbRecs         ;   EXTERNAL 'ADS' INDEX   104;
   function TbGetNbRecs       ;   EXTERNAL 'ADS' INDEX   105;
   Function Register_Runtime  ;   EXTERNAL 'ADS' INDEX   106;

   function SaveBase2Tables; EXTERNAL 'ADS'    INDEX   350;
   Function ResetBase       ;   EXTERNAL 'ADS'    INDEX   351;
   Function IsTableInBase   ;   EXTERNAL 'ADS'    INDEX   352;


BEGIN
END.