// affairsd.cpp : implementation file
//

#include "stdafx.h"
#include "mfc.h"
#include "affairsd.h" 


#include <windowsx.h> 
//#include <ios.h>
#include <string.h>   

#include "afxwin.h" 


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// AffairsDialog dialog

AffairsDialog::AffairsDialog(CWnd* pParent /*=NULL*/)
	: CDialog(AffairsDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(AffairsDialog)
	m_Amount = 0;
	m_Customer = "";
	m_Trader = "";
	//}}AFX_DATA_INIT
}

void AffairsDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(AffairsDialog)
	DDX_Text(pDX, IDC_AMOUNT, m_Amount);
	DDX_CBString(pDX, IDC_CUSTOMER, m_Customer);
	DDX_CBString(pDX, IDC_TRADER, m_Trader);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(AffairsDialog, CDialog)
	//{{AFX_MSG_MAP(AffairsDialog)
	ON_CBN_SELCHANGE(IDC_CUSTOMER, OnSelchangeCustomer)
	ON_CBN_SELCHANGE(IDC_TRADER, OnSelchangeTrader)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// AffairsDialog message handlers

BOOL AffairsDialog::OnInitDialog()
{                                            
   LPSTR      lpstrName;
   int        Status;
   WORD       inst;                                
   CComboBox* pCust;
   CComboBox* pTrad;
   
   long far*  lAmount;

	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here  
	inst = (WORD)AfxGetInstanceHandle();  
	// Get Tables information structure
	CustomTable  = GetTableInfo(inst,"CUSTOME");                                
	TraderTable  = GetTableInfo(inst,"TRADERS");
	AffairsTable = GetTableInfo(inst,"AFFAIRS");
	
	// Get Combo Objects
	pTrad = (CComboBox*)GetDlgItem(IDC_TRADER); 
	pCust = (CComboBox*)GetDlgItem(IDC_CUSTOMER); 
	// Fill both combos
	Status = pCust->AddString("All");
	lpstrName = (LPSTR)GlobalAllocPtr(GHND,31);
	for(UINT i=1;i<= CustomTable->NbRecs;i++)
		{            
		Status = TbGetField(CustomTable,i,1,lpstrName,30); 
		Status = pCust->AddString(lpstrName);
		} 
	
	Status = pTrad->AddString("All");
	for( i=1;i<= TraderTable->NbRecs;i++)
		{            
		Status = TbGetField(TraderTable,i,1,lpstrName,30);
		Status = pTrad->AddString(lpstrName);
		}
	
	GlobalFreePtr(lpstrName);
	// Compute the initial value of AMOUNT
	for (i=1;i<=AffairsTable->NbRecs;i++)
		{                                                 
		
		//Status = TbGetField(AffairsTable,i,5,(LPSTR)lAmount,AffairsTable->VarSize[4]);// 4 = fifth element in a zero based array !!! 
		lAmount = (long far*)TbGetFieldAddress(AffairsTable,i,5);// 4 = fifth element in a zero based array !!!
		if (lAmount)
			{m_Amount += *lAmount;}
		}
	//UpdateAmount();
	UpdateData(FALSE);                                           
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void AffairsDialog::UpdateAmount()
{               
	LPSTR      lpstrCust;
	LPSTR      lpstrTrad;                          
	BOOL       bComputeCust;
	BOOL       bComputeTrad;                            
	CComboBox* pCust;
   CComboBox* pTrad;
   
	struct Affairs
				{
				char cTrader[30];
				char cCustomer[30];
				long lDate;
				char cProduct[20];
				long lAmount;
				} far* sAffairsRecord;
	
	// Retrieve the COMBO objects
	pTrad = (CComboBox*)GetDlgItem(IDC_TRADER); 
	pCust = (CComboBox*)GetDlgItem(IDC_CUSTOMER); 
	// Allocate buffers
	lpstrCust = (LPSTR)GlobalAllocPtr(GHND,31); 
	lpstrTrad = (LPSTR)GlobalAllocPtr(GHND,31);
	
	m_Amount = 0;  
	// Get the new selection for each combo
	pCust->GetLBText(pCust->GetCurSel(),lpstrCust);
	pTrad->GetLBText(pTrad->GetCurSel(),lpstrTrad);
	
	
   if (_fstrnicmp(lpstrCust,"All",3)==0) 
      bComputeCust = TRUE ;
   else
      bComputeCust = FALSE;
   if (_fstrnicmp(lpstrTrad,"All",3)==0) 
      bComputeTrad = TRUE; 
   else
   	bComputeTrad = FALSE;
                                                                                  
   if (AffairsTable!=NULL)
   	{
   	for (UINT i=1;i<=AffairsTable->NbRecs;i++)
   		{
      	sAffairsRecord = (Affairs far*)TbGetRecordAddress(AffairsTable,i);
      	/*sAffairsRecord = (Affairs*)GlobalAllocPtr(GHND,sizeof(Affairs));
      	Status = TbGetRecord(AffairsTable,i,(LPSTR)sAffairsRecord,sizeof(Affairs));*/
      	if (! bComputeCust)
      		{
      	   if (_fstrcmp(lpstrCust,sAffairsRecord->cCustomer)==0)
      	   	{                     
      	   	if (! bComputeTrad)
      				{
      	   		if (_fstrcmp(lpstrTrad,sAffairsRecord->cTrader)==0)
      	   			{
      	   			m_Amount += sAffairsRecord->lAmount;
      	   			}
      	   		}
      	 		else
      	 			{
      	 			m_Amount += sAffairsRecord->lAmount;
      	 			}
      	   	}
      	   }
      	 else
      	 	{                     
      	   	if (! bComputeTrad)
      				{
      	   		if (_fstrcmp(lpstrTrad,sAffairsRecord->cTrader)==0)
      	   			{
      	   			m_Amount += sAffairsRecord->lAmount;
      	   			}
      	   		}
      	 		else
      	 			{
      	 			m_Amount += sAffairsRecord->lAmount;
      	 			}
      	   	}
      	   
      	//GlobalFreePtr(sAffairsRecord);
   		}
   		
   	}
   m_Customer=lpstrCust; 
   m_Trader=lpstrTrad;
   GlobalFreePtr(lpstrCust);
   GlobalFreePtr(lpstrTrad);
   UpdateData(FALSE); 
   return;
}

/*void AffairsDialog::OnEditchangeCustomer()
{
	// TODO: Add your control notification handler code here
	UpdateAmount();            
	return;
}
*/
void AffairsDialog::OnSelchangeCustomer()
{
	// TODO: Add your control notification handler code here
	
	UpdateAmount();            
	return;
	
}

void AffairsDialog::OnSelchangeTrader()
{
	// TODO: Add your control notification handler code here
	UpdateAmount();            
	return;
}
