Unit D_FstPay;

INTERFACE
Uses
   Wintypes, Winprocs;

function D_FSTPayInit(Window : hWnd; Message,wParam : Word;lParam : LongInt):Integer;

IMPLEMENTATION
Uses r_incl,s_incl,MBMDEFS,TuADS,Strings,Win31;

Function CountDistAffair(hCursor : word; DistCode : Pointer;
                                            Var Total : Double;
                                            Var Payed : Double;
                                            Var Credit : double;
                                               CMPAYED : Pointer;
                                               Update  : Boolean
                                            ): Integer;
Var
   RecNb        : Integer;
   TableAffair  : pTable;
   Done         : Boolean;
   NextDist     : Pointer;
   AffairBuff   : pFSTLCOM;
begin
(*
   pFSTLCOM = ^T__FSTLCOM;
   T__FSTLCOM = RECORD
   _FSTLID                                  :CSTRING15;
   _DIST                                    :CSTRING35;
   _FSTCOM                                  :DOUBLE;
   _FSTPAYED                                :CSTRING15;
 *)

   TableAffair   := GetTableInfo(hCursor,'FSTLCOM');
   If (TableAffair <> NIL) then
   begin
       Done     := False;
       Total    := 0;
       Payed    := 0;
       Credit   := 0;
       RecNb := TbSearchRef(TableAffair,1,DISTCODE);
       If (StrComp('ALL',DISTCODE) = 0) then RecNb := 1;
       If (RecNb > 0 )then
       begin
          While Not Done do
          begin
             AffairBuff := TbGetRecordAddress(TableAffair,RecNb);
             Total := Total + AffairBuff^._FSTCOM;
             If (StrLen(AffairBuff^._FSTPAYED) = 0 ) then
                Credit := Credit + AffairBuff^._FSTCOM
             else
                Payed := Payed + AffairBuff^._FSTCOM;
              if Update then
                 TbSetField(TableAffair,RecNb,4,CMPAYED,SizeOf(CSTRING15));

             Inc(RecNb);
             if RecNb >TableAffair^.NbRecs then Done := True else
             begin
                NextDist  := TbGetFieldAddress(TableAffair,RecNb,1);
                If (StrComp('ALL',DISTCODE) <> 0 ) then
                    If (StrComp(NextDist,DISTCODE) <> 0 ) then Done := True;
             end;
          end;
       end;
   end;
end;

Function GOClip(hWindow : hWnd; hCursor: Word): integer;
Var
   pClip         : Pointer;
   Index         : integer;
   TableCUSTOMER : pTable;
   TableFSTL     : PTable;
   TmpBuffer     : pointer;
   RecBuffer     : pointer;
   DISTCODE      : Pointer;
   FSTLCODE      : Pointer;
   Total,Payed,
   Credit        : double;
   I,J           : Word;
   Tmp2Buffer    : array[0..50] of char;
   StrBuffer     : String;
   Sel           : Integer;
   Update        : Boolean;
   CmdPay        : array[0..50] of char;

begin
{   If hClip = 0 then}

       Update := FALSE;
       if IsDlgButtonChecked(hWindow,ID_UPDCHK)> 0 then
          Update := TRUE;
       If Update then
          GetDlgItemText(hWindow,ID_UPDDATE,CmdPay,15);

       TableCUSTOMER := GetTableInfo(hInstance,'CUSTOMER');
       TableFSTL     := GetTableInfo(hInstance,'FSTLDIST');
       Index :=  SendDlgItemMessage(hWindow,ID_DISTLIST,LB_GetCount, 0,0);
       if Index < 1 then Index := 1;
       hClip := GlobalAlloc(GHND,TableCustomer^.RecSize * Index);
       pClip := GlobalLock(hClip);

       TmpBuffer := GlobalAllocPtr(GHND,TableCUSTOMER^.RecSize);
       DISTCODE  := GlobalAllocPtr(GHND,50);
       FSTLCODE  := GlobalAllocPtr(GHND,50);
       StrCopy(pClip,'FSTL Distributors commision '+#13+#10);
       If Index > 0 then
       For J := 0 to Index-1 do
       begin
          Sel :=  SendDlgItemMessage(hWindow,ID_DISTLIST,LB_GetSel, J,0);
          if (Sel > 0)then
          begin
             SendDlgItemMessage(hWindow,ID_DISTLIST,LB_GetText, J,LongInt(TmpBuffer));
             StrlCopy(FSTLCODE,TmpBuffer,11);

             I := TbSearchRef(TableFSTL,1,FSTLCODE);
             TbGetField(TableFSTL,I,2,DISTCODE,SizeOf(CSTRING35));
             I := TbSearchRef(TableCUSTOMER,1,DISTCODE);
             if I > 0 then
             begin
                RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,1);
                CountDistAffair(hInstance,FSTLCODE,Total,Payed,Credit,@CMDPAY,Update);
                if Credit > 0 then
                begin
                   StrCopy(TmpBuffer,RecBuffer);
                   StrCat(TmpBuffer,#9);
                   RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,2);
                   StrCat(TmpBuffer,RecBuffer);
                   StrCat(TmpBuffer,#9);
                   RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,4);
                   StrCat(TmpBuffer,RecBuffer);
                   StrCat(TmpBuffer,#9);

                   Str(Credit:6:1,StrBuffer);
                   StrPCopy(Tmp2Buffer,StrBuffer);
                   StrCat(TmpBuffer,Tmp2Buffer);
                   StrCat(TmpBuffer,#13+#10);

                   StrCat(pClip,TmpBuffer);
               end;
             end;
          end;
       end;
       MessageBox(hWindow,'Payment List available in the Clibboard','Message',0);
       GlobalFreePtr(TmpBuffer);
       GlobalFreePtr(DISTCODE);
       GlobalFreePtr(FSTLCODE);
       OpenClipBoard(hWindow);
       EmptyClipboard;
       SetClipboardData(cf_Text,hClip);
       CloseClipBoard;
       GlobalUnlock(hClip);
end;



{-----------------------------------------------------------------------}
{ Function : D_Payment                                                  }
{-----------------------------------------------------------------------}
{ Purpose :                                                             }
{    Callback function for the D_Payment Dialog Box                     }
{-----------------------------------------------------------------------}
{  Parameters : Standart window  parameters                             }
{-----------------------------------------------------------------------}

function D_FSTPaymentWndProc(Dialog: HWnd; Message, WParam: Word;
               LParam: Longint): LongInt; export;
var
   Return         : LongInt;
   TableCustomer  : pTable;
   TableFSTL      : pTable;
   I              : Word;
   RecNb          : Word;
   TmpBuffer      : Pointer;
   Tmp2Buffer     : array[0..50] of char;
   StrBuffer      : String;
   RecBuffer      : Pointer;
   DistCode       : Pointer;
   TAB            : Integer;
   Index          : Integer;
   Total,Payed,Credit :Double;
   CMDPAY             : array[0..50] of char;
   Sel                : Integer;
begin
   Return := 0;
   case Message of
      WM_INITDIALOG:
      begin
         TAB := 70;
         SendDlgItemMessage(Dialog,ID_DISTLIST,LB_SETTABSTOPS, 1, LongInt(@TAB));
         TAB := 50;
         SendDlgItemMessage(Dialog,ID_DISTLIST,LB_SETTABSTOPS, 1, LongInt(@TAB));
         TableCUSTOMER := GetTableInfo(hInstance,'CUSTOMER');
         TableFSTL     := GetTableInfo(hInstance,'FSTLDIST');
         TmpBuffer := GlobalAllocPtr(GHND,TableCUSTOMER^.RecSize);
         For I := 1 to TableFSTL^.NbRecs do
         begin
            DistCode:= TbGetFieldAddress(TableFSTL,I,2);
            RecNb := TbSearchRef(TableCUSTOMER,1,DistCode);
            if RecNb > 0 then
            begin
               RecBuffer := TbGetFieldAddress(TableFSTL,I,1);
                CountDistAffair(hInstance,RecBuffer,Total,Payed,Credit,@CMDPAY,FALSE);
               if Credit > 0 then
               begin

                  StrCopy(TmpBuffer,RecBuffer);
                  StrCat(TmpBuffer,#9);
                  RecBuffer := TbGetFieldAddress(TableCUSTOMER,RecNb,2);
                  StrCat(TmpBuffer,RecBuffer);
                  StrCat(TmpBuffer,#9);
                  RecBuffer := TbGetFieldAddress(TableCUSTOMER,RecNb,4);
                  StrCat(TmpBuffer,RecBuffer);

                  Str(Credit:6:1,StrBuffer);
                  StrPCopy(Tmp2Buffer,StrBuffer);
                  StrCat(TmpBuffer,Tmp2Buffer);

                  SendDlgItemMessage(Dialog,ID_DISTLIST,LB_ADDSTRING, 0, LongInt(TmpBuffer));
               end;
           end;
         end;
         GlobalFreePtr(TmpBuffer);
      end;

      WM_COMMAND:
              Case WParam Of

               ID_EXIT :begin
                            EndDialog(Dialog, 1);
                            Exit;
                        end;
               ID_OK :begin
                            EndDialog(Dialog, 1);
                            Exit;
                         end;

               ID_UNSEL : Begin
                             Sel :=  SendDlgItemMessage(Dialog,ID_DISTLIST,LB_GetSelCount, 0,0);
                             if (Sel > 0)then
                                SendDlgItemMessage(Dialog,ID_DISTLIST, LB_SETSEL, 0, MakeLong($FFFF,0));
                          end;
               ID_SALL  : Begin
                             Sel :=  SendDlgItemMessage(Dialog,ID_DISTLIST,LB_GetCount, 0,0);
                             if (Sel > 0)then
                                 SendDlgItemMessage(Dialog,ID_DISTLIST, LB_SETSEL, 1, MakeLong($FFFF,0));
                          end;

               ID_GO  : Begin
                             GOClip(Dialog,hInstance);
                          end;

               ID_DISTLIST : begin
                                 If HiWORD(LParam)= LBN_SELCHANGE then
                                 begin
                                 end;
                             end;
               end;
      end;
   D_FSTPaymentWndProc := Return;
end;


{-----------------------------------------------------------------------}
{ Function : AboutInit                                                  }
{-----------------------------------------------------------------------}
{ Purpose :                                                             }
{    Initialisation for the D_Payment Box                                   }
{-----------------------------------------------------------------------}
{  Parameters : Standart window  parameters                             }
{-----------------------------------------------------------------------}

function D_FSTPayInit(Window : hWnd; Message,wParam : Word;
                   lParam : LongInt):Integer;
var
   D_FSTPaimentProc     : TFarProc;
begin
   D_FSTPaimentProc := MakeProcInstance(@D_FSTPaymentWndProc, hInstance);
   DialogBox(hInstance, 'FSTLPAIMENT', Window, D_FSTPaimentProc);  { Modal Dialog !}
   FreeProcInstance(D_FSTPaimentProc);
end;



begin
end.