Unit D_Acount;

INTERFACE
Uses
   Wintypes, Winprocs;

function D_AccountInit(Window : hWnd; Message,wParam : Word;lParam : LongInt):Integer;

IMPLEMENTATION
Uses r_incl,s_incl,MBMDEFS,TuADS,Strings,Win31;

Function CountDistAffair(hCursor : word; DistCode : Pointer;
                                            Var Total : Double;
                                            Var Payed : Double;
                                            Var Credit : double): Integer;
Var
   RecNb        : Integer;
   TableAffair  : pTable;
   Done         : Boolean;
   NextDist     : Pointer;
   AffairBuff   : pAFFAIRS;
begin
   TableAffair   := GetTableInfo(hCursor,'AFFAIRS');
   If (TableAffair <> NIL) then
   begin
       Done     := False;
       Total    := 0;
       Payed    := 0;
       Credit   := 0;
       RecNb := TbSearchRef(TableAffair,1,DISTCODE);
       If (StrComp('ALL',DISTCODE) = 0) then RecNb := 1;
       If (RecNb > 0 )then
       begin
          While Not Done do
          begin
             AffairBuff := TbGetRecordAddress(TableAffair,RecNb);
             Total := Total + AffairBuff^._TOCOMMISSION;
             If (StrLen(AffairBuff^._CMPAYED) = 0 ) then
                Credit := Credit + AffairBuff^._TOCOMMISSION
             else
                Payed := Payed + AffairBuff^._TOCOMMISSION ;
             Inc(RecNb);
             if RecNb >TableAffair^.NbRecs then Done := True else
             begin
                NextDist  := TbGetFieldAddress(TableAffair,RecNb,1);
{                If (NextDist <> NIL) then}
                If (StrComp('ALL',DISTCODE) <> 0 ) then
                    If (StrComp(NextDist,DISTCODE) <> 0 ) then Done := True;
             end;
          end;
       end;
   end;
end;

Function Count_Affaires(hCursor: Word; Dialog : hWnd; DISTCODE : pointer): Integer;
Var
   TableCustomer : pTable;
   TableAffair   : pTable;
   RecNb         : Word;
   FieldPointer  : Pointer;
   Total         : Double;
   Payed         : Double;
   Credit        : Double;
   TmpBuffer     : array[0..256] of char;
   StrBuffer     : String;
begin
   TableCustomer := GetTableInfo(hCursor,'CUSTOMER');
   TableAffair   := GetTableInfo(hCursor,'AFFAIRS');
   If ((TableCustomer <> NIL) and (TableAffair <> NIL)) then
   begin
       Total         := 0;
       Payed         := 0;
       Credit        := 0;
       RecNb := TbSearchRef(TableCustomer,1,DISTCODE);
       If (StrComp('ALL',DISTCODE) = 0) then RecNb := 1;
       If (RecNb > 0 )then
       begin
           If (StrComp('ALL',DISTCODE) <> 0) then
           begin
              FieldPointer := TbGetFieldAddress(TableCustomer,RecNb,2);
              SetDlgItemText(Dialog,ID_NAME,FieldPointer);
              FieldPointer := TbGetFieldAddress(TableCustomer,RecNb,4);
              SetDlgItemText(Dialog,ID_COMPANY,FieldPointer);
           end else
           begin
              SetDlgItemText(Dialog,ID_NAME,'ALL');
              SetDlgItemText(Dialog,ID_COMPANY,'ALL');
           end;
           CountDistAffair(hCursor,DistCode,Total,Payed,Credit);

           Str(Total:6:1,StrBuffer);
           StrPCopy(TmpBuffer,StrBuffer);
           SetDlgItemText(Dialog,ID_TOTAFF,TmpBuffer);
           Str(Payed:6:1,StrBuffer);
           StrPCopy(TmpBuffer,StrBuffer);
           SetDlgItemText(Dialog,ID_PAYED,TmpBuffer);
           Str(Credit:6:1,StrBuffer);
           StrPCopy(TmpBuffer,StrBuffer);
           SetDlgItemText(Dialog,ID_CREDIT,TmpBuffer);

       end;
   end;
end;



{-----------------------------------------------------------------------}
{ Function : D_Account                                                  }
{-----------------------------------------------------------------------}
{ Purpose :                                                             }
{    Callback function for the D_Account Dialog Box                     }
{-----------------------------------------------------------------------}
{  Parameters : Standart window  parameters                             }
{-----------------------------------------------------------------------}

function D_AccountWndProc(Dialog: HWnd; Message, WParam: Word;
               LParam: Longint): LongInt; export;
var
   Return         : LongInt;
   TableCustomer  : pTable;
   I              : Integer;
   TmpBuffer      : Pointer;
   RecBuffer      : Pointer;
   TAB            : Integer;
   Index          : WORD;
begin
   Return := 0;
   case Message of
      WM_INITDIALOG:
      begin
         TAB := 70;
         SendDlgItemMessage(Dialog,ID_DISTLIST,LB_SETTABSTOPS, 1, LongInt(@TAB));
         TAB := 50;
         SendDlgItemMessage(Dialog,ID_DISTLIST,LB_SETTABSTOPS, 1, LongInt(@TAB));
         TableCUSTOMER := GetTableInfo(hInstance,'CUSTOMER');
         TmpBuffer := GlobalAllocPtr(GHND,TableCUSTOMER^.RecSize);
         For I := 1 to TableCUSTOMER^.NbRecs do
         begin
            RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,1);
            StrCopy(TmpBuffer,RecBuffer);
            StrCat(TmpBuffer,#9);
            RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,2);
            StrCat(TmpBuffer,RecBuffer);
            StrCat(TmpBuffer,#9);
            RecBuffer := TbGetFieldAddress(TableCUSTOMER,I,4);
            StrCat(TmpBuffer,RecBuffer);

            SendDlgItemMessage(Dialog,ID_DISTLIST,LB_ADDSTRING, 0, LongInt(TmpBuffer));
         end;
         GlobalFreePtr(TmpBuffer);
      end;

      WM_COMMAND:
              Case WParam Of

               ID_EXIT :begin
                            EndDialog(Dialog, 1);
                            Exit;
                        end;
               ID_OK :begin
                            EndDialog(Dialog, 1);
                            Exit;
                         end;
               ID_SEARCH :begin
                             RecBuffer := GlobalAllocPtr(GHND,50);
                             GetDlgItemText(Dialog,ID_DISTCODE,RecBuffer,35);
                             Count_Affaires(HInstance,Dialog,RecBuffer);
                             GlobalFreePtr(RecBuffer);
                            {SearchClient(hInstance,Dialog);}
                          end;
               ID_DISTLIST : begin
                                 If HiWORD(LParam)= LBN_SELCHANGE then
                                 begin
                                    Index := SendDlgItemMessage(Dialog,ID_DISTLIST, LB_GETCURSEL, 0, 0);
                                    TmpBuffer := GlobalAllocPtr(GHND,256);
                                    RecBuffer := GlobalAllocPtr(GHND,256);
                                    SendDlgItemMessage(Dialog,ID_DISTLIST,LB_GETTEXT, Index, LongInt(TmpBuffer));
                                    StrLCopy(RecBuffer,TmpBuffer,30);
                                    SetDlgItemText(Dialog,ID_DISTCODE,RecBuffer);
                                    Count_Affaires(HInstance,Dialog,RecBuffer);
                                    GlobalFreePtr(RecBuffer);
                                    GlobalFreePtr(TmpBuffer);
                                 end;
                             end;
               end;
      end;
   D_AccountWndProc := Return;
end;


{-----------------------------------------------------------------------}
{ Function : AboutInit                                                  }
{-----------------------------------------------------------------------}
{ Purpose :                                                             }
{    Initialisation for the D_Account Box                                   }
{-----------------------------------------------------------------------}
{  Parameters : Standart window  parameters                             }
{-----------------------------------------------------------------------}

function D_AccountInit(Window : hWnd; Message,wParam : Word;
                   lParam : LongInt):Integer;
var
   D_AccountProc     : TFarProc;
begin
   D_accountProc := MakeProcInstance(@D_AccountWndProc, hInstance);
   DialogBox(hInstance, 'D_Account', Window, D_AccountProc);  { Modal Dialog !}
   FreeProcInstance(D_AccountProc);
end;



begin
end.