/*  Project Main

	 Copyright  1994. ITD.

	 SUBSYSTEM	:	MAIN.EXE
	 FILE			:	mncusdlg.cpp
	 AUTHOR		:	TK
	 CREATION	:	07 december 1994


	 OVERVIEW
	 ========
	 Source file for implementation of MainCustomerDlg (TDialog).
*/

#include <owl\owlpch.h>
#pragma hdrstop
extern WORD hInst ;
#include "mncusdlg.h"
#include "TUADS.H"

struct sCustom
				{
				char Name[30];
				char Address[255];
				char Phone[20];
				} *Customer;


DEFINE_RESPONSE_TABLE1(MainCustomerDlg, TDialog)
	 EV_BN_CLICKED(IDC_BTNDOWN, ClickedDown),
	 EV_BN_CLICKED(IDC_BTNUP  , ClickedUp),
END_RESPONSE_TABLE;




MainCustomerDlg::MainCustomerDlg (TWindow* parent, TResId resId):
	 TDialog(parent, resId, 0)
{
	EDNAME		= new TEdit(this,IDC_NAME) ;
	EDNUMBER		= new TEdit(this,IDC_NUMBER) ;
	EDTOTAL		= new TEdit(this,IDC_TOTAL) ;
	EDPHONE		= new TEdit(this,IDC_PHONE) ;
	EDADDRES		= new TEdit(this,IDC_ADDRESS) ;
	BTDOWN		= new TButton(this,IDC_BTNDOWN ) ;
	BTUP			= new TButton(this,IDC_BTNUP ) ;


}


MainCustomerDlg::~MainCustomerDlg ()
{
	delete EDNAME   ;
	delete EDNUMBER ;
	delete EDTOTAL  ;
	delete EDPHONE  ;
	delete EDADDRES ;
	delete BTDOWN   ;
	delete BTUP		 ;

	Destroy();
}

void MainCustomerDlg::SetupWindow ()
{
  TDialog::SetupWindow() ;
  PrintRecord(1) ;
}

void MainCustomerDlg::PrintRecord (int nb)
{
  PTable CustomerTable;
  char Current[5] ;
  char NbRecs[5]  ;

  Customer = new(sCustom);
  GetRecord(hInst,"CUSTOME",nb ,(LPSTR)Customer,sizeof(sCustom));
  EDNAME->SetText(Customer->Name);
  EDPHONE->SetText(Customer->Phone) ;
  EDADDRES->SetText(Customer->Address) ;
  delete(Customer);

  CustomerTable = GetTableInfo(hInst,"CUSTOME");
  itoa(CustomerTable->Current,Current,10)  ;
  itoa(CustomerTable->NbRecs,NbRecs,10)  ;
  EDNUMBER->SetText(Current);
  EDTOTAL->SetText(NbRecs)  ;

}

void MainCustomerDlg::ClickedUp ()
{
  PTable CustomerTable;
  CustomerTable = GetTableInfo(hInst,"CUSTOME");
  if ( (CustomerTable->Current) < (CustomerTable->NbRecs) )
  {
		PrintRecord(CustomerTable->Current + 1 ) ;
  }
}

void MainCustomerDlg::ClickedDown()
{
  PTable CustomerTable;
  CustomerTable = GetTableInfo(hInst,"CUSTOME");
  if ( (CustomerTable->Current) > 1 )
  {
		PrintRecord(CustomerTable->Current - 1 ) ;
  }
}


