// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992-1993 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and Microsoft
// QuickHelp and/or WinHelp documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.

#include "stdafx.h"

#ifdef AFX_CORE1_SEG
#pragma code_seg(AFX_CORE1_SEG)
#endif

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Runtime Typing

// jll

// special runtime-class structure for CObject (no base class)
static char BASED_CODE szCObject[] = "CObject";
struct CRuntimeClass AFXAPI_DATA CObject::_runtimeClass =
        { szCObject, sizeof(CObject), 0xffff, NULL, NULL };
static AFX_CLASSINIT _init_CObject(&CObject::_runtimeClass);

CRuntimeClass* CObject::GetRuntimeClass() const
{
    return &CObject::_runtimeClass;
}

void* CObject::BaseAddress() const
    {
    return (void*) this;
    }

# define CAST_CACHE

# ifdef CAST_CACHE
# include <limits.h>
# endif

void* CObject::VirtualCast(const CRuntimeClass* pCast) const
    {
    void* base = BaseAddress();
    const CRuntimeClass* pClass = GetRuntimeClass();

    if (pClass == pCast)
        return base;

    # ifdef CAST_CACHE

    enum { cacheFirst = 0, cacheSize = 128, cacheLast = cacheFirst + cacheSize };
    static int castCache[cacheSize][cacheSize];

    int* pDelta = NULL;

    if (pClass->id < cacheFirst || pClass->id >= cacheLast)
        {
        TRACE1("Cast %s is out of cache\n", pClass->m_lpszClassName);
        }

    else if (pCast->id < cacheFirst || pCast->id >= cacheLast)
        {
        TRACE1("Cast into %s is out of cache\n", pCast->m_lpszClassName);
        }

    else
        {
        pDelta = &castCache[pClass->id - cacheFirst][pCast->id - cacheFirst];

        if (*pDelta == INT_MIN)
            return NULL; // no cast

        if (*pDelta & 1)
            return (char*) base + (*pDelta >> 1); // cache hit: adjust 'this'
        }

    # endif

    const int bot = 64;
    const CRuntimeBase* path[bot];
    int top = bot;

    for (;;)
        {
        if (pClass == pCast)
            {
            // found cast path; perform address adjustment

            void* thisptr = base;

            while (top < bot)
                thisptr = path[top++]->Cast(thisptr);

            # ifdef CAST_CACHE
                if (pDelta)
                    {
                    *pDelta = int((char*) thisptr - (char*) base) << 1 | 1;
                    ASSERT(*pDelta != INT_MIN);
                    }
            # endif

            return thisptr;
            }

        if (pClass->pBase)
            {
            // class has base(s); move down to the first base
            ASSERT(top);
            path[--top] = pClass->pBase;
            pClass = path[top]->pClass;
            continue;
            }

        if (pClass->m_pBaseClass) // MFC single inheritance
            {
            pClass = pClass->m_pBaseClass;
            TRACE2("Cast %s -> %s: MFC path\n", pClass->m_lpszClassName, pCast->m_lpszClassName);
            continue;
            }

        // move up till root reached or right branch found

        while (top != bot && !path[top]->pNext)
            top++;

        if (top == bot)
            {
            // reached root, fail cast

            # ifdef CAST_CACHE
                if (pDelta)
                    *pDelta = INT_MIN;
            # endif

            return NULL;
            }

        // move right
        path[top] = path[top]->pNext;
        pClass = path[top]->pClass;
        }
    }

// leave MS IsKindOf intact
// MFC code is littered with 'if (p->IsKindOf(class)) (class*) p' constructs
// which bypass the MI-aware runtime cast device

CRuntimeBase::CRuntimeBase(CRuntimeClass* pClass, CRuntimeClass* pBase, void* (*pfnCast)(void*)) :
    pClass(pBase), pNext(NULL), Cast(pfnCast)
    {
    for (CRuntimeBase** append = &pClass->pBase; *append; append = &(*append)->pNext)
        ;

    *append = this;
    }

// end jll

BOOL CObject::IsKindOf(const CRuntimeClass* pClass) const
{
	ASSERT(this != NULL);
	// it better be in valid memory, at least for CObject size
	ASSERT(AfxIsValidAddress(this, sizeof(CObject)));

	// simple SI case
	register CRuntimeClass* pClassThis = GetRuntimeClass();
	ASSERT(pClass != NULL);
	ASSERT(pClassThis != NULL);
	while (pClassThis != NULL)
	{
		if (pClassThis == pClass)
			return TRUE;
		pClassThis = pClassThis->m_pBaseClass;
	}
	return FALSE;       // walked to the top, no match
}

/////////////////////////////////////////////////////////////////////////////
// Diagnostic Support

#ifdef _DEBUG
extern "C" void AFXAPI AfxAssertValidObject(const CObject* pOb,
				LPCSTR lpszFileName, int nLine)
{
	if (pOb == NULL)
	{
		TRACE0("ASSERT_VALID fails with NULL pointer\n");
		AfxAssertFailedLine(lpszFileName, nLine);
		return;     // quick escape
	}
	if (!AfxIsValidAddress(pOb, sizeof(CObject)))
	{
		TRACE0("ASSERT_VALID fails with illegal pointer\n");
		AfxAssertFailedLine(lpszFileName, nLine);
		return;     // quick escape
	}

#ifndef _M_I86SM
	// check to make sure the far VTable pointer is valid
	ASSERT(sizeof(CObject) == sizeof(void FAR*));
	if (!AfxIsValidAddress(*(void FAR**)pOb, sizeof(void FAR*), FALSE))
	{
		TRACE0("ASSERT_VALID fails with illegal vtable pointer\n");
		AfxAssertFailedLine(lpszFileName, nLine);
		return;     // quick escape
	}
#endif

	if (!AfxIsValidAddress(pOb, pOb->GetRuntimeClass()->m_nObjectSize))
	{
		TRACE0("ASSERT_VALID fails with illegal pointer\n");
		AfxAssertFailedLine(lpszFileName, nLine);
		return;     // quick escape
	}
	pOb->AssertValid();
}
#endif //_DEBUG


void CObject::AssertValid() const
{
	ASSERT(this != NULL);
}

void CObject::Dump(CDumpContext& dc) const
{
#ifdef _DEBUG
	AFX_DUMP1(dc, "a ", GetRuntimeClass()->m_lpszClassName);
	AFX_DUMP1(dc, " at ", (void*) this);
	AFX_DUMP0(dc, " ");
#else
	dc;
#endif //_DEBUG
}

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// Allocation/Creation

// jll

CObject* CRuntimeClass::CreateObject()
{
	TRY
	{
        if (m_pfnConstruct)
            return m_pfnConstruct();

        TRACE1("Error: Trying to construct object of an abstract class %Fs.\n",
            m_lpszClassName);
        return NULL;
	}
	CATCH_ALL(e)
	{
		// fall through
	}
	END_CATCH_ALL

	TRACE0("Warning: CRuntimeClass::CreateObject failed\n");
	return NULL;
}

// CRuntimeClass::ConstructObject removed

// end jll

////////////////////////////////////////////////////////////////////////////
// Class loader & class serialization

BOOL CObject::IsSerializable() const
{
	return (GetRuntimeClass()->m_wSchema != 0xffff);
}

#ifdef _AFXDLL
// for the shared DLL, we build a sub-list of the CRuntimeClasses during
//   a single DLL or EXE init.  This sub-list gets moved from the
//   global 'pFirstClass' to some other place once the DLL or EXE
//   is properly initialized.
#endif

CRuntimeClass* AFXAPI_DATA CRuntimeClass::pFirstClass = NULL;

AFX_CLASSINIT::AFX_CLASSINIT(register CRuntimeClass* pNewClass)
{
	ASSERT(pNewClass->m_pNextClass == NULL);
	pNewClass->m_pNextClass = CRuntimeClass::pFirstClass;
	CRuntimeClass::pFirstClass = pNewClass;

    // jll
    pNewClass->id = pNewClass->m_pNextClass
        ? pNewClass->m_pNextClass->id  + 1 : 0;
}

#ifdef _DEBUG
void AFXAPI AfxDoForAllClasses(void (*pfn)(const CRuntimeClass*, void*),
	void* pContext)
{
	CRuntimeClass* pClass;

#ifndef _AFXDLL
	// just walk through the simple list of registered classes
	for (pClass = CRuntimeClass::pFirstClass; pClass != NULL;
		pClass = pClass->m_pNextClass)
	{
		(*pfn)(pClass, pContext);
	}
#else
	ASSERT(CRuntimeClass::pFirstClass == NULL); // should be none unattached
	// first walk through the app specific classes
	for (pClass = _AfxGetAppData()->pFirstAppClass; pClass != NULL;
		pClass = pClass->m_pNextClass)
	{
		(*pfn)(pClass, pContext);
	}
	// now walk through the classes in different DLLs
	CDynLinkLibrary* pDLL;
	for (pDLL = _AfxGetAppData()->pFirstDLL; pDLL != NULL;
		pDLL = pDLL->m_pNextDLL)
	{
		for (pClass = pDLL->m_pFirstSharedClass; pClass != NULL;
			pClass = pClass->m_pNextClass)
		{
			(*pfn)(pClass, pContext);
		}
	}
#endif //_AFXDLL
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// Non-diagnostic memory routines
//

#ifndef _AFXDLL

#ifndef _WINDOWS
#include <new.h>
#define _AfxSetNewHandler(pnh)  _set_new_handler(pnh)
#endif

int cdecl AfxNewHandler(size_t /* nSize */)
{
	//  AFX memory allocation will never return "NULL" it will always throw
	//      a memory exception instead
	AfxThrowMemoryException();
	return 0;
}

// hook in our own new_handler
static BOOL AfxInitialize()
{
	(void)_afx_version();
#ifdef _DEBUG
	// Force reference of the following symbols for CodeView
	(void)afxTraceEnabled;
	(void)afxMemDF;
#ifdef _WINDOWS
	(void)afxTraceFlags;
#endif
	if (!AfxDiagnosticInit())
		return FALSE;
#endif //_DEBUG

	_AfxSetNewHandler(AfxNewHandler);
	return TRUE;
}

static BOOL NEAR bInitialized = AfxInitialize();
		// a way to force initialization

#endif //_AFXDLL

/////////////////////////////////////////////////////////////////////////////
