# include <afx.h>
# include <iostream.h>

// exercise MFC extensions to support virtual inheritance of CObject.

// The problem: some parts of MFC expect the CObject part to be at the
// beginning of the object binary representation.
// Those parts seem to fall into 2 categories: object deserialization
// and diagnostics.

# define show(exp) #exp << "=" << (exp) << endl

class Mixin : public virtual CObject
    {
    public:
        Mixin() : mid(0) { }
        Mixin(int mid) : mid(mid) { }

        WORD mid;

    DECLARE_PERSISTENT(Mixin)
    };

BEGIN_PERSISTENT(Mixin, CObject, 0)
PERSISTENT_MEMBER(mid)
END_PERSISTENT

class Thing : public virtual CObject, public Mixin
    {
    public:
        Thing() : tid(0) { }
        Thing(WORD tid, WORD mid) : tid(tid), Mixin(mid)
            {
            cout << "Constructing a Thing(" << tid << ", " << mid << ")";
            cout << " at " << (void*) this << endl;
            }

        virtual void Dump(CDumpContext& dc) const
            {
            dc << "a Thing(" << tid << ", " << mid << ")";
            }

        WORD tid;

    DECLARE_PERSISTENT(Thing)
    };

# if defined(_M_I86MM) || defined(_M_I86SM)

ostream& operator <<(ostream& os, const char __far* str)
    {
    while (*str)
        os << *str++;

    return os;
    }

# endif

BEGIN_PERSISTENT_2(Thing, CObject, Mixin, 0)

    cout << "Serializing a " << GetRuntimeClass()->m_lpszClassName
         << " at " << (void*) this
         << " from CObject base at " << (void*) (CObject*) this << endl;

    PERSISTENT_MEMBER(tid)

END_PERSISTENT

main()
    {
    Thing* thing = new Thing(13, 8); // my birth date
    Mixin* mixin = thing;
    CObject* object = thing;

    cout << show(thing) << show(mixin) << show(object);

    CMemFile file;

        {
        cout << "Storing..." << endl;
        CArchive arc(&file, CArchive::store);
        arc << object << mixin << thing;
        }

    file.SeekToBegin();
    delete thing;

        {
        cout << "Loading..." << endl;
        CArchive arc(&file, CArchive::load);
        arc >> object >> mixin >> thing;
        }

    cout << show(thing) << show(mixin) << show(object);
    cout << show(thing->tid) << show(thing->mid);

    cout << show(CAST(object, Mixin));
    cout << show(CAST(object, CObject));

    # ifdef _DEBUG
    afxDump.SetDepth(1);
    CMemoryState now;
    now.DumpAllObjectsSince();
    # endif

    return 0;
    }
