#include <owl\owlpch.h>
#pragma hdrstop

#include "xlbapp.rh"
#include "xlbdlg.h"
#include "xclb.h"
#include "xblb.h"


DEFINE_RESPONSE_TABLE1(TXLBDialog, TDialog)

	EV_COMMAND(CM_COLORS, CmColors),
	EV_COMMAND(CM_RESET, CmReset),
	EV_COMMAND(CM_SINGLE, CmSingle),
	EV_COMMAND(CM_MULTIPLE, CmMulti),
	EV_COMMAND(CM_SWAP, CmSwap),

	EV_LBN_SETFOCUS(IDL_BUTTON, CmDescribeButtonLB),
	EV_LBN_SETFOCUS(IDL_DISABLED, CmDescribeDisabledLB),
	EV_LBN_SETFOCUS(IDL_SINGLE_MULTI, CmDescribeSingleMultiLB),
	EV_LBN_SETFOCUS(IDL_CHECKED, CmDescribeCheckedLB),
	EV_LBN_SETFOCUS(IDL_COLORED, CmDescribeColoredLB),

END_RESPONSE_TABLE;


void TXLBDialog::InitControls()
{
coloredLB_ 		= new TXListBox(this, IDL_COLORED, TRUE);
checkedLB_ 		= new TXCheckedListBox(this, IDL_CHECKED, TRUE);
buttonLB_  		= new TXButtonListBox(this, IDL_BUTTON);
switchableLB_ 	= new TXListBox(this, IDL_SINGLE_MULTI, TRUE);
disabledLB_		= new TXListBox(this, IDL_DISABLED, TRUE);

multiRadio_ = new TRadioButton(this, CM_MULTIPLE);

descr_ = new TStatic(this, IDT_DESCR);
}



void TXLBDialog::SetupWindow()
{
TDialog::SetupWindow();

// create small font...
// get ansi variable-width font...
HFONT tempFont = (HFONT)GetStockObject(ANSI_VAR_FONT);
if(tempFont)
	{
	LOGFONT lf;
	GetObject(tempFont, sizeof(LOGFONT), (LPSTR)&lf);
	if (lf.lfHeight > 3) lf.lfHeight -= 3;
	lf.lfWidth = 0;
	smallFont_ = new TFont(&lf);
	}
descr_->SetWindowFont(*smallFont_, FALSE);

// set the tabs...
int tabs[1];
tabs[0] = 20;

coloredLB_->SetTabStops(1, tabs);
checkedLB_->SetTabStops(1, tabs);
switchableLB_->SetTabStops(1, tabs);
disabledLB_->SetTabStops(1, tabs);

// fill in listboxes...
FillColoredList(coloredLB_);
FillCheckedList(checkedLB_);
FillButtonList(buttonLB_);
FillSwitchList(switchableLB_);
FillDisabledList(disabledLB_);

// disable some items...
disabledLB_->Enable(0, FALSE);
disabledLB_->Enable(1, FALSE);
disabledLB_->Enable(5, FALSE);
disabledLB_->Enable(7, FALSE);
disabledLB_->Enable(11, FALSE);
disabledLB_->Enable(12, FALSE);

buttonLB_->Enable(10, FALSE);
buttonLB_->Enable(11, FALSE);
buttonLB_->Enable(12, FALSE);
buttonLB_->Enable(13, FALSE);
buttonLB_->Enable(14, FALSE);

multiRadio_->Check();

// set a selection...
coloredLB_->SetSelIndex(0);
}


void TXLBDialog::CleanupWindow()
{
delete smallFont_;
TDialog::CleanupWindow();
}


// displays randomly colored items...
void TXLBDialog::CmColors()
{
srand((unsigned int)::GetTickCount());

int values[] = {0, 64, 128, 192, 255};	// some RGB vals

TClientDC DC(HWindow);
for(int n=0; n<coloredLB_->GetCount(); n++)
	{
	TColor color =
		DC.GetNearestColor(TColor(values[random(5)],
											values[random(5)],
											values[random(5)]));

	if(color != TColor::LtGray)
		coloredLB_->SetTextColor(n, color);
	}
}


// resets colored items...
void TXLBDialog::CmReset()
{
coloredLB_->ResetTextColor(-1);
}


// switches to single-sel listbox...
void TXLBDialog::CmSingle()
{
switchableLB_->MakeSingleSel(TRUE);
}


// switches to multi-sel listbox...
void TXLBDialog::CmMulti()
{
switchableLB_->MakeSingleSel(FALSE);
}


// swaps disabled & enabled items...
void TXLBDialog::CmSwap()
{
for(int n=0; n<disabledLB_->GetCount(); n++)
	disabledLB_->Enable(n, !(disabledLB_->GetEnabled(n)));
}


void TXLBDialog::FillColoredList(TListBox *lb)
{
lb->AddString("TXListBox can");
lb->AddString("contain items");
lb->AddString("which have");
lb->AddString("different");
lb->AddString("colours.");
lb->AddString("--------------");
lb->AddString("Just use");
lb->AddString("SetTextColor()");
lb->AddString("to set the color");
lb->AddString("of an individual");
lb->AddString("item (or all items)");
lb->AddString("in the list.");
lb->AddString("--------------");
lb->AddString("Use the 'Colors'");
lb->AddString("button below to");
lb->AddString("randomly change");
lb->AddString("the text color");
lb->AddString("of all items.");
}

void TXLBDialog::FillCheckedList(TListBox *lb)
{
lb->AddString("TXCheckedListBox");
lb->AddString("is a derivative");
lb->AddString("of TXListBox.");
lb->AddString("--------------");
lb->AddString("This incorporates");
lb->AddString("a checkbox-style");
lb->AddString("multiple selection.");
lb->AddString("--------------");
lb->AddString("Also shown here is the horizontal scrolling");
lb->AddString("capability of TXListBox to cope with larger");
lb->AddString("string items like these. You can specify whether");
lb->AddString("or not you want horizontal scrolling in the");
lb->AddString("listbox constructor. If the items are all small");
lb->AddString("enough to fit in the listbox width, then the");
lb->AddString("bar is not shown.");
}



void TXLBDialog::FillButtonList(TListBox *lb)
{
lb->AddString("Easy");
lb->AddString("To");
lb->AddString("Provide");
lb->AddString("Button");
lb->AddString("Style");
lb->AddString("Items");
lb->AddString("in");
lb->AddString("the");
lb->AddString("TXButtonList");
lb->AddString("Control");
lb->AddString("Some");
lb->AddString("Items");
lb->AddString("Can");
lb->AddString("Be");
lb->AddString("Disabled");
lb->AddString("Also clips strings if too large");
}


void TXLBDialog::FillSwitchList(TListBox *lb)
{
lb->AddString("TXListBox allows");
lb->AddString("you to switch");
lb->AddString("between single");
lb->AddString("and multiple");
lb->AddString("selection modes.");
lb->AddString("--------------");
lb->AddString("Use the radio");
lb->AddString("buttons below");
lb->AddString("to test this");
lb->AddString("feature");
}


void TXLBDialog::FillDisabledList(TListBox *lb)
{
lb->AddString("TXListBox offers");
lb->AddString("disabling of items.");
lb->AddString("--------------");
lb->AddString("Some of the items");
lb->AddString("in this list have");
lb->AddString("been disabled");
lb->AddString("with a call to");
lb->AddString("Enable().");
lb->AddString("--------------");
lb->AddString("Use the Swap");
lb->AddString("button below");
lb->AddString("to toggle the");
lb->AddString("enable state of");
lb->AddString("all the items in");
lb->AddString("the list.");
}


void TXLBDialog::CmDescribeButtonLB()
{
descr_->SetText(
		"TXButtonListBox draws the items in "
		"the form of buttons that can be "
		"depressed to indicate selection. "
		"Item strings are centered on the buttons."
		);
}

void TXLBDialog::CmDescribeDisabledLB()
{
descr_->SetText(
		"TXListBox derivatives allow you to "
		"disable selected items using the "
		"'Enable(int index, BOOL enable)' member.\n\n"
		"Try the Swap button to reverse the "
		"enable status of all items."
		);
}

void TXLBDialog::CmDescribeSingleMultiLB()
{
descr_->SetText(
		"Windows does not allow you to change "
		"the single/multiple selection "
		"attribute dynamically, but TXListBox "
		"provides a 'MakeSingleSel(BOOL)' function "
		"to dynamically toggle the mode of a multiple "
		"selection list.\n\nTry the radio buttons."
		);
}

void TXLBDialog::CmDescribeCheckedLB()
{
descr_->SetText(
		"TXCheckedListBox provides an alternative "
		"selection style. You may prefer this to the "
		"look of the standard listbox.\n\nNote also the "
		"horizontal scrollbar which can be used in all "
		"TXListBox derivatives. It disappears when not required."
		);
}

void TXLBDialog::CmDescribeColoredLB()
{
descr_->SetText(
		"You can color the text of items in a list with "
		"a call to 'SetTextColor(int index, TColor color)'.\n\n"
		"Try the color button to color the items in a random fashion."
		);
}





