//----------------------------------------------------------------
// Copyright  Antony Corbett 1995. All Rights Reserved
// Author:	Antony Corbett
//				Compuserve	100277,330
//				INTERNET		antony@corbetteng.co.uk
//				Tel +44 (1926) 856131,  Fax +44 (1926) 856727
//
// Description:
//		TXCheckedListBox implementation.
//
//		TXCheckedListBox provides 'checkbox-style' selection.
//
//----------------------------------------------------------------

#include <owl\owlpch.h>
#pragma hdrstop

#include "xclb.h"




//***************************************
//		TXCheckedListBox
//***************************************


//----------------------------------------------------------------
// Description:
//		c'tor. Constructs a TXCheckedListBox control to be associated
//		with a TDialog.
//
// Arguments:
//		useHScroll = flag indicating if we should use a
//		horizontal scroll bar.
//
//----------------------------------------------------------------
TXCheckedListBox::TXCheckedListBox(TWindow* parent,
												int resourceId,
												BOOL useHScroll,	// = FALSE
												TModule* module	// = 0
												)
: TXListBox(parent, resourceId, useHScroll, module)
{

}



void TXCheckedListBox::SetupWindow()
{
TXListBox::SetupWindow();

int checkBoxHeight = GetItemHeight(0) - (2 * ::GetSystemMetrics(SM_CYBORDER));
checkBoxWidth_ = (int)((
					LongMulDiv((long)::GetSystemMetrics(SM_CXSCREEN), 100L,
									(long)::GetSystemMetrics(SM_CYSCREEN)) *
										(long)checkBoxHeight) / 100L);
}



//----------------------------------------------------------------
// Description:
//		Draws an item in the list.
//
// Arguments:
//		str = text to draw.
//
//----------------------------------------------------------------
void TXCheckedListBox::DrawListItem(DRAWITEMSTRUCT &drawInfo,
														const char far *str)
{
TDC DC(drawInfo.hDC);
TRect rc(drawInfo.rcItem);

// first erase the item...
TBrush brush(QueryBkColor(drawInfo));
DC.FillRect(rc, brush);

TEXTMETRIC tm;
DC.GetTextMetrics(tm);

// now draw check mark box...
TRect markRect(rc);
markRect.left += (2 * ::GetSystemMetrics(SM_CXBORDER));

markRect.right = markRect.left + checkBoxWidth_ - ::GetSystemMetrics(SM_CXBORDER);
markRect.top += ::GetSystemMetrics(SM_CYBORDER);
markRect.bottom -= ::GetSystemMetrics(SM_CYBORDER);

TPen pen(QueryTextColor(drawInfo));
DC.SelectObject(pen);
DC.Rectangle(markRect);
DC.RestorePen();

if((drawInfo.itemState & ODS_SELECTED) &&
						GetEnabled(drawInfo.itemID))
	{
	// if selected and not disabled...
	markRect.Inflate(-1, -1);
	TBrush brush(TColor(::GetSysColor(COLOR_HIGHLIGHT)));
	DC.FillRect(markRect, brush);

	TPen pen(TColor(::GetSysColor(COLOR_HIGHLIGHTTEXT)));
	DC.SelectObject(pen);

	// draw a check in the box...

	int segmentLen = markRect.Width()/3;

	// find centre of box...
	TPoint centre(markRect.left + (markRect.Width()/2),
						markRect.top + (markRect.Height()/2));
	DC.MoveTo(centre.x + segmentLen, centre.y - segmentLen);
	DC.LineTo(centre.x - segmentLen - 1, centre.y + segmentLen + 1);

	DC.MoveTo(centre.x - segmentLen, centre.y - segmentLen);
	DC.LineTo(centre.x + segmentLen + 1, centre.y + segmentLen + 1);

	DC.RestorePen();
	}

// make room for check mark...
rc.left += checkBoxWidth_ + (4 * ::GetSystemMetrics(SM_CXBORDER));
DrawText(drawInfo, rc, str);
}



//----------------------------------------------------------------
// Description:
//		Query the background color to use for given item.
//
// Returns:
//		Color to use.
//----------------------------------------------------------------
TColor TXCheckedListBox::QueryBkColor(DRAWITEMSTRUCT &drawInfo) const
{
uint origState = drawInfo.itemState;

// Temporarily turn off the 'selected' flag...
drawInfo.itemState &= ~ODS_SELECTED;

TColor color = TXListBox::QueryBkColor(drawInfo);

// return to original state...
drawInfo.itemState = origState;

return color;
}


//----------------------------------------------------------------
// Description:
//		Query the text color to use for given item.
//
// Returns:
//		Color to use.
//----------------------------------------------------------------
TColor TXCheckedListBox::QueryTextColor(DRAWITEMSTRUCT &drawInfo) const
{
TColor color;

if(!GetEnabled(drawInfo.itemID))	// item disabled.
	color = TXListBox::QueryTextColor(drawInfo);
else
	{
	TItemData *id = GetItemDataPtr(drawInfo.itemID);

	color = (id->GetUseSysColor()?
						TColor(::GetSysColor(COLOR_WINDOWTEXT)) :
							id->GetTextColor());
	}

return color;
}



//----------------------------------------------------------------
// Description:
//		Finds the extent of a given listbox string. Used in
//		calculating horizontal scrolling. Override TXListBox
//		behaviour to allow for the checkbox.
//
// Arguments:
//		str = string to find extent of
//
// Returns:
//		extent of string in logical units
//----------------------------------------------------------------
int TXCheckedListBox::FindTextExtent(const char far *str)
{
// allow room for the check box...
return (TXListBox::FindTextExtent(str) +
			checkBoxWidth_ +
			(6 * ::GetSystemMetrics(SM_CXBORDER)));
}



