//----------------------------------------------------------------
// Copyright  Antony Corbett 1995. All Rights Reserved
// Author:	Antony Corbett
//				Compuserve	100277,330
//				INTERNET		antony@corbetteng.co.uk
//				Tel +44 (1926) 856131,  Fax +44 (1926) 856727
//
// Description:
//		Header file for TXButtonListBox class.
//
//		TXButtonListBox provides 'button-style' selection.
//
//----------------------------------------------------------------

#ifndef __TXBLB_H
#define __TXBLB_H

#ifndef __TXLB_H
	#include "xlb.h"
#endif


//***************************************
//		TXButtonListBox
//
//		TXListBox derivative.
//		Provides 'button-style'
//		selection.
//
//		NB - can't use horizontal scroll
//		with this one.
//***************************************

class XLBEXPORT TXButtonListBox : public TXListBox
	{
	public:
		TXButtonListBox(TWindow* parent,
								int resourceId,
								TModule* module = 0);

	protected:
		DECLARE_RESPONSE_TABLE(TXButtonListBox);

		TColor QueryTextColor(DRAWITEMSTRUCT &drawInfo) const;
		TColor QueryBkColor(DRAWITEMSTRUCT &drawInfo) const;

		void DrawText(DRAWITEMSTRUCT &drawInfo,
								const TRect& rc, const char far *str);

		void DrawListItem(DRAWITEMSTRUCT &drawInfo, const char far *str);

		void EvMeasureItem(UINT ctrlId, MEASUREITEMSTRUCT &measure);
  		void ODAFocus(DRAWITEMSTRUCT &drawInfo);

	};




#endif	//__TXBLB_H