#ifndef __XLB_DLG_H
#define __XLB_DLG_H


class TXCheckedListBox;
class TXButtonListBox;
class TXListBox;


class TXLBDialog : public TDialog
	{
	private:
		TXListBox *coloredLB_;
		TXCheckedListBox *checkedLB_;
		TXButtonListBox *buttonLB_;
		TXListBox *switchableLB_;
		TXListBox *disabledLB_;

		TRadioButton *multiRadio_;

		TStatic *descr_;

      TFont *smallFont_;

	public:
		TXLBDialog(TWindow* parent, TResId resId, TModule* module = 0)
		: TDialog(parent, resId, module)
			{
			InitControls();
			}

	protected:
		DECLARE_RESPONSE_TABLE(TXLBDialog);

		void EvLBNSetFocus();

		void CmColors();
		void CmReset();
		void CmSingle();
		void CmMulti();
		void CmSwap();

		void InitControls();
		void SetupWindow();
		void CleanupWindow();

		void FillColoredList(TListBox *lb);
		void FillCheckedList(TListBox *lb);
		void FillButtonList(TListBox *lb);
		void FillSwitchList(TListBox *lb);
		void FillDisabledList(TListBox *lb);

		void CmDescribeButtonLB();
		void CmDescribeDisabledLB();
		void CmDescribeSingleMultiLB();
		void CmDescribeCheckedLB();
		void CmDescribeColoredLB();

	};




#endif	//__XLB_DLG_H
