//----------------------------------------------------------------
// Copyright  Antony Corbett 1995. All Rights Reserved
// Author:	Antony Corbett
//				Compuserve	100277,330
//				INTERNET		antony@corbetteng.co.uk
//				Tel +44 (1926) 856131,  Fax +44 (1926) 856727
//
// Description:
//		Header file for TXCheckedListBox class.
//
//		TXCheckedListBox provides 'checkbox-style' selection.
//
//----------------------------------------------------------------

#ifndef __TXCLB_H
#define __TXCLB_H

#ifndef __TXLB_H
	#include "xlb.h"
#endif


//***************************************
//		TXCheckedListBox
//
//		TXListBox derivative.
//		Provides 'checkbox-style'
//		selection.
//***************************************

class XLBEXPORT TXCheckedListBox : public TXListBox
	{
	protected:
		int checkBoxWidth_;

	public:
		TXCheckedListBox(TWindow* parent, int resourceId,
								BOOL useHScroll = FALSE,
								TModule* module = 0);

	protected:
	   void SetupWindow();
		void DrawListItem(DRAWITEMSTRUCT &drawInfo, const char far *str);
		TColor QueryTextColor(DRAWITEMSTRUCT &drawInfo) const;
		TColor QueryBkColor(DRAWITEMSTRUCT &drawInfo) const;

		int FindTextExtent(const char far *str);

	};




#endif	//__TXCLB_H
