#ifndef WMiscIncluded
#define WMiscIncluded

// copyright (c) 1992, 1993 by Paul Wheaton
// 1916 Brooks #205, Missoula, MT  59801
//
//       phone:  (406)543-1928
//  CompuServe:  72707,207
//    Internet:  72707.207@CompuServe.com

// one big header file for miscelaneous odds n ends
// this file is generally included by all other header files

// these types are for readability or for making sure that you
// use the same size of integral storage across platforms
typedef unsigned char  Bool;
typedef unsigned char  Byte;
typedef signed   char  SByte;
typedef unsigned short Word;
typedef signed   short SWord;
typedef unsigned long  Long;
typedef signed   long  SLong;
typedef unsigned int   UInt;

typedef char* CharStar;  // has to be fed to some macros

// constants related to above types.  The Size of these things will stay the
// same from system to system.

const char  MaxChar  = 255;
const Byte  MaxByte  = 255;
const SByte MaxSByte = 127;
const SByte MinSByte = (-128);
const Word  MaxWord  = 0xFFFF;
const SWord MaxSWord = 32767;
const SWord MinSWord = 0x8000; // (-32768);
const IntLen=sizeof(int);
#if IntLen==2
  const int   MaxInt   = 32767;
  const int   MinInt   = 0x8000; // (-32768);
  const UInt  MaxUInt  = 0xFFFF;
#else
  const int   MaxInt   = 0x7FFFFFFFL; // 2147483647;
  const int   MinInt   = 0x80000000L; // (-2147483648);
  const UInt  MaxUInt  = 0xFFFFFFFFL;
#endif
const SLong MaxSLong = 0x7FFFFFFFL; // 2147483647;
const Long  MaxLong  = 0xFFFFFFFFL;
const SLong MinSLong = 0x80000000L; // (-2147483648);

const long AMillion=1000000L;
const long ABillion=1000000000L;

const Bool True  = 1;
const Bool False = 0;
const Bool Yes   = 1;
const Bool No    = 0;
const Bool On    = 1;
const Bool Off   = 0;

/* the following have values < 0 so that they may be used as alternatives to
   text placement rountines that need positive values */

const int Left=(MinInt+1);
const int Center=(MinInt+2);
const int Right=(MinInt+3);

const int NotFound=-1;
//const long VecObjNotFound=-1;
  // used with some search functions.

/* misc. macros */

SByte  Abs(SByte  x);
SWord  Abs(SWord  x);
int    Abs(int    x);
SLong  Abs(SLong  x);
float  Abs(float  x);
double Abs(double x);

Byte   Max(Byte   a, Byte b  );
SByte  Max(SByte  a, SByte b );
Word   Max(Word   a, Word b  );
SWord  Max(SWord  a, SWord b );
int    Max(int    a, int b   );
UInt   Max(UInt   a, UInt b  );
Long   Max(Long   a, Long b  );
SLong  Max(SLong  a, SLong b );
double Max(double a, double b);

Byte   Min(Byte   a, Byte b  );
SByte  Min(SByte  a, SByte b );
Word   Min(Word   a, Word b  );
SWord  Min(SWord  a, SWord b );
int    Min(int    a, int b   );
UInt   Min(UInt   a, UInt b  );
Long   Min(Long   a, Long b  );
SLong  Min(SLong  a, SLong b );
double Min(double a, double b);

Bool InRange(Byte   Val, Byte   Low, Byte   High);
Bool InRange(SByte  Val, SByte  Low, SByte  High);
Bool InRange(Word   Val, Word   Low, Word   High);
Bool InRange(SWord  Val, SWord  Low, SWord  High);
Bool InRange(int    Val, int    Low, int    High);
Bool InRange(UInt   Val, UInt   Low, UInt   High);
Bool InRange(Long   Val, Long   Low, Long   High);
Bool InRange(SLong  Val, SLong  Low, SLong  High);
Bool InRange(double Val, double Low, double High);
Bool InRange(long double Val, long double Low, long double High);

SLong Round(double Val);      //  .2 => 0    .7 => 1    -.2 => 0    -.7 => -1
SLong RoundUp(double Val);    //  .2 => 1    .7 => 1    -.2 => 0    -.7 => 0
SLong RoundDown(double Val);  //  .2 => 0    .7 => 0    -.2 => -1   -.7 => -1
SLong RoundOut(double Val);   //  .2 => 1    .7 => 1    -.2 => -1   -.7 => -1
SLong RoundIn(double Val);     //  .2 => 0    .7 => 0    -.2 => 0    -.7 => 0

char ToUpper(char C);
char ToLower(char C);

void PigeonHole(Long TotQuan, int ArrayLen, int A[]);
  // spreads TotQuan as evenly as possible over A

Long SystemTick(); // returns the current system tick

#include <dos.h>

#ifndef MAJORBBS

  inline void Delay(int MilliSecs) {delay(MilliSecs);}

  void Sound(float Pitch,int MilliSecs);
    // a little bit of control over the pc speaker

  void Beep(int Num=1);
    // Num is the number of beeps ya want

#endif

#define Randomize() srand((int) time(NULL))
  // Initializes (seeds) the random number generator

#define Random(Max) (int(rand() % Max))
  // returns a random integer in the range of 0 to Max excluding Max

#define DebugPause(Msg)  {puts(Msg "\n"); Delay(2500); }
  // prints the message and then pauses a bit.  Used in debugging

#define CopyArray(Dest,Source) memcpy(Dest,Source,sizeof(Dest))
  // Dest must be something that sizeof will work on

#define CopyString(Dest,Source) (strncpy(Dest,Source,sizeof(Dest)-1),Dest[sizeof(Dest)-1]=0)
  // For the type (Char*,Char*) Dest must be something that sizeof will work on

#define ClearStruct(A) memset((void*)(&A),0,sizeof(A))
  // fill a struct with zeros

#define ClearArray(A) memset(A,0,sizeof(A))
  /* fill an array with zeros.  Array must be defined so that sizeof will
     work on it */

// Given these objects, standard CRC16 will be calculated
Word CRC(void* P,Long Size);
Word CRC(const char* S);

#define Loop while(1)
  // structure for an infinite loop

#define For(TheVar,TheEnd)  for(TheVar=0;TheVar<TheEnd;TheVar++)
  // Makes for a simpler, more readable, less error prone loop.
  // Use  "For(I,10)" instead of "for(I=0;I<10;I++)"

typedef void (* VoidFuncPtr)(void);
typedef Bool (* BoolFuncPtr)(void);
typedef void (* VoidFuncCharPtr)(char);

void BigMemCopy(void* Dest, const void* Source, long Size);

void FatalError(const char*);

#endif

