#ifndef WBtrieveIncluded
#define WBtrieveIncluded

// copyright (c) 1992, 1993 by Paul Wheaton
// 1916 Brooks #205, Missoula, MT  59801
//
//       phone:  (406)543-1928
//  CompuServe:  72707,207
//    Internet:  72707.207@CompuServe.com

#include <WBits.h>

const int BtrieveNormal=0;
const int BtrieveAccelerated=-1;
const int BtrieveReadOnly=-2;
const int BtrieveVerify=-3;
const int BtrieveExclusive=-4;

class Btrieve
  {
      char PosBlock[128]; // storage area for BTrieve
      Bool Closed;
      char* Buffy;  // storage for the current record
      int BuffyLen;
      int LastKey;
      int Stat;
      char* Keys[10];  // where the keys are in Buffy
    public:
      Btrieve(const char* FileName, int BiggestRecSize,int Mode=0);
      ~Btrieve(){Close();}
      void Close();
      // Get functions return the size of the record retrieved - 0 if problem
      int GetFirst(int KeyNum=0);
      int GetLast(int KeyNum=0);
      int GetNext();
      int GetPrev();
      int GetE(int SearchVal, int KeyNum=0);
      int GetE(const char* SearchVal, int KeyNum=0);
      int GetE(long SearchVal, int KeyNum=0);
      int GetG(int SearchVal, int KeyNum=0);
      int GetG(const char* SearchVal, int KeyNum=0);
      int GetG(long SearchVal, int KeyNum=0);
      int GetGE(int SearchVal, int KeyNum=0);
      int GetGE(const char* SearchVal, int KeyNum=0);
      int GetGE(long SearchVal, int KeyNum=0);
      int GetL(int SearchVal, int KeyNum=0);
      int GetL(const char* SearchVal, int KeyNum=0);
      int GetL(long SearchVal, int KeyNum=0);
      int GetLE(int SearchVal, int KeyNum=0);
      int GetLE(const char* SearchVal, int KeyNum=0);
      int GetLE(long SearchVal, int KeyNum=0);
      void* Cur(){return Buffy;}
      Bool Update(); // returns False on any error
      Bool Update(int RecLen);
      Bool Insert(const void* Rec=NULL);
      Bool Insert(const void* Rec,int Len);
      // set the local record and write that to the file
      Bool Insert(int Len){return Insert(NULL,Len);}
      void DelCur(); // the last record loaded up is killed from the database
      long Position();
      int GetDirect(long Pos);
  };

#define CreateBtrieveClass(ClassName,ObjType)                        \
                                                                     \
class ClassName: public Btrieve                                      \
  {                                                                  \
    public:                                                          \
      ClassName(const char* Name,int Mode=BtrieveNormal)             \
          :Btrieve(Name,sizeof(ObjType),Mode){}                      \
      ObjType& Cur(){return *((ObjType*)(Btrieve::Cur()));}          \
      Bool Insert(const ObjType& X){return Btrieve::Insert(&X);}     \
      Bool Insert(const ObjType& X, int Len)                         \
          {return Btrieve::Insert(&X,Len);}                          \
      Bool Insert(){return Btrieve::Insert();}                       \
      Bool Insert(int Len){return Btrieve::Insert(Len);}             \
  };

// internal use only
struct KeySpec
  {
    int Pos;
    int Len;
    BitSet16 Flags;
    long NotUsed;
    char ExtendedType;
    char NullValue;
    long Reserved;
  };

// internal use only
CreateRefVectorClass(KeySpecVec,KeySpec);

// internal use only
struct FileSpec
  {
    int RecLen;
    int PageSize;
    int NumIndexes;
    long Unused;
    BitSet16 Flags;
    int Reserved;
    int PreAllocation;
  };

enum BtrieveKeyType {BKInt,BKStringFast,BKString};
  // BKStringFast will be case sensitive

class CreateBtrieveFile
  {
      FileSpec F;
      KeySpecVec K;
      const char* Name;
      Bool Closed;
      Bool IncludeACS;
    public:
      CreateBtrieveFile(const char* FileName, int RecSize, int PageSize);
      ~CreateBtrieveFile(){Done();}
      void SetVariableLength() {F.Flags[0]=On;} // variable length records
      void SetAutoTrim() {F.Flags[1]=On;} // trim trailing spaces of VLR?
      void SetCompression(){F.Flags[3]=On;}
      void SetKeyOnly(){F.Flags[4]=On;}
      void SetFreeSpaceThreshold(int Percent);  // accepts 10, 20, 30
      void PreAllocatePages(int Pages);
      void DefineKey(int Pos, int Len, BtrieveKeyType BKT, Bool Duplicates,
                     Bool Modifiable, int KeyNum=0);
      void Done();
  };

#endif
