#ifndef WStrIncluded
#define WStrIncluded

// copyright (c) 1992, 1993 by Paul Wheaton
// 1916 Brooks #205, Missoula, MT  59801
//
//       phone:  (406)543-1928
//  CompuServe:  72707,207
//    Internet:  72707.207@CompuServe.com

#include <string.h>
#include <WMisc.h>
#include <stdlib.h>

#define DefaultStringExtra    15
  /*  used internally by "String". Since most strings are very small yet
  will have a little bit more added to them, this extra allocation should
  save quite a bit of time.  The only time it would be a hendrance is when
  an array of strings is created */

class String;
class StackString;
class String40;
class String120;

class BaseString
  {
    protected:
      char* P;   // character string
      int Len;   // Length of string, excluding null character
      int Alloc; // amount of actual storage allocated (including null char)
      friend String;
      friend StackString;
      friend String40;
      friend String120;
    public:
      operator const char*() const {return P;}
      char& operator[](int Index);
      Bool operator<(const BaseString& S) const { return strcmp(P, S.P) < 0; }
      Bool operator>(const BaseString& S) const { return strcmp(P, S.P) > 0; }
      Bool operator<=(const BaseString& S) const { return strcmp(P, S.P) <= 0; }
      Bool operator>=(const BaseString& S) const { return strcmp(P, S.P) >= 0; }
      Bool operator==(const BaseString& S) const;
      Bool operator!=(const BaseString& S) const { return !(*this==S); }

      Bool operator<(const char* CS)  const { return strcmp(P,CS) < 0; }
      Bool operator>(const char* CS)  const { return strcmp(P,CS) > 0; }
      Bool operator<=(const char* CS) const { return strcmp(P,CS) <= 0; }
      Bool operator>=(const char* CS) const { return strcmp(P,CS) >= 0; }
      Bool operator==(const char* CS) const { return strcmp(P,CS) == 0; }
      Bool operator!=(const char* CS) const { return strcmp(P,CS) != 0; }

      friend Bool operator<(const char* cs, const BaseString& S)
        { return strcmp(cs, (S.P)) < 0; }
      friend Bool operator>(const char* cs, const BaseString& S)
        { return strcmp(cs, (S.P)) > 0; }
      friend Bool operator<=(const char* cs, const BaseString& S)
        { return strcmp(cs, (S.P)) <= 0; }
      friend Bool operator>=(const char* cs, const BaseString& S)
        { return strcmp(cs, (S.P)) >= 0; }
      friend Bool operator==(const char* cs, const BaseString& S)
        { return strcmp(cs, (S.P)) == 0; }
      friend Bool operator!=(const char* cs, const BaseString& S)
        { return strcmp(cs, (S.P)) != 0; }

      int Length() const { return Len; }
      void ToLower();  // force all of the string to lower case
      void ToUpper();  // force all of the string to upper case
      int Capacity() const { return Alloc - 1; }
      int Size() const { return (Len+2); } // the current size to store
      int Index(char SearchChar, int StartIndex=0) const;
      int Index(const char* SearchStr, int StartIndex=0) const;
      Bool Find(char SearchChar, int StartIndex=0) const
          {return (Index(SearchChar,StartIndex)!=NotFound);}
      Bool Find(const char* SearchStr, int StartIndex=0) const
          {return (Index(SearchStr,StartIndex)!=NotFound);}
      int Count(char C) const;  // how many of this character occur

      void Delete(int Index=0,int Length=1);
      void DeleteLast();
      void Trim();  //   chop off leading and trailing spaces
      void TrimLead();
      void TrimTrail();
      void TrimTrailTo(char C);
        // remove last chars until C is found, then remove C too!

      char At(int Index) const;
      char operator()(int Index) const {return At(Index);}
      char Last() const; // the last char in the string
      void Clip(int NewLen);  // chop off the right end of the string if there

      String40 Word(int Num=0);
        // using spaces as delimiters, pull out word number 0, 1, 2, etc.
      String40 XWord(int Num=0);
        // same as Word except that the Word is extracted from the original string

      #ifdef MAJORBBS
        void* operator new(size_t size){return malloc(size);}
        void  operator delete(void* p) {free(p);}
      #endif
  };

class String: public BaseString
  {
    protected:
      void ReNew(int NewCapacity);
      void New(); // Uses Alloc
    public:
      String(const char& C, int L=1);
        // String S(' ',20) constructs a string consisting of 20 spaces
      String(int AllocSize);
        // constructor based on size desired or size not yet known
      String(const char*);
        // a char* type string is used to construct a String type string
      String(const BaseString&);
        // creating one String from another
      String(const String&);
      String();
      ~String() {free(P);}

      // assignment operators
      void operator=(const BaseString&);
      void operator=(const char*);
      void operator=(const char);

      // String concatination (S1=S2+S3)
      // String operator+(const StackString& S) const;
      String operator+(const String40& S) const;
      String operator+(const String120& S) const;
      String operator+(const String&) const;
      String operator+(const char*) const;
      String operator+(char C) const;
      friend String operator+(const String40&, const String&);
      friend String operator+(const String120&, const String&);
      friend String operator+(const char* CS, const String& S);
      friend String operator+(char C, const String& S);

      // Appending stuff to a String
      void operator+=(const BaseString&);
      void operator+=(const char*);
      void operator+=(char);

      void Left(int NewSize);  //  resize string and left justify text
      void Right(int NewSize);
      void Center(int NewSize);
      void Just(int Type, int NewSize);
        //  parses out to Left, Right or Center
      void Tail(int NewSize); // works like "Right" cept left chars may be chopped

      int ReAlloc(int NewCapacity);
      String At(int Index, int Length) const;
      String operator()(int Index, int Length) const {return At(Index,Length);}
      char   At(int Index) const {return BaseString::At(Index);}
      char   operator()(int Index) const {return BaseString::At(Index);}
      String Before(int Index) const {return At(0,Index);}
      String Through(int Index) const {return At(0,Index+1);}
      String From(int Index) const {return At(Index,Len-Index);}
      String After(int Index) const {return At(Index+1,Len-Index-1);}

      void Insert(char C,int Index=0);
      void Insert(const char* St,int Index=0);
      void Replace(const char* SearchStr, const char* ReplaceStr);
      void Replace(const char SearchChar, const char* ReplaceStr);
      void Replace(const char* SearchStr, const char ReplaceChar);
      void Replace(const char SearchChar, const char ReplaceChar);
  };

class StackString: public BaseString
  {
    protected:
      friend String;
    public:

      void operator=(const BaseString&);
      void operator=(const char*);
      void operator=(const char);

      void operator+=(const BaseString&);
      void operator+=(const char*);
      void operator+=(char);

      void Left(int NewSize);  //  resize string and left justify text
      void Right(int NewSize);
      void Center(int NewSize);
      void Just(int Type, int NewSize);
      void Tail(int NewSize); // works like "Right" cept left chars may be chopped

      void Sub(StackString& D, int Index, int Length);

      void Insert(char C,int Index=0);
      void Insert(const char* St,int Index=0);
  };

class String40: public StackString
  {
    protected:
      char Buf[41];
      friend String;
    public:
      String40();
      String40(const char& C, int L=1);
      String40(const char*);
      String40(const BaseString&);
      String40(const String40&);

      String40 operator+(const String40& S) const;
      String40 operator+(const char* S) const;
      String40 operator+(char C) const;
      friend String40 operator+(const char* S1, const String40& S2);
      friend String40 operator+(char C, const String40& S);

      String40 At(int Index, int Length) const;
      String40 operator()(int Index, int Length) const {return At(Index,Length);}
      char   At(int Index) const {return BaseString::At(Index);}
      char   operator()(int Index) const {return BaseString::At(Index);}
      String40 Before(int Index) const {return At(0,Index);}
      String40 Through(int Index) const {return At(0,Index+1);}
      String40 From(int Index) const {return At(Index,Len-Index);}
      String40 After(int Index) const {return At(Index+1,Len-Index-1);}
      void Replace(const char* SearchStr, const char* ReplaceStr);
      void Replace(const char SearchChar, const char* ReplaceStr);
      void Replace(const char* SearchStr, const char ReplaceChar);
      void Replace(const char SearchChar, const char ReplaceChar);
  };

class String120: public StackString
  {
    protected:
      char Buf[121];
      friend String;
    public:
      String120();
      String120(const char& C, int L=1);
      String120(const char*);
      String120(const BaseString&);
      String120(const String120&);

      String120 operator+(const String40& S) const;
      String120 operator+(const String120& S) const;
      String120 operator+(const char* S) const;
      String120 operator+(char C) const;
      friend String120 operator+(const String40& S1, const String120& S2);
      friend String120 operator+(const char* S1, const String120& S2);
      friend String120 operator+(char C, const String120& S);

      String120 At(int Index, int Length) const;
      String120 operator()(int Index, int Length) const {return At(Index,Length);}
      char   At(int Index) const {return BaseString::At(Index);}
      char   operator()(int Index) const {return BaseString::At(Index);}
      String120 Before(int Index) const {return At(0,Index);}
      String120 Through(int Index) const {return At(0,Index+1);}
      String120 From(int Index) const {return At(Index,Len-Index);}
      String120 After(int Index) const {return At(Index+1,Len-Index-1);}
      void Replace(const char* SearchStr, const char* ReplaceStr);
      void Replace(const char SearchChar, const char* ReplaceStr);
      void Replace(const char* SearchStr, const char ReplaceChar);
      void Replace(const char SearchChar, const char ReplaceChar);
  };

String40 Str(long);  //  convert integers to plain, unformatted strings
String40 CommaStr(long);
String40 DStr(double Num); // very slow yet works outside of long range
String40 HexStr(Long Num);
String40 OctalStr(Long Num);
String40 Form(const char* Format,double Val);
String40 Form(int FLen,SLong Val);
  // will someday be much faster than using double
String40 Form(int FLen,const double& Val);
String40 Form(int FLen,const Long& Val);
String40 Form(int FLen,const float& Val);
inline String40 Form(int FLen,const int& Val){return Form(FLen,double(Val));}

String StringOf(int HowMany, char What);
String Spaces(int HowMany);

String LeftText(const char* CS, int NewSize);
String RightText(const char* CS, int NewSize);
String CenterText(const char* CS, int NewSize);
String JustText(const char* CS, int Type, int NewSize);
String TailText(const char* CS, int NewSize);
String Trim(const char* S);
String TrimLead(const char* S);
String TrimTrail(const char* S);
inline String ToLower(const char* S){String St=S; St.ToLower(); return St;}
inline String ToUpper(const char* S){String St=S; St.ToUpper(); return St;}

String120 SetFileExtension(const char* OrigName, const char* NewExtension);
String40  FileExtension(const char*);  // returns empty string if no extension
char      DriveLetter(const char*); // current drive returned if no drive specified
String120 SetFileDrive(const char*);
String120 FilePath(const char*);
String120 FileDriveAndPath(const char*);
String120 VerboseFileName(const char*);
String40  RootFileName(const char*); // no extension, drive or path
String40  FileNameAndExtension(const char*);
String120 CleanPath(const char*); // makes sure there is a '\\' as last char

typedef String (* StringFuncPtr)(void);
typedef String40 (* String40FuncPtr)(void);
typedef String120 (* String120FuncPtr)(void);

#endif
