/*****************************************************/
/* testdll.c                                         */
/* -- Demonstrate InsDll DLL.                        */
/*****************************************************/

#include <windows.h>
#include "insdll.h"

char    szApp[] = "TestDll";

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

#define wTimerId    1

int PASCAL
WinMain(HINSTANCE hinsThis, HINSTANCE hinsPrev,
  LPSTR lszCommand, int wShowWindow)
/*****************************************************/
/* -- Entry point.                                   */
/*****************************************************/
    {
    HWND    hwnd;
    MSG     msg;

    if (!hinsPrev)
        {
        /* First instance must register a class. */
        WNDCLASS    wcs;

        wcs.style = CS_HREDRAW | CS_VREDRAW;
        wcs.lpfnWndProc = WndProc;
        wcs.cbClsExtra = 0;
        wcs.cbWndExtra = 0;
        wcs.hInstance = hinsThis;
        wcs.hIcon = LoadIcon(NULL, IDI_APPLICATION);
        wcs.hCursor = LoadCursor(NULL, IDC_ARROW);
        wcs.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
        wcs.lpszMenuName = NULL;
        wcs.lpszClassName = szApp;
        if (!RegisterClass(&wcs))
            return FALSE;
        }

    if (!FRegisterTask())
        return FALSE;

    if (!(hwnd = CreateWindow(szApp, szApp,
      WS_OVERLAPPEDWINDOW, CW_USEDEFAULT,
      CW_USEDEFAULT,
      GetSystemMetrics(SM_CXSCREEN) / 2,
      GetSystemMetrics(SM_CYSCREEN) / 8,
      NULL, NULL, hinsThis, NULL)))
        return FALSE;

    ShowWindow(hwnd, wShowWindow);

    while (GetMessage(&msg, NULL, 0, 0))
        {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
        }

    return FUnregisterTask();
    }

LRESULT CALLBACK
WndProc(HWND hwnd, UINT wm, WPARAM wParam,
  LPARAM lParam)
/*****************************************************/
/* -- Main window procedure.                         */
/*****************************************************/
    {
    switch (wm)
        {
    default:
        break;

    case WM_CREATE:
        return
          SetTimer(hwnd, wTimerId, 1000, NULL) ? 0 : -1;

    case WM_TIMER:
        InvalidateRect(hwnd, NULL, TRUE);
        return 0;

    case WM_PAINT:
        {
        PAINTSTRUCT wps;
        LPSTR       lsz;

        BeginPaint(hwnd, &wps);
        lsz = LszGetTaskData();
        TextOut(wps.hdc, 0, 0, lsz, lstrlen(lsz));
        EndPaint(hwnd, &wps);
        }
        return 0;
        }

     return DefWindowProc(hwnd, wm, wParam, lParam);
    }
