/* Listing 8 - TOOLBAR.H                */

/***** Tool Bar Messages *****/
#define TBM_DESTROYED   WM_USER+1
#define TBM_INITIALIZE  WM_USER+2
#define TBM_GETSTATE    WM_USER+3
#define TBM_SETSTATE    WM_USER+4
#define TBM_SETMYMENU   WM_USER+5
#define TBM_MENUPICKED  WM_USER+6

/***** Tool Bar Styles *****/
#define  TBS_ESCAPE      0x8000
#define  TB_MOVE         0x0001
#define  TB_NEXT_ROW     0x0002
#define  TBS_RADIO       0x0001
#define  TBS_PUSH        0x0002
#define  TBS_TOGGLE      0x0004
#define  TBS_OWNFX       0x0008

/***** Tool Bar Positions *****/
#define TBPOS_PUSH       0x0001
#define TBPOS_NORM       0x0002


/***** Tool Bar Extra Bytes *****/
#define TB_PTR           0
#define TB_COUNT         2


 /* Window styles for Floating & Fixed toolbars */
#define TBSTYLE_FLOAT   WS_POPUP|WS_CAPTION|WS_SYSMENU
#define TBSTYLE_FIXED   WS_POPUP

/***** Tool Bar Data structure *****/
typedef struct tagTB_DATA{
      char *bmNorm;
      char *bmPush;
      WORD style;
      UINT msg_id;
      int state;
      int group;
      HWND hwnd;
      }TB_DATA;

/*****  Function Declarations *****/
long FAR PASCAL ToolWndProc(HWND,UINT,WPARAM,LPARAM);
long FAR PASCAL ButtonProc(HWND,UINT,WPARAM,LPARAM);
BOOL FAR PASCAL EnumButtons(HWND, DWORD);
HWND CreateToolBar(HWND, LONG);
void CreateTB_Btns(HWND,TB_DATA *, int);
void PopRadioBtns(HWND, TB_DATA *);
