/*------------------------------------------------
Listing 7 - Button.C, Button routines for Toolbar
------------------------------------------------*/
#include        <windows.h>
#include        "toolbar.h"
#include        "host.h"

#define WHITEPEN CreatePen(PS_SOLID,0,RGB(255,255,255))
#define GRAYPEN  CreatePen(PS_SOLID,0,RGB(128,128,128))
BOOL            ButtonLogic(HWND);
void    DrawButton(HWND);

long FAR PASCAL ButtonProc(HWND hwnd, UINT message,
                      WPARAM wParam, LPARAM lParam){
TB_DATA  *button;
HWND     hwndNotify;

  switch(message){
  case WM_PAINT:
    ValidateRect(hwnd, NULL);  /* Satisfy windows */
    DrawButton(hwnd);          /* Draw the button */
    break;

  case WM_DESTROY:            /* Getting destroyed */
    button=(TB_DATA *) GetWindowWord(hwnd, 0);
    button->hwnd=NULL;        /* Dereference handle*/
    break;

  case WM_LBUTTONDOWN:        /* Button was pressed?*/
    button=(TB_DATA *) GetWindowWord(hwnd, 0);
    if(ButtonLogic(hwnd)){    /* Status did change  */
      hwndNotify=GetProp(GetParent(hwnd),"NOTIFY");
      if(hwndNotify)        /* If need to notify  */
        SendMessage(hwndNotify, WM_COMMAND,
                    button->msg_id, -1L);
      if(button->style == TBS_RADIO)
        PopRadioBtns(GetParent(hwnd), button);
    }
    break;
    }                         /* switch(message) */

return (DefWindowProc(hwnd,message,wParam,lParam));
}

BOOL ButtonLogic(HWND hwnd){
MSG          msg;
RECT         rect;
UINT         initial_state;
TB_DATA      *button;
static BOOL  overButton;

  button=(TB_DATA *)GetWindowWord(hwnd, 0);
    if((button->state == TBPOS_PUSH) &&
       (button->style & TBS_RADIO))
       return FALSE;

    initial_state=button->state; /* Save init state */
    button->state=TBPOS_PUSH;    /* Push the button */
    DrawButton(hwnd);            /* Draw pushed in  */
    overButton=TRUE;             /* Cursor over btn */
    SetCapture(hwnd);            /* Trap mouse msgs */

  while(1){
    if (GetMessage(&msg, NULL, 0, 0)){
       if(msg.message<WM_MOUSEFIRST ||
          msg.message>WM_MOUSELAST){
          TranslateMessage(&msg);
          DispatchMessage(&msg);
          continue;
        }

      if(msg.message == WM_LBUTTONUP)
        break;
      if(msg.message == WM_MOUSEMOVE){
        GetClientRect(hwnd, &rect);
      if(PtInRect(&rect, MAKEPOINT(msg.lParam))){
        if(overButton)
          continue;
        overButton=TRUE;
        button->state=TBPOS_PUSH;
        DrawButton(hwnd);
      }else{
        if(!overButton)
          continue;
        overButton=FALSE;
        button->state=initial_state;
        DrawButton(hwnd);
      }
      }     /* If WM_MOUSEMOVE (the mouse moved)  */
    }       /* If we had a message if(GetMessage) */
  }         /* while(1) - Loop until we break;    */

  ReleaseCapture();  /* Free the mouse */
  if(!overButton)    /* Get out if not over button */
    return FALSE;    /* Return no change in state  */

  if(button->style & TBS_RADIO)
    button->state=TBPOS_PUSH;
  else if(button->style & TBS_PUSH)
    button->state=TBPOS_NORM;
  else if(button->style & TBS_TOGGLE)
    if(initial_state == TBPOS_NORM)
      button->state=TBPOS_PUSH;
    else    button->state=TBPOS_NORM;

DrawButton(hwnd);    /* Draw in new position   */
return TRUE;         /* Return change in state */
}

void    DrawButton(HWND hButton){
int     offset;      /* Offset to shift bitmap   */
HDC     hdc, hdcMem; /* DC's for drawing, etc.   */
RECT    rect;        /* To get button size       */
BITMAP  bm;          /* Bitmap structure         */
HBITMAP hBitmap;     /* Handle to bitmap to draw */
TB_DATA *button;     /* Data for the button      */

  button=(TB_DATA *) GetWindowWord(hButton, 0);

  /* Load a bitmap for the button we are drawing */
  if(button->state == TBPOS_PUSH)
    hBitmap=LoadBitmap(HINST(hButton),button->bmPush);
  if(button->state==TBPOS_NORM || hBitmap==NULL)
    hBitmap=LoadBitmap(HINST(hButton),button->bmNorm);

    /* Get a DC, select bitmap and calculate offset */
  hdc=GetDC(hButton);
  hdcMem=CreateCompatibleDC(NULL);
  SelectObject(hdcMem, hBitmap);
  GetObject(hBitmap, sizeof(BITMAP),&bm);
  if(button->style & TBS_OWNFX)
    offset=0;
  else offset=(button->state == TBPOS_PUSH) ? 1 : -1;

  /* Draw bitmap and do shading if we need to */
  BitBlt(hdc, offset, offset, bm.bmWidth,
    bm.bmHeight, hdcMem, 0, 0, SRCCOPY);
  if(!(button->style & TBS_OWNFX)){
    GetClientRect(hButton, &rect);
    rect.right--;
    rect.bottom--;

    if(button->state == TBPOS_NORM)
      SelectObject(hdc, WHITEPEN);
    else SelectObject(hdc, GRAYPEN);
    MoveTo(hdc, 0, rect.bottom);
    LineTo(hdc, 0, 0);
    LineTo(hdc, rect.right, 0);

    if(button->state == TBPOS_NORM)
      DeleteObject(SelectObject(hdc, GRAYPEN));
    else DeleteObject(SelectObject(hdc, WHITEPEN));
    LineTo(hdc, rect.right, rect.bottom);
    LineTo(hdc, 0, rect.bottom);
    DeleteObject(SelectObject(hdc,
          GetStockObject(BLACK_PEN)));
  }

DeleteDC(hdcMem);
ReleaseDC(hButton, hdc);
DeleteObject(hBitmap);
}

/* Releases previously selected radio buttons */
void PopRadioBtns(HWND hwnd, TB_DATA *button){
FARPROC lpfnFAR;
  lpfnFAR=MakeProcInstance(EnumButtons, HINST(hwnd));
  EnumChildWindows(hwnd, lpfnFAR,
      MAKELONG(button->hwnd, button->group));
  FreeProcInstance(lpfnFAR);
}

/* Callback function for enumeration procedure */
BOOL FAR PASCAL EnumButtons(HWND hwnd, DWORD lParam){
TB_DATA *button;

  if(LOWORD(lParam) == hwnd)
     return 1;            /* Enumerate next button */

  button=(TB_DATA *) GetWindowWord(hwnd, 0);
  if(button->group==(int)HIWORD(lParam) &&
      button->state==TBPOS_PUSH){
    button->state=TBPOS_NORM;
    DrawButton(hwnd);
  }
return 1;                 /* Enumerate next button */
}
