/*
 *
 *  fcount.c
 *
 *  Written by Dan Goldberg, 1992.
 *  Modified by Leor Zolman, 12/92.
 *    
 *  Usage: fcount [-f]
 *     
 *  Gets directory name, number of files, dos filesize total, and
 *  allocation filesize total (computed using a formula).
 *
 *  Displays info on screen by default. If -f specified, also appends
 *  the info as a |-delimited data record to the file \FILESIZE.DAT
 *  on the current drive.
 *
 *  General formula for total disk space allocated to a file:
 *      Total Allocation Size = ( int(FileSize/Blocksize) + 1) * Blocksize
 *         (unless the Filesize is an even multiple of the Blocksize, 
 *          in which case the total allocation size is simply the Filesize)
 *
 *  Compile (Turbo/Borland C/C++):
 *     bcc fcount.c
 */

#include <stdio.h>
#include <dos.h>
#include <dir.h>
#include <string.h>

#define DISKFILE "\\FILESIZE.DAT"

long get_bsize(void);

int main(int argc, char **argv)
{
    int write_file = 0;             /* Set to 1 if -f option given  */
    int count = 0;                  /* file count                   */
    int blocksize = get_bsize();    /* allocation chunk (block) size*/
    unsigned long totalsize = 0;    /* sum of actual file sizes     */
    unsigned long tallocsize = 0;   /* sum of allocation sizes      */
    unsigned long filesize;         /* size of file being processed */
    char pathname[81];        /* char array to hold directory path */
    struct ffblk fileinfo;

    if (argc == 2 && !strcmp(argv[1], "-f"))
        write_file = 1;

    if( findfirst("*.*", &fileinfo, 0) == -1)
    {
        printf("Empty Directory!\n");
        getcwd(pathname,80);
        count = 0;
    }
    else
        do
        {
            count++;
            getcwd(pathname,80);
            filesize = fileinfo.ff_fsize;   /* actual bytes in the file */
            totalsize += filesize;          /* running total of above   */

            if (!(filesize % blocksize))
                tallocsize += filesize;
            else
                tallocsize += ((filesize / blocksize) + 1 ) * blocksize;
       }
       while(findnext(&fileinfo) == 0);

    printf("%s: %d files, %ld bytes data,  %ld bytes allocated.\n",
            pathname, count, totalsize, tallocsize );

    if (write_file)
    {
            /* redirect output to file in append mode */ 
        freopen(DISKFILE, "a+b", stdout); 
        printf("|\"%s\"|\"%d\"|\"%ld\"|\"%ld\"|\n",
            pathname, count, totalsize, tallocsize );
        fclose(stdout);
    }
    
    return 0;
}



/* BLKSZ.C: standard FAT manipulation routines.
   Look in any of the C 'bibles' -- DEG */

long get_bsize()
{
    struct fatinfo fat;
    unsigned char fatid;
    long block_size;

    getfat(0, &fat);

    return (long)fat.fi_sclus * (long)fat.fi_bysec;
}

