;***********************************************************************
;                             CLEARIT.ASM                              *
;    CLEARIT.COM is a TSR substitute for the COMMAND.COM internal CLS  *
; command.  CLEARIT's CLS clears the video display to 80 x 25 alpha    *
; mode with the attribute set as specified by the (up to) two hex      *
; digits given as a command-line parameter when the TSR is loaded.     *
;    CLEARIT uses the "installable command" undocumented function 0AEh *
; in "multiplex" INT 2Fh, available in DOS versions 3.30 and later.    *
; CLEARIT will not install under earler versions of DOS.               *
;                 Copyright (C) 1991, Murray L. Lesser                 *
;  WARNING:  This code will not assemble correctly with MASM 6.00.     *
;***********************************************************************
CODE    SEGMENT PARA PUBLIC 'CODE'
        ASSUME CS:CODE, DS:CODE, ES:CODE

        ORG     100H
BEGIN:  JMP     INIT

ATTRIB     DB   07                 ;Default attribute (white on black)
ALIGN      4
OLDHANDLER DD   0                  ;Original INT 2Fh vector
COMMAND    DB   3,'CLS'            ;Identity string for this command

NEW_HANDLER:            ;New interrupt 2Fh handler
        CMP     DX,0FFFFH       ;Extra signature word for function 0AEh
        JZ      MAYBE
CHAIN:  JMP     CS:OLDHANDLER   ;Send calling message up the line
MAYBE:     ;Check if this is our command:
;-----------------------------------------------------------------------
;  ON ENTRY:
;     ES and DS point to COMMAND.COM's transient data segment.  DS:SI
;     points to a byte showing the number of bytes in the command name
;     (only) followed by an 11-byte string containing that command name,
;     trailing blanks, and any extension, all in caps. 
;  ON EXIT:
;     Zero flag set if 3-byte command string is "CLS".  Registers saved.
        PUSH    CX              ;Save registers
        PUSH    ES
        PUSH    DI
        PUSH    SI
        PUSH    CS              ;Set ES to this segment
        POP     ES
        MOV     DI,OFFSET COMMAND
        MOV     CX,4
        REPE    CMPSB           ;Check command name
        POP     SI
        POP     DI
        POP     ES
        POP     CX
;-----------------------------------------------------------------------
        JNZ     CHAIN           ;If not ours send message up the line
        CMP     AX,0AE00H       ;Our command, is it first call?
        JNZ     NEXT            ;If not, may be second call
        MOV     AX,0AEFFH       ;Ours, first call, acknowledge we will
        IRET                    ;  handle and return to COMMAND.COM
NEXT:   CMP     AX,0AE01H       ;Our second call?
        JNZ     CHAIN           ;Not our INT 2Fh function (unlikely!)
;  Execute CLS command:
        PUSH    BP              ;Save registers used
        PUSH    AX              ;  (Even though BP not used, save it
        PUSH    BX              ;   anyway.  Some early video BIOS's
        PUSH    CX              ;   changed BP.)
        PUSH    DX
        MOV     AX,3            ;Reset video mode to 80x25 alpha
        INT     10H             ;(Resets to mode 7 if mono adapter)
        MOV     AX,0600H        ;Use "scroll up to blanks" to
        MOV     BH,CS:ATTRIB    ; set all attribute bytes to ATTRIB
        XOR     CX,CX           ; starting at row 0, col 0,
        MOV     DX,184FH        ; and ending at row 23, col 79
        INT     10H
        XOR     AL,AL           ;Tell COMMAND.COM we handled this one
        MOV     DS:[SI],AL      ; by zeroing the command length
        POP     DX
        POP     CX
        POP     BX
        POP     AX
        POP     BP
        IRET                    ; and return to COMMAND.COM
ALIGN 16
; End of resident code - Memory space from here will be released
;=======================================================================
ERRORMES DB     'CLEARIT requires DOS 3.30 or later to install'
         DB     13,10,'$'
INIT:
        MOV     AH,30H          ; Check for proper DOS version:
        INT     21H
        XCHG    AH,AL                   ;Dumb DOS!
        CMP     AX,031EH
        JAE     VERSOK
;  Abnormal end for early DOS version:
        MOV     AH,9                    ;Display error message
        MOV     DX,OFFSET ERRORMES
        INT     21H
        MOV     AX,4C01H                ;Terminate with exit code 1
        INT     21H
VERSOK: MOV     SI,80H                  ;Check command-line attribute
        LODSB
        OR      AL,AL                   ;Anything there?  If not,
        JZ      ENV                     ;  use default attribute
        CBW                             ;Delete leading blanks
        MOV     CX,AX
        MOV     AL,' '
        MOV     DI,SI
        REPE    SCASB
        DEC     DI
        MOV     SI,DI                   ;Check for first hex digit:
        CALL    CHECKIT                 ;Is it valid?
        JC      ENV                     ;If not, use default attribute
        MOV     AH,AL                   ;If so, save first digit
        CALL    CHECKIT                 ;Is there a second valid digit?
        JC      ONE                     ;Only one digit on command line
        MOV     CL,4                    ;Else shift first digit to
        SHL     AH,CL                   ;   high nibble
        OR      AH,AL                   ;   and combine with second
ONE:    MOV     ATTRIB,AH               ;Store in ATTRIB
; Release memory holding CLEARIT's environment block:
ENV:    MOV     AX,ES:[2CH]     ;Environment segment address is here
        MOV     ES,AX
        MOV     AH,49H          ;Release environment memory segment
        INT     21H
; Save and replace INT 2Fh vectors:
        MOV     AX,352FH
        INT     21H
        MOV     WORD PTR OLDHANDLER,BX
        MOV     WORD PTR OLDHANDLER+2,ES
        MOV     AX,252FH;
        MOV     DX,OFFSET NEW_HANDLER
        INT     21H
;  Free memory starting at ERRORMES:
        MOV     DX,OFFSET ERRORMES
        MOV     CL,4
        SHR     DX,CL           ;Now in Paragraphs
        MOV     AX,3100H        ;Terminate and stay resident
        INT     21H

CHECKIT:        ;Subroutine for INIT - If ASCII byte in AL is
                ;a valid hex digit, convert to numeric hex byte.
        LODSB                   ;Load command-line byte
        CMP     AL,"0"
        JL      NOPE            ;Below ASCII "zero"
        CMP     AL,"9"
        JBE     OK              ;Valid numeric digit
        CMP     AL,'A'          ;Try for hex digit above 9
        JL      NOPE            ;Special character between '9' and 'A'
        AND     AL,0DFH         ;Make cap (if letter)
        CMP     AL,'F'          ;Final range check
        JA      NOPE
        ADD     AL,9            ;Convert low nibble to hex digit
OK:     AND     AL,0FH          ;Strip off high nibble
        RET                     ;  and return
NOPE:   STC                     ;Set carry flag to indicate failure
        RET
CODE    ENDS
        END     BEGIN
