//This sample main program may be used to test ANSI C++ code generation scripts.
//In With Class load cppcar.omt.  Run the scripts cpphead0.sct and cppfunc0.sct,
//cpphead1.sct and cppfunc1.sct, cpphead2.sct and cppfunc2.sct or borland scripts.
//Create a project in your C++ environment.  Add cppmain.cpp, vehicle.cpp, 
//car.cpp, motor.cpp, passengr.cpp, tire.cpp, and clllrphn.cpp.
//Comments and suggestions are solicited Richard Felsinger, RCF Associates
//960 Scottland Dr, Mt Pleasant, SC 29464 tele 803-881-3648 71162.755@compuserve.com

#include "car.h"
#include <iostream.h>
#include <cstring.h>

int main ()
{
/*                               
  //With cppcar.omt generate code with cpphead0.sct and cppfunc0.sct
  //This is the simplest code generation using all compiler defaults.
  Car car1;                 //invokes default constructor
  Car car2 (car1);          //invokes default copy constructor
  car1 = car2;              //invokes default assignment operator
  car1.registerIt();
  car1.operate();
  car1.makePhoneCall();
  car1.inflateTire();
  car1.checkPassengerSeatBelt();
  return 0;



*/
/*
  //With cppcar.omt generate code with cpphead1.sct and cppfunc1.sct
  //These scripts use iostream.h
  Car car1;                 //invokes default constructor
  Car car2 (car1);          //invokes default copy constructor
  car1 = car2;              //invokes default assignment operator
  cout << car1;             //invokes operator<< for text output

  Car car3 (55, 0);          //Invokes constructor with arguments
  cout << car3;
  
  Car car4;
  cin >> car4;
  cout << car4;

  if (car1 == car4) cout << "Cars are equal." << "\n";
  else cout << "Cars are not equal." << "\n";

  car1.registerIt();
  car1.operate();
  car1.makePhoneCall();
  car1.inflateTire();
  car1.checkPassengerSeatBelt();
  return 0;
*/
/*
  //With cppcar.omt generate code with cpphead2.sct and cppfunc2.sct
  //This is the simplest code generation using all compiler defaults.

  Car car1;                                                     //Invokes default constructor
  cin >> car1;                          //Invokes input function >>
  cout << car1;                                 //Invokes output function << 

  int aSpeed, aNumber;                  //Create int variables
  long aTotal;                          //Create long variable
  car1.setspeed (55);                                   //Invokes set accessor function
  aSpeed = car1.getspeed();                     //Invokes get accessor function 
  aSpeed = 65;
  Car::settotalCarsBuilt (9999);     //Invokes set accessor function for static data member
  aTotal = Car::gettotalCarsBuilt(); //Invokes get accessor function for static data member
 
  Car car2 (car1);                                //Invokes copy constructor
  Car car3 (55, 0);                                  //Invokes constructor with arguments
  car1 = car2;                                    //Invokes assignment operator
													//Invokes equality operator
  if (car1 == car3) cout << "Cars are equal." << "\n";
  else cout << "Cars are not equal." << "\n";

  try {
	 car1.registerIt(); }                    //Invokes redefined virtual function
  catch (string registerItError) { cout << "RegisterIt Error"; }
  catch (...) { cout << "Unknown Error" << endl; }

  try {
	 car1.operate();  }                     //Invokes a function    
  catch (string operateError) { cout << "Operate Error"; }
  catch (...) { cout << "Unknown Error" << endl; }
  
  car1.setnumber(1111);                 //Invokes set accessor function from base class
  aNumber = car1.getnumber();  //Invokes get accessor function from base class

  Motor motor1;     //Create motor objects
  try {
	 car1.operate(); }          //Invokes traversal function to access aggregation part
  catch (string operateError) { cout << "Operate Error"; }
  catch (...) { cout << "Unknown Error" << endl; }
  
  car1.setMotor(motor1);    //Invokes set accessor function to set aggregation part
  const Motor motor2 = car1.getMotor(); //Invokes get accessor function to get aggregation part

  CellularPhone phone1;       //Create phone objects
  car1.setCellularPhone (&phone1);    //Invokes set accessor function for association object

  try {
	 car1.makePhoneCall(); }        //Invokes traversal function to access association object
  catch (string makePhoneCallError) { cout << "Make Phone Call Error"; }
  catch (...) { cout << "Unknown Error" << endl; }
  
  const CellularPhone phone2 = *car1.getCellularPhone ();  //Invokes get accessor function to get association object
  int phoneStatus = car1.existsCellularPhone ();  //Invokes exists function for association object
  phoneStatus = car1.existsCellularPhone (&phone1);//Invokes exists function for association object

  try {
	 car1.removeCellularPhone();}         //Invokes remove function for association object
  catch (string noCellularPhone) { cout << "No Cellular Phone"; }
  catch (...) { cout << "Unknown Error" << endl; }
  
  Tire tireArray[4];                  //Creates array of tire objects
  Tire* pTireArray = tireArray;       //Creates pointer to the array of tire objects
  pTireArray = (Tire*)car1.getTireCollection(); //Invokes get accessor function for collection of aggregation objects
  car1.setTireCollection (pTireArray);   //Invokes set accessor function for collection of aggregation objects

  const Tire tire1;                       //Creates tire objects
  tire1 = car1.getFirstTire();           //Invokes get accessor function for 1:M aggregation object
  int tireStatus = car1.existsTire (tire1);//Invokes exists function for 1:M aggregation object

  try {
	 car1.inflateTire(); }                                                  //Invokes traversal function for 1:M aggregation object
  catch (string inflateTireError) { cout << "Inflate Tire Error"; }
  catch (...) { cout << "Unknown Error" << endl; }
  
  Passenger passengerArray[4];                                          //Creates array of passengers
  Passenger* pPassengerArray = passengerArray;          //Creates pointer to array of passenger objects
  pPassengerArray = (Passenger*)car1.getPassengerCollection(); //Invokes get accessor function for collection of association objects
  car1.setPassengerCollection (pPassengerArray);   //Invokes set accessor function for collection of association objects
  
  Passenger passenger1, passenger2, passenger3, passenger4; //Create passenger objects

  try {
	 car1.addPassenger(&passenger1);  }       //Invokes add function for 1:M association object
  catch (string PassengerCollectionFull) { cout << "Passenger Collection Full" << endl;}
  catch (...) { cout << "Unknown Error" << endl; }
  
  try {
	 car1.addPassenger(&passenger2); }              //Invokes add function for 1:M association object
  catch (string PassengerCollectionFull) { cout << "Passenger Collection Full" << endl;}
  catch (...) { cout << "Unknown Error" << endl; }
  
  try {
	 car1.addPassenger(&passenger3); }        //Invokes add function for 1:M association object
  catch (string PassengerCollectionFull) { cout << "Passenger Collection Full" << endl;}
  catch (...) { cout << "Unknown Error" << endl; }
  
  try {
	 car1.addPassenger(&passenger4); }        //Invokes add function for 1:M association object
  catch (string PassengerCollectionFull) { cout << "Passenger Collection Full" << endl;}
  catch (...) { cout << "Unknown Error" << endl; }
  
  try {
	 car1.checkPassengerSeatBelt(); }                               //Invokes traversal function for 1:M association object
  catch (string PassengerCollectionFull) { cout << "Passenger Collection Full" << endl;}         
  catch (...) { cout << "Unknown Error" << endl; }
  
  int passengerStatus;
  passengerStatus = car1.existsPassenger ();        //Invokes exists function for association object
  passengerStatus = car1.existsPassenger (&passenger1);   //Invokes exists function for association object

  cin >> car1;                                      //Invokes the >> operator to input text information
  cout << car1;                                     //Invokes the << operator to output text information

  try  {
	car1.removeLastPassenger ();  }                //Invokes removeLast function for 1:M association object
  catch (string noPassengerError) { cout << "No Passenger Error" << endl; }
  catch (...) { cout << "Unknown Error" << endl; }
  
  try {
	 car1.removeAllPassengers(); }            //Invokes removeAll function for 1:M association object
  catch (string noPassengerError) { cout << "No Passenger Error" << endl; }
  catch (...) { cout << "Unknown Error" << endl; }

  return 0;                     //Default destructor is invoked
*/
}
