// demo.cpp				DESKTOP FOR VIRTUAL LISTBOX DEMO
//	written by Gregory K. Miskin
//	COPYRIGHT (C) 1992.  All Rights Reserved.
//	Gregory K. Miskin, Orem, Utah  USA

#define Uses_TChDirDialog
#define Uses_TButton
#define Uses_TStaticText
#define Uses_TDialog
#define Uses_TRect
#define Uses_TStatusLine
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TEventQueue
#define Uses_MsgBox
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TKeys
#define Uses_TEvent
#define Uses_TDeskTop
#define Uses_TApplication

#include <tv.h>
#include <dir.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "commands.hpp"
#include "gadgets.hpp"
#include "browse.hpp"
#include "demondx.hpp"
#include "demo.hpp"

ushort GeneralFlag;

/*------------------------------------------------------------------------*/
int main(int argc, char **argv)
{
	 BrowseDemo demo(argc, argv);        //  Application Instance.

	 demo.run();
	 return 0;
}

/*------------------------------------------------------------------------*/
BrowseDemo::BrowseDemo( int argc, char **argv ) :
	 TProgInit( &BrowseDemo::initStatusLine,
					&BrowseDemo::initMenuBar,
					&BrowseDemo::initDeskTop )
{
	 TRect r = getExtent();                      // Create the clock view.
	 r.a.x = r.b.x - 9;      r.b.y = r.a.y + 1;
	 clock = new TClockView( r );
	 insert(clock);

	 r = getExtent();                            // Create the heap view.
	 r.a.x = r.b.x - 13;     r.a.y = r.b.y - 1;
	 heap = new THeapView( r );
	 insert(heap);
}

/*------------------------------------------------------------------------*/
TStatusLine *BrowseDemo::initStatusLine( TRect r )
{
	 r.a.y = r.b.y - 1;

	 return(new TStatusLine( r,
		*new TStatusDef( 0, 0xFFFF ) +
		  *new TStatusItem( "~Alt-X~ Exit", kbAltX, cmQuit ) +
		  *new TStatusItem( "~F7~ Search", kbF7, cmSearch ) +
		  *new TStatusItem( "~F10~ Menu", kbF10, cmMenu )
		  ));
}

/*------------------------------------------------------------------------*/
void BrowseDemo::Shell()
{
	 suspend();
	 system("cls");
	 cout << "Type EXIT to return...";
	 system( getenv( "COMSPEC"));
	 resume();
	 redraw();
}

/*------------------------------------------------------------------------*/
void BrowseDemo::handleEvent(TEvent &event)
{
	TApplication::handleEvent(event);
	switch(event.what)
	{
		case evCommand:
			switch (event.message.command)
			{
				case cmAboutCmd:            //  About Dialog Box
					About();
					break;

				case cmBrowse:            	 //  view names in the database
					Browse();
					break;

				case cmChDirCmd:            //  Change directory
					ChangeDir();
					break;

				case cmDOS_Cmd:             //  DOS Shell
					Shell();
					break;

				default:                    //  Unknown command
					return;

			  }
			  clearEvent (event);
			  break;

		case evBroadcast:
			switch (event.message.command)
			{
			}

		default:
			return;
  }
}

/*------------------------------------------------------------------------*/
void BrowseDemo::About()
{
	 TDialog *aboutBox = new TDialog(TRect(0, 0, 28, 15), "About VList");

	 aboutBox->insert(new TStaticText(TRect(2, 2, 26, 10),
		  "\003Virtual List Box Demo\n"
		  "\003version date 7/3/92\n"
		  "\003Written in C++ with\n"
		  "\003Borland's TurboVision\n\003\n"
		  "\003Copyright (c) 1992\n"
		  "\003by Gregory K. Miskin\n"
		  "\003(801) 226-3142"
		  ));

	 aboutBox->insert(new TButton(TRect(8, 11, 20, 13), " OK", cmOK, bfDefault));
	 aboutBox->options |= ofCentered;
	 deskTop->execView(aboutBox);
	 destroy( aboutBox );
}

/*------------------------------------------------------------------------*/
void BrowseDemo::ChangeDir()
{
	 TView *d = validView( new TChDirDialog( 0, cmChangeDir ) );

	 if( d != 0 )
		  {
		  deskTop->execView( d );
		  destroy( d );
	 }
}

/*------------------------------------------------------------------------*/
void BrowseDemo::Browse()
{
	TSelectIndex *select_index = (TSelectIndex *) validView(new TSelectIndex());
	deskTop->execView(select_index);
	destroy(select_index);

	TBrowseNames *browse_names = (TBrowseNames *) validView(new TBrowseNames());
	deskTop->execView(browse_names);
	destroy(browse_names);
}

/*------------------------------------------------------------------------*/
void BrowseDemo::OutOfMemory()
{
	 messageBox( "Not enough memory available to complete operation.",
		mfError | mfOKButton );
}

/*------------------------------------------------------------------------*/
void BrowseDemo::idle()
{
	 TProgram::idle();
	 clock->update();
	 heap->update();
}

/*------------------------------------------------------------------------*/
static void closeView(TView *p, void *p1)
{
	 message(p, evCommand, cmClose, p1);
}

/*------------------------------------------------------------------------*/
TMenuBar *BrowseDemo::initMenuBar(TRect r)
{
	TSubMenu& sub1 =
		*new TSubMenu( "~\360~",0) +
			*new TMenuItem( "~A~bout...", cmAboutCmd, kbNoKey) +
			newLine() +
			*new TMenuItem( "~C~hange Dir", cmChDirCmd, kbNoKey) +
			*new TMenuItem( "~D~OS Shell", cmDOS_Cmd, kbNoKey) +
			newLine() +
			*new TMenuItem( "E~x~it", cmQuit, kbAltX, 0, "Alt-X" );

	TSubMenu& sub2 =
		*new TSubMenu( "~N~ames", 0) +
			*new TMenuItem( "~B~rowse", cmBrowse, kbAltB, 0, "Alt-B" );

	r.b.y =  r.a.y + 1;
	return (new TMenuBar( r,sub1 + sub2 ) );
}
