/*
	VIDEO.ZIP

	DPMI routines for accessing a real mode address via _DS under DPMI
	supplied by borland.  No support implied by them OR me!

	Taken from LINEAR.C available on BCPPDOS forum on CIS or on
	the Borland BBS under LINEAR.ZIP.
	- Chet Simpson 3/7/95

	These routines have been tested with Borland V4.0, V4.02 and V4.5
	and they all with with or without optimization.  In previous versions
	of LINEAR.C, _AX = dpmi_call cause the program to return an exception
	handling error (usually 0D or 0E).  This was traced to the fact that
	when converted to assembly, AX was getting mangled and the wrong
	DPMI routine was being called resulting with AllocAndMapMemory to
	return a 0 value for the far pointer to the segmented address.

	Much of this is possible with the help and patience of Patrick Reilly,
	part of TEAMB on the BCPPDOS sig on Compuserve, Thanks Pat!

	A lot of comments have been added, but now every section or line
	has been.

	Remember "DPMI" is a 4 letter word! (Damn, My 'Puter Imploded!)

*/

#ifndef __DPMI32__
  #error This example is for DPMI32 only.
#endif

#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#include <mem.h>
#include "video.h"

// These 2 macro definitions need to be undefine because they screw up
// operations when reading/writing to a video port.
#undef outportb(__portid, __value)	// Undefine 32bit RTL outportb macro
#undef inportb(__portid)				// Undefine 32bit RTL inportb macro

char cmem[524288];						// Lets allocate 512k for the hell of it
char pal[16];								//hold palette values for the MGE loader

#define PAGESIZE 0x1000  				// page size is always 4k

// Assembly macros so bcc32 doesn't need to call tasm32 (for speed)
// These are quick and dirty and may cause exception errors later on
#define LAR_EAX_EBX  {__emit__ (0x0F); __emit__(0x02); __emit__(0xC3);}
#define LSL_EAX_EBX  {__emit__ (0x0F); __emit__(0x03); __emit__(0xC3);}
#define PUSH_BX      {__emit__ (0x53);}
#define POP_BX       {__emit__ (0x5B);}

/*
 These routines are for allocated an alias pointer to a real mode segment.
 This is needed because borlands 32bit rtl doesn't directly support accessing
 memory outside of your data/code area. This is a quick and dirty method
 and only allows ONE PM selector which is hMem. Could easily be modified to
 allow several selectors to be used for accessing more than one portion
 of real mode addressing space. These routines are also not portable!
*/
bits32 hMem;    // This holds the DPMI handle to the address space we will
					// allocate.

// Allocate the memory and alias it to ANY real mode address.
bits32 AllocAndMapMemory (bits32 ConvMemAddr, bits32 Pages, bits32 *hMemBlk)
{
  static bits32 offset;
  static bits32 Len;
  Len = Pages * 0x1000;

  _ECX = Len;					// length in bytes
  _EBX = 0;						// let DPMI pick the address
  _EDX = _EBX;					// uncommitted
  _AX = 0x0504;				// DPMI 0504h: Allocate Linear Memory Block
  geninterrupt (0x31);		// call DPMI
  if (_FLAGS&1)
  {
	*hMemBlk = 0;
	return 0;
  }
  offset = _EBX;				// DPMI returns the new linear address
  *hMemBlk = _ESI;			// DPMI returns the handle to this memory block


// _ESI is already set (but are we SURE?!?, maybe!)
  _EBX = 0;						// start at offset 0 into our memory block
  _ECX = Pages;				// the number of pages to map
  _EDX = ConvMemAddr;		// the target address range to be mapped in
  _AX = 0x0508;				// DPMI 0508h: Map Device in Memory Block
  geninterrupt (0x31);		// call DPMI
  if (_FLAGS&1)
  {
	*hMemBlk = 0;
	return 0;
  }
	return offset;
}

// Get the limit (or size) of the range of memory to access.
bits32 GetLimit (bits16 sel)
{
  _EBX = 0;
  _BX = sel;
  LSL_EAX_EBX;
  return _EAX;
}

// Set the limit of memory to be accessed in selector
void SetLimit (bits16 sel, bits32 off)
{
  static bits16 h,l;
  h = (bits16)(off >> 16);
  l = (bits16)(off & 0xFFFF);
  _AX = 8;								// DPMI 0008h: Set Selector Limit
  _BX = sel;
  _CX = h;
  _DX = l;
  geninterrupt (0x31);				// call DPMI
}

// Get the base or actual address of PM memory
bits32 GetBase (bits16 s)
{
  bits16 upr, lwr;

  PUSH_BX;								// save EBX accross this function
  _EAX = 0;
  _EBX = _EAX;
  _BX = s;
  _AX = 6;								// DPMI 0006h: Get Selector Base Address
  geninterrupt (0x31);				// call DPMI
  POP_BX;								// restore EBX
  if (_FLAGS&1)
	return -1;
  upr = _CX;
  lwr = _DX;
  return ((bits32)upr)*0x10000L+lwr;
}

/*
 Create the memory alias to the PM selector/Address
 linear = AllocAndMapMemory (mem, len, &hMem) seems to work by the "len"
 should actually be length.  May be allocating more memory than needed.

 left for learning purposes. If if fails to run on your machine, try
 changing len to length.
*/
void *CreateMemoryAlias (bits32 mem, bits32 len)
{
  bits32 linear, length;
  length = (len + PAGESIZE -1) / PAGESIZE;
  if(!(linear = AllocAndMapMemory (mem, len, &hMem))) // Allocate address space
	{
	cprintf("DPMI Alloc error!\n\r");
	exit (1);
	}
  SetLimit (_DS, GetLimit (_DS)+(length*PAGESIZE));  // increase DS's limit
  return (void *)(linear - GetBase (_DS));
}
/*
 Remove the alias and deallocare the memory block. Use to cleanup before exit
*/
void DeleteMemoryAlias (void)
{
  _ESI = hMem;
  _ESI = _ESI >> 16;
  _EDI = hMem;                   // SI:DI gets 32-bit hMem
  _AX = 0x0502;                  // DPMI 0502h: Free Memory Block
  geninterrupt (0x31);           // call DPMI
}

/*
 The following routines are for accessing video functions on the PC. They
 are specific and are here so we don't have to use and extra graphics drivers
 such as Borlands BGI.....lower overhead!
*/

// Set a palette
void SetPal(unsigned char col, unsigned char r, unsigned char g, unsigned char b)
{
	outportb(0x03c6, 0xff);	// Make sure PEL will read all 8 bits
	outportb(0x03c8, col);	// tell VGA which color to set
	outportb(0x03c9, r);		// send red spectrum
	outportb(0x03c9, g);		// send green spectrum
	outportb(0x03c9, b);		// send blue spectrum
}

// Wait for vertical refresh
void VWait()
{
	while (!(inportb(0x03da) & 0x08));	// Wait for retrace to start
	while ((inportb(0x03da) & 0x08));	// wait for it to end <WHY? Just do it!>
}

// Lets get started!
int main ()
{

// allocate pointers for accessing video mem
	bits08 *p;                // pointer to the base of this memory

/*
 This maps 128k of conventional memory from A0000 to BFFFF into our
 processes address space so that it's addressable via DS.
*/
	p = (bits08 *)CreateMemoryAlias (0x000A0000, 0x00020000);

/*
 GraphicsMemory is used as a base pointer for the callable routines
 will not be used in emulator as it will never change and all graphic
 emulations will use this alias pointer
*/
	VidScreen = (bits08 *) p;

/*
 Since I am not sure about the following lines, I have commented them
 out.

 Check to see if memory was allocated correctly.  Optimizing may mung up the
 DPMI routines by using cpu registers for something else.  The alias should
 always (I think) point to 1F000000h).  If it does not match print error
 and return. Used for debugging.
*/
//	if(*GraphicsMemory != 0x1F000000ul)
//			{
			cprintf("Press any key to view performance test!\n\r");
			getch();
			GraphTest ();
//			}
//		else
//			{
//			cprintf("DPMI ERROR!:Mem not correctly allocated!\n\r");
//			cprintf("DPMI ALIAS MAPPED AT:%Fp\n\r\n\r", GraphicsMemory);
//			}

// Deallocate DPMI memory alias just to be proper (BURP!)
	DeleteMemoryAlias ();         // clean up before leaving
	return 0;
}


// This is the main line of the testing routine
void GraphTest ()
{
	int i;	// Use as a temporary variable
	int top=0;	// Top of screen
	int bottom,speed, speed1;	// Bottom of screen/speed/speed intermit
	int fast = 5;	// Max speed for moving
	int fast1=0;	// Max speed intermit (create generic float)
	int skip = 16;	// max pixel skipper. decrements

	_AX = 0x0013;          // BIOS: 320x200x256 graphics mode
	geninterrupt (0x10);  //
	loadmge("ROGER.MGE", 0);	// Load roger in at addr 0
	loadmge("ROGER.MGE", 32000); // load roger at offset 32000

/* This routine bounces the picture down the screen.  Its by far accurate
	but if you want to use it, it's yours!
*/
		for(bottom=192, i = bottom;bottom > 0; bottom -=skip, speed1++)
			{
			//scroll down from top to bottom at speed
			for (speed=0, speed1=0; i > top; i -= speed)
				{
				if ((speed1 == fast) && (speed <= fast))
					{
					speed1 = 0;
					speed++;
					}
				speed1++;
				blast320x16( i*160 );	// blast to screen
				}
			//scroll up from bottom to new top at speed
			for (speed = fast, i = top; speed >= 1; i += speed)
				{
				if ((speed1 == 0) && (speed >= 1))
					{
					speed1 = fast;
					speed--;
					}
				speed1--;
				blast320x16( i*160 );	// blast to screen
				}
			if((fast1 == 3) && (fast >= 2))
				{
				fast--;
				fast1=0;
				}
			fast1++;
			}
		blast320x16( 0 );	// blast to screen incase its not at the bottom

// Scroll screen up!
	for(i = 0; i <= 198; i++) blast320x16(i*160 );

	_AX = 0x0003;          // BIOS: 80x25 text mode
	geninterrupt (0x10);
}

/*
 This routine blasts a virtual memory image to the screen
 It takes a long pointer into the buffer area and creates a pointer
 using an integer.  This is to allow blasting anywhere from the 512k
 buffer, but by accessing it with an integer and is much much faster!
*/
void blast320x16(bits32 j)
{

	bits08 *CMem = ((bits08 *) cmem + j);
	int k, i = 0;

		for(k=0; i < 32000;)
		{
		VidScreen[k++] = (bits08)(CMem[i] & 0xf0);
		VidScreen[k++] = (bits08)(CMem[i++] & 0x0f);
		VidScreen[k++] = (bits08)(CMem[i] & 0xf0);
		VidScreen[k++] = (bits08)(CMem[i++] & 0x0f);
		VidScreen[k++] = (bits08)(CMem[i] & 0xf0);
		VidScreen[k++] = (bits08)(CMem[i++] & 0x0f);
		VidScreen[k++] = (bits08)(CMem[i] & 0xf0);
		VidScreen[k++] = (bits08)(CMem[i++] & 0x0f);
		}


}

/*
 Lets load an mge picture for testing. Takes the filename, and the offset into
 the mem buffer. MGE pictures are 16color (with a palette of 64) created on the
 old Color Computer III sold by Radio Shed <tm>!
*/
void loadmge(char *filename, int offset)
{

	int monitor;
	unsigned int count, i, j;
	char data;
	unsigned char r, g, b;

	FILE *mgepic;

	if ((mgepic = fopen(filename, "rb")) == NULL)
	{
		fprintf(stderr, "Cannot open input file.\n");
		exit(1);
	}
	fgetc(mgepic);	//get mode
	for(i = 0; i < 16; i++)	pal[i] = (char)((fgetc(mgepic)) & 0x003f);
	monitor = (char)fgetc(mgepic); // get monitor mode;
	fgetc(mgepic);	// get compression byte
	for(i = 0; i< 32; i++) fgetc(mgepic);	// Skip title

	for(j = offset; j < offset+32000;)
		{
		count = fgetc(mgepic);
		if(count == 0) break;
		data = (char)fgetc(mgepic);
		for(i = 0; (i < count && j < offset+32000); i++)
			cmem[j++] = (char)data;
		}
	//set palettes
	fclose(mgepic);
// convert from composite to rgb using coco color styles
	if (monitor == 1) for(i = 0; i < 16; i++) pal[i] = palconv[pal[i]];

	VWait(); //wait for retrace, may work now with inportb macro undefined
/*
 This is a quick and dirty routine for converting coco palettes to VGA.
 it sets palettes 0-15 (normal 16 color range, then sets every 16th color.
 This is to allow for quick conversion of a 16 color picture for display
 on the 256 color screen.
*/
	for(count = 0; count < 16; count++)
		{
		i=count;
		data = pal[i];
		r = paladj[(((data & 0x20) >> 4) | ((data & 0x04) >> 2))];
		g = paladj[(((data & 0x10) >> 3) | ((data & 0x02) >> 1))];
		b = paladj[(((data & 0x08) >> 2) | (data & 0x01))];
		SetPal((unsigned char)i, r, g, b);
		SetPal((unsigned char)((i << 4)), r, g, b);
		}
		enable();
}

