#include <stdio.h>
#include <process.h>
#include <stdlib.h>

extern int gettype( int * );
extern void loadfont( int );
extern void setmode( int, int );
void setrows( int rows, int mode );
void main( int argc, char **argv );

#define VGA 1

void setrows( rows, mode )
register int rows;
register int mode;
{
    if ( rows == 25 )
        setmode( 2, mode );            /* set 400 scan lines and video mode */
                                       /* 8x16 ROM font is loaded by default */
    else if ( rows == 50 )
    {
        setmode( 2, mode );            /* set 400 scan lines and video mode */
        loadfont( 18 );                /* load 8x8 ROM font */
    }
    else if ( rows == 43 )
    {
        setmode( 1, mode );            /* set 350 scan lines and video mode */
        loadfont( 18 );                /* load 8x8 ROM font */
    }
    else if ( rows == 28 )
    {
        setmode( 2, mode );            /* set 400 scan lines and video mode */
        loadfont( 17 );                /* load 8x14 ROM font */
    }
    else if ( rows == 21 )
    {
        setmode( 1, mode );            /* set 350 scan lines and video mode */
        loadfont( 20 );                /* load 8x16 ROM font */
    }
    else
    {
        setmode( 0, mode );            /* set 200 scan lines and video mode */
        if ( rows == 14 )
            loadfont( 17 );            /* load 8x14 ROM font */
        else                           /* rows == 12 */
            loadfont( 20 );            /* load 8x16 ROM font */
    }
}

void main( argc, argv )
int argc;
char **argv;
{
    register int mode;                 /* requested video mode */
    register int rows;                 /* requested number of rows */
    int orows;                         /* original number of displayed rows */

    if ( argc != 3 )
    {
        printf( "Usage: VGAMODE mode rows\n" );
        exit( 1 );
    }

    if ( gettype( &orows ) != VGA )
    {
        printf( "VGA required\n" );
        exit( 1 );
    }

    mode = atoi( *++argv );
    /*
     *  On the VGA, mode 0 is the same as mode 1, and mode 2 is the same as
     *  mode 3.
     */
    if ( mode != 0 && mode != 1 && mode != 2 && mode != 3 && mode != 7 )
    {
        printf( "Valid mode is 0, 1, 2, 3, or 7\n" );
        exit( 1 );
    }

    rows = atoi( *++argv );
    /* note that 200 scan lines can not be selected for mode 7 */
    if ( rows == 50 || rows == 43 || rows == 28 || rows == 25 || rows == 21 ||
        ( mode != 7 && rows == 14 || rows == 12 ))
    {
        setrows( rows, mode );

        printf( "Number of displayed rows was %d\n", orows );
        exit( 0 );
    }
    printf( "Valid rows is 50, 43, 28, 25, 21, and if mode is not 7, 14 or 12\n"
        );
    exit( 1 );
}
