//vector3.h, By Scott Litvinoff
//3-D vector class definition and useful vector funcs. (ascii to vector, etc.)

#include "stdlib.h"
#include "float.h"
#include "iostream.h"
#include "math.h"
#include "string.h"

class vector3
{
    double xp,yp,zp;    //In rectangular coordinate form

    public:
    vector3(double xpd=0,double ypd=0,double zpd=0)  //Constructor
    {                                                //If no parameters given,
        xp=xpd;                                      //defaults to the
        yp=ypd;                                      //null vector
        zp=zpd;
    }

    friend vector3 operator+(vector3&,vector3&);     // Binary vector addition


    friend vector3 operator*(vector3&,vector3&);     // Vector product
                                                     //  (Cross Product)

    friend double operator|(vector3&,vector3&);      // Vector Dot Product


    friend vector3 operator-(vector3&,vector3&);     // Binary Vector Subtraction


    friend vector3 operator-(vector3&);              // Unary vector negation


    friend vector3 operator+(vector3&);              // Unary vector addition
                                                     //  (Returns same as input)

    friend vector3 operator*(double,vector3&);       // Scalar Multiplication of
                                                     //  Vector

    friend vector3 operator*(vector3&,double);       // Scalar Multiplication of
                                                     //  Vector
    void print()
    {
        cout<<"("<<xp<<","<<yp<<","<<zp<<")";        // Output a vector
    }
    double x()
    {
        return xp;                                   // Returns x component
    }
    double y()
    {
        return yp;                                   // Returns y component
    }
    double z()
    {
        return zp;                                   // Returns z component
    }
};

vector3 atov(char *);                                // Ascii to vector
