/***************************************************************************

 FILENAME - TDEDATE.CPP: class TDEDate definitions
 ----------------------

 Class TDataEntry v1.0 - 07/14/92
 --------------------------------

 ----------------------------------------------------------------------------
 Author: Jeff Penrose * JDP Custom Software * (818) 344-7303 * CIS 71043,3727
 ----------------------------------------------------------------------------

 A data entry class for Borland's Turbo Vision, derived from TInputLine.

 Copyright Notice
 ================
  As this material is ultimately derived from Borland source files, any of
 their copyrights which MAY apply DO apply.
  From the author's standpoint, you may use this material freely and,
 hopefully, post any comments/corrections/enhancements to me at the above-
 noted addresses.  I do ask that you not distribute this material except as
 originally received, including all source/documentation files in their
 original form.
  If you DO modify or enhance any of this code, please send any such changes
 to me for incorporation into a future version.  Any such enhancements will
 be DONATED, without expectation of compensation or incorporation into
 future versions.  Again, if you distribute this code, please do so in its
 original, unmodified form including all source files and documentation.

 Source files included
=====================
 TDE     .DOC: This documentation.
 TDE     .MAN: How to use TDataEntry in your dialog objects
 TDE     .H  : header file containing class declarations for classes
 TDEFLAGS.H  :   "     "      "       flags and command definitions
 TDE     .CPP: Class TDataEntry
 TDEDATE .CPP: Class TDEDate
 TDEPHONE.CPP: Classes TDEPhone, TDEZipCode, TDEState
 TDENUMS .CPP: Class TDEInteger
 TDECLUST.CPP: Non-TDataEntry classes TDEButton, TDERadioButtons, TDECheckBoxes
 TDEINPLI.CPP: Non-TDataEntry class TDEInputLine
 TDELIB  .PRJ: Project for building library TDELIB.LIB
 TDEDEMO .CPP: Demo program
 TDEDEMO .PRJ: Project for building TDEDEMO.EXE

***************************************************************************/
#define   Uses_TDEDate
#include  "tde.h"
#include  <stdio.h>   // sprintf()
#include  <stdlib.h>  // atoi(), atol()
#include  <string.h>  // strlen(), strcpy()

#ifndef __LIMITS_H    // for INT_MIN, INT_MAX
#include <limits.h>
#endif

#ifndef ulong
  typedef unsigned long  ulong;
#endif

ushort TDEDate::defCentury = 19;
ushort TDEDate::dateFormat = dateMDY;

//--------------------------------------------------------------------------
//
// **** TDEDate::getData()
//
//--------------------------------------------------------------------------
void TDEDate::getData( void *rec )
{
  ulong  m, d, y, date = atol(data);
  char *tmp = new char[maxLen + 1];

  if ( date > 0L && tmp != NULL )
  {
    strcpy(tmp, data);
    switch ( dateFormat )
    {
      case dateDMY:
        y = atol(&tmp[4]);
        tmp[4] = EOS;
        m = atol(&tmp[2]);
        tmp[2] = EOS;
        d = atol(tmp);
        break;
      case dateYMD:
        int i = maxLen - 2;
        d = atol(&tmp[i]);
        tmp[i] = EOS;
        i -= 2;
        m = atol(&tmp[i]);
        tmp[i] = EOS;
        y = atol(tmp);
        break;
      default:  // MDY
        y = atol(&tmp[4]);
        tmp[4] = EOS;
        d = atol(&tmp[2]);
        tmp[2] = EOS;
        m = atol(tmp);
    }
    if ( maxLen == 6 )  y += (defCentury * 100L);
    date = (y * 10000L) + (m * 100L) + d;
  }
  else
    date = 0L;

  delete tmp;

  memcpy( rec, &date, dataSize() );
}

//--------------------------------------------------------------------------
//
// **** TDEDate::setData()
//
//--------------------------------------------------------------------------
void TDEDate::setData( void *rec )
{
  ulong  date = *(ulong *)rec;

  if ( date > 0L )
  {
    int m = (int)((date % 10000) / 100 );
    int d = (int)(date % 100 );
    int y = (int)(date / 10000);
    if ( maxLen == 6 )
      y %= 100;

    switch ( dateFormat )
    {
      case dateDMY:
        sprintf(data, "%02d%02d%0*d", d, m, maxLen - 4, y);
        break;
      case dateYMD:
        sprintf(data, "%0*d%02d%02d", maxLen - 4, y, m, d);
        break;
      default:  // MDY
        sprintf(data, "%02d%02d%0*d", m, d, maxLen - 4, y);
    }
  }
  else
    *data = EOS;

  strcpy(origData, data);
}

//--------------------------------------------------------------------------
//
// **** TDEDate::valid()
//
//--------------------------------------------------------------------------
Boolean TDEDate::valid(ushort cmd)
{
  if ( cmd == cmValid && !(maxLen == 6 || maxLen == 8) )
    return False;

  return TDataEntry::valid(cmd);
}

//--------------------------------------------------------------------------
//
// **** TDEDate::validData()
//
//--------------------------------------------------------------------------
#define IsLeap(year) ( ( (year % 4 == 0 && year % 100 != 0) ||\
                         (year % 400 == 0) ) ? 1 : 0 )

#define DaysInMonth(month, year)\
  ( (month == 2) ? 28 + IsLeap(year) :\
    (month == 4 || month ==  6 || month ==  9 || month == 11) ? 30 : 31 )

Boolean TDEDate::validData( const char *, const char *)
{
  int      m, d, y, len = strlen(data);
  Boolean  dataOK = True;
  char     *msg = "\003Invalid date!";

  if ( !TDataEntry::validData(msg, "\003Date is required!") )
    return False;

  if ( len && !(len == 6 || len == 8) )
    dataOK = False;

  if ( dataOK && len )
  {
    char tmp[9];
    strcpy(tmp, data);
    switch ( dateFormat )
    {
      case dateDMY:
        y = atoi(&tmp[4]);
        tmp[4] = EOS;
        m = atoi(&tmp[2]);
        tmp[2] = EOS;
        d = atoi(tmp);
        break;
      case dateYMD:
        int i = maxLen - 2;
        d = atoi(&tmp[i]);
        tmp[i] = EOS;
        i -= 2;
        m = atoi(&tmp[i]);
        tmp[i] = EOS;
        y = atoi(tmp);
        break;
      default:  // MDY
        y = atoi(&tmp[4]);
        tmp[4] = EOS;
        d = atoi(&tmp[2]);
        tmp[2] = EOS;
        m = atoi(tmp);
    }
    if ( maxLen == 6 )
      y += (defCentury * 100);
    if ( m < 1 || m > 12  || d < 1 || y < 1800 ||
         y > 3000 || d > DaysInMonth(m, y)
       )
      dataOK = False;
  }

  if ( !dataOK )
  {
    if ( (globalMode & tdgBeepEnable) != 0 )  cout << (char) 7;
    messageBox(msg, mfError | mfOKButton);
    select();
  }

  return dataOK;
}
