/*
	LISTVIEW.CPP

	Copyright 1987-1993		Ambrose & Muckerman

	Written by:				Dan Ambrose
							Ambrose & Muckerman
	CIS ID:					71062,523
*/

#ifndef _LISTVIEW_
#define _LISTVIEW_

#define Uses_TGroup
#define Uses_TEvent
#define Uses_TKeys
#define Uses_TScrollBar


#include "listview.h"


ListViewer::ListViewer( const TRect& bounds,
						ushort aNumCols,
						TScrollBar *hScrollBar,
						TScrollBar *vScrollBar):
TListViewer(bounds, aNumCols, hScrollBar, vScrollBar)
{
	curSize = 0;
	maxSize = 0;

	setRange(curSize);
	if (hScrollBar)
		hScrollBar->setParams(0, 0, 20, 20, 10);
}

void ListViewer::handleEvent(TEvent &event)
{
	TListViewer::handleEvent(event);

	int val = 0;

	switch(event.what)
	{

	case evKeyDown:
		switch(event.keyDown.keyCode)
		{
		case kbRight:
			if (hScrollBar)
			{
				val = hScrollBar->value + hScrollBar->arStep;
				if(val <= hScrollBar->maxVal)
					hScrollBar->setValue(val);
			}
			break;

		case kbLeft:
			if (hScrollBar)
			{
				val = hScrollBar->value - hScrollBar->arStep;
				if(val >= 0)
					hScrollBar->setValue(val);
			}
			break;

		case kbCtrlRight:
			if (hScrollBar)
			{
				val = hScrollBar->value + hScrollBar->pgStep;
				if(val <= hScrollBar->maxVal)
					hScrollBar->setValue(val);
				break;
			}

		case kbCtrlLeft:
			if (hScrollBar)
			{
				val = hScrollBar->value - hScrollBar->pgStep;
				if(val >= 0)
					hScrollBar->setValue(val);
			}
			break;

		case kbEnter:
			owner->selectNext( False );
			break;

		default:
			return;
		}
		break;

	default:
		return;
	}
	clearEvent(event);
}



#endif	//	_LISTVIEW_