/***************************************************************************

 FILENAME - TDEFLAGS.H: definition of class TDataEntry bit masks and commands
 ---------------------

 Class TDataEntry v1.0 - 07/14/92
 --------------------------------

 ----------------------------------------------------------------------------
 Author: Jeff Penrose * JDP Custom Software * (818) 344-7303 * CIS 71043,3727
 ----------------------------------------------------------------------------

 A data entry class for Borland's Turbo Vision, derived from TInputLine.

 Copyright Notice
 ================
  As this material is ultimately derived from Borland source files, any of
 their copyrights which MAY apply DO apply.
  From the author's standpoint, you may use this material freely and,
 hopefully, post any comments/corrections/enhancements to me at the above-
 noted addresses.  I do ask that you not distribute this material except as
 originally received, including all source/documentation files in their
 original form.
  If you DO modify or enhance any of this code, please send any such changes
 to me for incorporation into a future version.  Any such enhancements will
 be DONATED, without expectation of compensation or incorporation into
 future versions.  Again, if you distribute this code, please do so in its
 original, unmodified form including all source files and documentation.

Source files included
=====================
 TDE     .DOC: This documentation.
 TDE     .MAN: How to use TDataEntry in your dialog objects
 TDE     .H  : header file containing class declarations for classes
 TDEFLAGS.H  :   "     "      "       flags and command definitions
 TDE     .CPP: Class TDataEntry
 TDEDATE .CPP: Class TDEDate
 TDEPHONE.CPP: Classes TDEPhone, TDEZipCode, TDEState
 TDENUMS .CPP: Class TDEInteger
 TDECLUST.CPP: Non-TDataEntry classes TDEButton, TDERadioButtons, TDECheckBoxes
 TDEINPLI.CPP: Non-TDataEntry class TDEInputLine
 TDELIB  .PRJ: Project for building library TDELIB.LIB
 TDEDEMO .CPP: Demo program
 TDEDEMO .PRJ: Project for building TDEDEMO.EXE

***************************************************************************/

#if !defined ( __TDEFLAGS_H )
#define __TDEFLAGS_H

// Global control flags - sets globalMode - affects ALL TDE objects

#define   tdgEnterIsTab     0x0001  // ENTER acts like TAB
#define   tdgBeepEnable     0x0002  // Sound on error
#define   tdgUpDownEnable   0x0004  // UP/DOWN arrows act like TAB/SHFT-TAB
#define   tdgValidNow       0x0008  // Validate when losing focus
#define   tdgValidUpDown    0x0010  // Validate when UP/DOWN keys used
                                    //   (tdmValidNow must also be set)
#define   tdgSelectOnFocus  0x0020  // Select data when focus received
#define   tdgReserved_2     0x0040  //
#define   tdgReserved_3     0x0080  //
#define   tdgReserved_4     0x0100  //
#define   tdgReserved_5     0x0200  //

// Local control flags - sets localMode - local to each TDE object

#define   tdlAutoExit         0x01  // Exit control when last position filled
#define   tdlRightToLeft      0x02  // Calculator-style right-to-left entry
#define   tdlRLArrows         0x04  // Enable right/left arrow keys
#define   tdlInsertEnable     0x08  // Enable insert key
#define   tdlRequired         0x10  // Data is REQUIRED
#define   tdlSecure           0x20  // Security: secureChar mask is used

// Format control flags - sets dataFormat - local to each TDE object

#define   tdfUpper          0x0001  // make uppercase
#define   tdfLower          0x0002  //   "  lowercase
#define   tdfRightJust      0x0004  // right-justify
#define   tdfLeftJust       0x0008  // left    "
#define   tdfCenter         0x000C  // center

// TDataEntry commands

#define  cmTDQueryValid       41456u  // Call validData()'s - warn/select
#define  cmTDQueryValidQuiet  41457u  //  "      "          - don't warn/select
#define  cmTDQueryChanged     41458u  // Check if data changed
#define  cmTDGotoNumber       48459u  // Go to field number
#define  cmTDGotoName         48560u  // Go to field name
#define  cmTDResetData        48561u  // Go to field name

#endif
