/***************************************************************************

 FILENAME - TDECLUST.CPP: classes TDEButton, TDERadioButtons, TDECheckBoxes
 -----------------------

 Class TDataEntry v1.0 - 07/14/92
 --------------------------------

 ----------------------------------------------------------------------------
 Author: Jeff Penrose * JDP Custom Software * (818) 344-7303 * CIS 71043,3727
 ----------------------------------------------------------------------------

 A data entry class for Borland's Turbo Vision, derived from TInputLine.

 Copyright Notice
 ================
  As this material is ultimately derived from Borland source files, any of
 their copyrights which MAY apply DO apply.
  From the author's standpoint, you may use this material freely and,
 hopefully, post any comments/corrections/enhancements to me at the above-
 noted addresses.  I do ask that you not distribute this material except as
 originally received, including all source/documentation files in their
 original form.
  If you DO modify or enhance any of this code, please send any such changes
 to me for incorporation into a future version.  Any such enhancements will
 be DONATED, without expectation of compensation or incorporation into
 future versions.  Again, if you distribute this code, please do so in its
 original, unmodified form including all source files and documentation.

 Source files included
 =====================
 TDE     .DOC: This documentation.
 TDE     .MAN: How to use TDataEntry in your dialog objects
 TDE     .H  : header file containing class declarations for classes
 TDEFLAGS.H  :   "     "      "       flags and command definitions
 TDE     .CPP: Class TDataEntry
 TDEDATE .CPP: Class TDEDate
 TDEPHONE.CPP: Classes TDEPhone, TDEZipCode, TDEState
 TDENUMS .CPP: Class TDEInteger
 TDECLUST.CPP: Non-TDataEntry classes TDEButton, TDERadioButtons, TDECheckBoxes
 TDEINPLI.CPP: Non-TDataEntry class TDEInputLine
 TDELIB  .PRJ: Project for building library TDELIB.LIB
 TDEDEMO .CPP: Demo program
 TDEDEMO .PRJ: Project for building TDEDEMO.EXE

***************************************************************************/
#define  Uses_TDEButton
#define  Uses_TDERadioButtons
#define  Uses_TDECheckBoxes
#define  Uses_TEvent
#define  Uses_TKeys
#include "tde.h"

#ifndef __LIMITS_H          // for UCHAR_MAX
#include <limits.h>
#endif

#ifndef __STRING_H
#include <string.h>
#endif

//--------------------------------------------------------------------------
//
// **** TDEButton::handleEvent()
//
//  Standard TButton which responds to TDataEntry::globalMode member.
//  ** This object has ofPreProcess set, so MUST check if focused, otherwise
//  **  it will screw things up.
//--------------------------------------------------------------------------
void TDEButton::handleEvent( TEvent& event )
{
  if ( (state & sfFocused) && (event.what == evKeyDown) &&
       ((TDataEntry::globalMode & tdgUpDownEnable) != 0) &&
       (event.keyDown.keyCode == kbUp || event.keyDown.keyCode == kbDown)
     )
  {
    event.keyDown.keyCode =
      (event.keyDown.keyCode == kbUp) ? kbShiftTab : kbTab;
  }
  TButton::handleEvent( event );
}

//--------------------------------------------------------------------------
//
// **** TDERadioButtons::TDERadioButtons()
//
//--------------------------------------------------------------------------
TDERadioButtons::TDERadioButtons( const TRect& bounds, TSItem *aStrings,
                                  const char *fName ):
                 TRadioButtons( bounds, aStrings ),
                 fieldName( NULL )
{
  eventMask |= evBroadcast;
  if ( TDataEntry::globalID + 1 > UCHAR_MAX )
    localID = UCHAR_MAX;
  else
    localID = TDataEntry::globalID++;
  if ( fName && (fieldName = new char[strlen(fName) + 1]) != NULL )
    strcpy( fieldName, fName );
}

//--------------------------------------------------------------------------
//
// **** TDERadioButtons::~TDERadioButtons()
//
//--------------------------------------------------------------------------
TDERadioButtons::~TDERadioButtons()
{
  delete fieldName;
}

//--------------------------------------------------------------------------
//
// **** TDERadioButtons::setData()
//
//--------------------------------------------------------------------------
void TDERadioButtons::setData( void *rec )
{
  TRadioButtons::setData(rec);
  origData = value;
}

//--------------------------------------------------------------------------
//
// **** TDERadioButtons::handleEvent()
//
//  Standard TRadioButton which responds to TDataEntry::globalMode member.
//  ** This object has ofPreProcess set, so MUST check if focused, otherwise
//  **  it will screw things up.
//--------------------------------------------------------------------------
void TDERadioButtons::handleEvent( TEvent& event )
{
  if ( event.what == evBroadcast )
  {
    switch ( event.message.command )
    {
      case cmTDQueryChanged:
		if ( origData != value )
          clearEvent(event);
        return;
      case cmTDGotoNumber:
        if ( localID == *(uchar *)event.message.infoPtr )
          clearEvent(event);
        return;
      case cmTDResetData:
        origData = sel;
        return;
      case cmTDGotoName:
        if ( strcmp( fieldName, (char *)event.message.infoPtr ) == 0 )
          clearEvent(event);
        break;
      default:
        break;
    }
  }

  if ( (state & sfFocused) && (event.what == evKeyDown) &&
       (event.keyDown.keyCode == kbEnter) &&
       ((TDataEntry::globalMode & tdgEnterIsTab) != 0)
     )
  {
    event.keyDown.keyCode = kbTab;
  }
  TRadioButtons::handleEvent( event );
}

//--------------------------------------------------------------------------
//
// **** TDECheckBoxes::TDECheckBoxes()
//
//--------------------------------------------------------------------------
TDECheckBoxes::TDECheckBoxes( const TRect& bounds, TSItem *aStrings,
                              const char *fName ) :
               TCheckBoxes( bounds, aStrings ),
               fieldName( NULL )
{
  eventMask |= evBroadcast;
  if ( TDataEntry::globalID + 1 > UCHAR_MAX )
    localID = UCHAR_MAX;
  else
    localID = TDataEntry::globalID++;
  if ( fName && (fieldName = new char[strlen(fName) + 1]) != NULL )
    strcpy( fieldName, fName );
}

//--------------------------------------------------------------------------
//
// **** TDECheckBoxes::TDECheckBoxes()
//
//--------------------------------------------------------------------------
TDECheckBoxes::~TDECheckBoxes()
{
  delete fieldName;
}

//--------------------------------------------------------------------------
//
// **** TDECheckBoxes::setData()
//
//--------------------------------------------------------------------------
void TDECheckBoxes::setData( void *rec )
{
  TCheckBoxes::setData(rec);
  origData = value;
}

//--------------------------------------------------------------------------
//
// **** TDECheckBoxes::handleEvent()
//
//  Standard TCheckBox which responds to TDataEntry::globalMode member.
//  ** This object has ofPreProcess set, so MUST check if focused, otherwise
//  **  it will screw things up.
//--------------------------------------------------------------------------
void TDECheckBoxes::handleEvent( TEvent& event )
{
  if ( event.what == evBroadcast )
  {
    switch ( event.message.command )
    {
      case cmTDQueryChanged:
		if ( origData != value )
		{
			clearEvent(event);
		}
        return;
      case cmTDGotoNumber:
        if ( localID == *(uchar *)event.message.infoPtr )
          clearEvent(event);
        return;
      case cmTDResetData:
        origData = sel;
        return;
      case cmTDGotoName:
        if ( strcmp( fieldName, (char *)event.message.infoPtr ) == 0 )
          clearEvent(event);
        break;
      default:
        break;
    }
  }

  if ( (state & sfFocused) && (event.what == evKeyDown) &&
       (event.keyDown.keyCode == kbEnter) &&
       ((TDataEntry::globalMode & tdgEnterIsTab) != 0)
     )
  {
    event.keyDown.keyCode = kbTab;
  }
  TCheckBoxes::handleEvent( event );
}
