@echo off

if %1.==. goto syntax
if %2.==. goto syntax
echo TSR: %1
echo Hotkey: ALT-%2
if %3.==. goto t1
echo Stack Size: %3
goto t2
:t1
echo Stack Size: 256

:t2
bcc -mt -S -I%ti% %1.c
if errorlevel 1 goto badexit

filter %1
if errorlevel 1 goto badexit

if not %4.==. goto t5
if %3.==. goto t3
tsr -h%2 -s%3 %1
goto t4
:t3
tsr -h%2 %1
:t4
if errorlevel 1 goto badexit
goto t8

:t5
if %3.==. goto t6
tsr -h%2 -s%3 -sc %1
goto t7
:t6
tsr -h%2 -sc %1
:t7
if errorlevel 1 goto badexit

:t8
tasm %1
if errorlevel 1 goto badexit

tlink /t %1
if errorlevel 1 goto badexit

echo TSR build successful.
goto exit

:badexit
echo TSR build unsuccessful.
goto exit

:syntax
echo ----------------------------------------------------------------------
echo t.bat - TSR Build Utility
echo
echo Syntax: t tsrname hotc [ss] [x]
echo
echo tsrname is the name of a .c file to be turned into a TSR (no extension
echo can be specified), hotc is a hotkey character (A-Z or 0-9), and ss is
echo the stack size (the largest valid value is 4096) and is optional.  The
echo default is 256 (all values in bytes).  Any combination of characters
echo appearing after the stack size indicate that TSR should include setup/
echo cleanup function calls.  The purpose of these calls is to allow a TSR
echo to grab additional interrupt vectors prior to being installed and then
echo releasing these vectors prior to being uninstalled.
echo
echo You may specify a search path for include files by setting an environ-
echo ment variable called TI to this path.  For example, suppose that your
echo include files are found in directories C:\BORLANDC\TSR and C:\BORLANDC
echo \INCLUDE:
echo
echo SET TI=C:\BORLANDC\TSR;C:\BORLANDC\INCLUDE
echo
echo BCC will search through all directories in this path for include files
echo
echo Example: t cc c 300
echo ----------------------------------------------------------------------

:exit
