////////////////////////////////////////////
// tsplash.cpp - Source file for TVideoSplash
//
// Author - 		Russell Morris
// Version - 		1.61
// Release date -	July 13, 1995

#include <owl\owlpch.h>
#pragma hdrstop

#include <stdio.h>
#include <stdlib.h>
#include <mmsystem.h>
#include "tsplash.rh"
#include "tsplash.h"
#include "bmpctl.h"
#include "splshapp.rh"

static HHOOK	SplashhookKbd;				// hookchain used by KbdProc

LRESULT CALLBACK SplashKbdProc (int code, WPARAM wParam, LPARAM lParam);

static TVideoSplash* ptSplash;

DEFINE_RESPONSE_TABLE1(TVideoSplash, TDialog)
	EV_WM_LBUTTONDOWN,
	EV_WM_TIMER,
	EV_MESSAGE(WM_VIDEODONE,EvVideoDone),
END_RESPONSE_TABLE;


TVideoSplash::TVideoSplash (SPLASHINFO far* lpSplashInfo,
								TWindow* parent,
								TResId	resId,
								TModule*	module):
	TDialog(parent, resId, module)
{
	::ptSplash 	= this;
	TimesPlayed	= 0;
	Style 		= lpSplashInfo->style;
	TimeOut 		= lpSplashInfo->timeOut;
	BaseId 		= lpSplashInfo->baseId;
	NumBitmaps 	= lpSplashInfo->numBitmaps;
	lstrcpy(Title, lpSplashInfo->title);
	lstrcpy(Info, lpSplashInfo->info);

	if( (Style & Splash::Bmp) && (Style & Splash::Video) )
	{
		//Bmp and Video are mutually exclusive -- defaults to Bmp
		Style = Style & ~(Splash::Video);
		TRACE("Cannot specify both Video and Bmp styles.");
	}

	if(Style & Splash::Video)
	{
		lstrcpy(Filename,	lpSplashInfo->vidFilename);

		if(Style & Splash::RandomBitmaps)
		{
			//Bmp and Video are mutually exclusive -- defaults to Bmp
			Style = Style & ~(Splash::RandomBitmaps);
			TRACE("Cannot specify Splash::RandomBitmaps with Splash::Video.");
		}
	}

	TitleStat = new TStatic(this, IDC_TITLESTATIC);
	InfoStat = new TStatic(this, IDC_INFOSTATIC);
	Border = new TStatic(this, IDC_BORDER);
}


TVideoSplash::~TVideoSplash ()
{
	Destroy();
}


void TVideoSplash::EvLButtonDown (uint, TPoint&)
{
	CloseWindow();
}


void TVideoSplash::SetupWindow ()
{
	TDialog::SetupWindow();


#ifdef __WIN32__
	::SplashhookKbd		= SetWindowsHookEx (WH_KEYBOARD, SplashKbdProc, NULL, GetCurrentThreadId ());
#else
	::SplashhookKbd		= SetWindowsHookEx (WH_KEYBOARD, SplashKbdProc, GetApplication ()->GetInstance (), GetCurrentTask ());
#endif

	TitleStat->SetText(Title);
	InfoStat->SetText(Info);

	StaticHeight = TitleStat->GetWindowRect().Height()*2 + 12;

	if( Style & Splash::Bmp )
		SetupSplashBmp();
	else
	if(Style & Splash::Video)
		SetupSplashVideo();

	CenterWindow();

	SetCapture();
}


void TVideoSplash::SetupSplashBmp()
{
	bc = new TBitmapControl( this, GetBitmapResId(), BaseId );
	bc->Create(); //Have to call Create() because not we aren't in c'tor

	TRect	BmpRect = bc->GetWindowRect();
	TSize BmpSize = BmpRect.Size();

	SetWindowPos(	HWND_TOPMOST,
						0,
						0,
						BmpSize.cx + 16,
						BmpSize.cy + 16 + StaticHeight,
						SWP_NOMOVE);


	Border->SetWindowPos( 0,
								 0, 0,
								 GetWindowRect().Width()-2,
								 GetWindowRect().Height()-2,
								 SWP_NOMOVE);

	TRect ttlRect(6,
					  GetWindowRect().Height()-(TitleStat->GetWindowRect().Height()*2)-8,
					  GetWindowRect().Width()-6,
					  GetWindowRect().Height()-6 );

	TitleStat->MoveWindow(ttlRect);
	TRect verRect(6,
					  GetWindowRect().Height()-InfoStat->GetWindowRect().Height()-6,
					  GetWindowRect().Width()-6,
					  GetWindowRect().Height()-6 );

	InfoStat->MoveWindow(verRect);

	if(TimeOut)
		SetTimer(1, TimeOut, NULL);
}


void TVideoSplash::SetupSplashVideo()
{
	VideoWindow = new TVideoControl(this, IDB_SPLASHBITMAP, Filename);
	VideoWindow->Create();

	TRect vdRect = VideoWindow->GetVideoRect();
	TRect stRect = VideoWindow->GetWindowRect();

	TRect dgRect = GetWindowRect();
	TPoint UlPoint = stRect.TopLeft();
	int x = UlPoint.x + stRect.Width() + 6;
	int y = UlPoint.y + stRect.Height() + 6;
	TPoint dgPoint = dgRect.TopLeft();
	dgRect.Set(dgPoint.x, dgPoint.y, x, y+StaticHeight);
	MoveWindow(dgRect);
	Border->MoveWindow( TRect (0, 0, GetWindowRect().Width()-2, GetWindowRect().Height()-2) );

	TRect ttlRect(6,
					  GetWindowRect().Height()-(TitleStat->GetWindowRect().Height()*2)-8,
					  GetWindowRect().Width()-6,
					  GetWindowRect().Height()-6 );

	TitleStat->MoveWindow(ttlRect);
	TRect verRect(6,
					  GetWindowRect().Height()-InfoStat->GetWindowRect().Height()-6,
					  GetWindowRect().Width()-6,
					  GetWindowRect().Height()-6 );
	InfoStat->MoveWindow(verRect);
}


void TVideoSplash::CloseWindow (int retVal)
{
	ReleaseCapture();
	UnhookWindowsHookEx(SplashhookKbd);

	//
	// Show the main window if it is hidden.  Just in case the MainWindow
	// is not our parent, get a pointer to it via TApplication
	//
	if(Style & Splash::HideMainWindow)
		GetApplication()->GetMainWindow()->ShowWindow(SW_SHOWNORMAL);

	if(Parent)
		Parent->PostMessage(WM_DELETESPLASHDLG, GetDefaultId(), 0);
	else if(GetApplication()->GetMainWindow())
		GetApplication()->GetMainWindow()->PostMessage(WM_DELETESPLASHDLG, GetDefaultId(), 0);

	if(Style & Splash::Bmp)
	{
		delete bc;
		if(TimeOut)
		KillTimer(1);
	}
	else
	if(Style & Splash::Video)
	{
		delete VideoWindow;
	}
	TDialog::CloseWindow(retVal);
}


void TVideoSplash::EvTimer (uint /*timerId*/)
{
	CloseWindow();
}

LRESULT CALLBACK SplashKbdProc (int code, WPARAM wParam, LPARAM lParam)
{
	if ( code >= 0 )
	{
		//
		// I don't test for VK_RETURN because the app could have been started
		// by pressing "enter" on the app's icon in program manager.  For some
		// reason the SplashKbdHook() is called with the VK_ENTER keycode when
		// this happens.  If anyone can think of a fix let me know!
		//
		if( (wParam == VK_SPACE) )
			ptSplash->CloseWindow ();
	}

	return CallNextHookEx (SplashhookKbd, code, wParam, lParam);
}

int TVideoSplash::GetBitmapResId()
{
	int result = BaseId;
	if( Style & Splash::RandomBitmaps )
	{
		//
		// Select a bitmap from the available at random
		//

		result += random(NumBitmaps);
	}
	return result;
}


LRESULT TVideoSplash::EvVideoDone(WPARAM, LPARAM)
{
	TimesPlayed++;
	if( TimesPlayed == TimeOut)
		CloseWindow();
	return TRUE;
}

void TVideoSplash::CenterWindow()
{
	TRect	SplashRect = GetWindowRect();
	RECT	ScreenRectRECT;
	::GetWindowRect(GetDesktopWindow(),&ScreenRectRECT);
	TRect  ScreenRect(ScreenRectRECT.left,
							ScreenRectRECT.top,
							ScreenRectRECT.right,
							ScreenRectRECT.bottom);
	int offsetX = (int) (ScreenRect.Width() - SplashRect.Width()) / 2;
	int offsetY = (int) (ScreenRect.Height() - SplashRect.Height()) / 2;
	SetWindowPos(	HWND_TOPMOST,
						offsetX,
						offsetY,
						0,
						0,
						SWP_NOSIZE);
}


