#include <owl\owlpch.h>
#pragma hdrstop


#include "splshapp.h"


DEFINE_RESPONSE_TABLE1(SplashApp, TApplication)
	 EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
	 EV_MESSAGE(WM_DELETESPLASHDLG, EvDeleteSplashDlg),
	 EV_COMMAND(CM_BMPSPLASH, CmBmpSplash),
	 EV_COMMAND_ENABLE(CM_BMPSPLASH, CeSplash),
	 EV_COMMAND(CM_VIDSPLASH, CmVidSplash),
	 EV_COMMAND_ENABLE(CM_VIDSPLASH, CeSplash),
END_RESPONSE_TABLE;


static SPLASHINFO sBmpInfo;
static SPLASHINFO sVideoInfo;


void SplashApp::InitMainWindow ()
{
	 if(sBmpInfo.style & Splash::HideMainWindow)
		nCmdShow = SW_HIDE;
	 else
	 if (nCmdShow != SW_HIDE)
		  nCmdShow = (nCmdShow != SW_SHOWMINNOACTIVE) ? SW_SHOWNORMAL : nCmdShow;

	 SDIDecFrame *frame = new SDIDecFrame(0, GetName(), 0, false);

	 EnableCtl3d(true);

	 splash = new TVideoSplash(&sBmpInfo);
	 splash->Create();

	 frame->SetIcon(this, IDI_SDIAPPLICATION);
	 frame->AssignMenu(SDI_MENU);
	 frame->Attr.AccelTable = SDI_MENU;
	 SetMainWindow(frame);
	 frame->SetMenuDescr(TMenuDescr(SDI_MENU));
}


SDIDecFrame::SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, bool trackMenuSelection, TModule *module)
	 : TDecoratedFrame(parent, title, clientWnd == 0 ? new TWindow(0, "") : clientWnd, trackMenuSelection, module)
{
}


SDIDecFrame::~SDIDecFrame ()
{
}


void SplashApp::CmHelpAbout ()
{
	GetMainWindow()->MessageBox("TVideoSplash 1.0\r\nRussell Morris 1995\r\n"
										 "With MCI video playing code from Kent Reisdorph",
										 "TVideoSplash test program",
										 MB_ICONINFORMATION);
}

int OwlMain (int , char* [])
{
/************************************************************************/
/* Fill sBmpInfo and sVideoInfo structures                                */
/************************************************************************/
	 sBmpInfo.title			= "TVideoSplash 1.0";
	 sBmpInfo.info	 			= "Released August 4, 1995";
	 sBmpInfo.vidFilename	= 0; //Not needed
	 sBmpInfo.style 			= Splash::HideMainWindow |
									  Splash::RandomBitmaps |
									  Splash::Bmp;
	 sBmpInfo.numBitmaps 	= 6;  //There are 6 splash bitmaps in tsplash.rc
	 sBmpInfo.baseId  		= IDB_SPLASHBITMAP;
	 sBmpInfo.timeOut 		= 3000; //Show it for 3 seconds

	 sVideoInfo.title 			= "TVideoSplash 1.0";
	 sVideoInfo.info  			= "Released August 4, 1995";
	 sVideoInfo.vidFilename 	= "flyby.avi";
	 sVideoInfo.style 			= Splash::HideMainWindow |
										  Splash::Video;
	 sVideoInfo.numBitmaps 	= 0;
	 sVideoInfo.baseId     	= 0;
	 sVideoInfo.timeOut    	= 3; //Play the video 3 times and close

	 try {
		  SplashApp    app;
		  return app.Run();
	 }
	 catch (xmsg& x) {
		  ::MessageBox(0, x.why().c_str(), "Exception", MB_OK);
	 }

	 return -1;
}

LRESULT SplashApp::EvDeleteSplashDlg(WPARAM, LPARAM)
{
	if(splash)
	{
		delete splash;
		splash = 0;
	}
	return (LRESULT) TRUE;
 }


void SplashApp::CeSplash(TCommandEnabler& tce)
{
	tce.Enable();
}


void SplashApp::CmBmpSplash()
{
	if( splash )
		delete splash;
	splash = new TVideoSplash(&sBmpInfo);
	splash->Create();
}

void SplashApp::CmVidSplash()
{
	if( splash )
		delete splash;
	splash = new TVideoSplash(&sVideoInfo);
	splash->Create();
}
