#include <owl\owlpch.h>
#pragma hdrstop

#include "vidctl.h"

DEFINE_RESPONSE_TABLE1(TVideoControl, TControl)
	EV_MESSAGE(MM_MCINOTIFY,MciNotify),
END_RESPONSE_TABLE;

TVideoControl::TVideoControl (TWindow* parent,
										int resourceID,
										char far* vidFilename,
										TModule* module)
 :TControl (parent, resourceID, module)
{
	lstrcpy(Filename, vidFilename);
}

TVideoControl::~TVideoControl ()
{
	mciSendCommand(DeviceID, MCI_CLOSE, 0, NULL);
}

void TVideoControl::SetupWindow ()
{
	TControl::SetupWindow ();
	ClearFlag (wfPredefinedClass);

	DeviceOpen = 0;
	BOOL Bad;
	DWORD ErrCode = OpenVideo();
	Bad = CheckError(ErrCode);
	if (Bad) return;
	if (!Bad) ErrCode = PlayVideo();
	TRect vidRect = GetVideoRect();
	SetWindowPos(0, 0, 0, vidRect.Width(), vidRect.Height(), SWP_NOMOVE );
}


LRESULT
TVideoControl::MciNotify(WPARAM, LPARAM)
{
	MCI_STATUS_PARMS Status;
	Status.dwItem = MCI_STATUS_MODE;
	mciSendCommand(DeviceID, MCI_STATUS,
						MCI_STATUS_ITEM, (DWORD)(LPVOID) &Status);
	if (Status.dwReturn == MCI_MODE_STOP)
	{
		RewindVideo();
		PlayVideo();
		Parent->HandleMessage(WM_VIDEODONE);
	}

	return 0;
}

DWORD
TVideoControl::OpenVideo()
{
	DWORD flags =
		MCI_OVLY_OPEN_PARENT | MCI_OVLY_OPEN_WS |
		MCI_OPEN_ELEMENT;
	UINT devID;
	MCI_OVLY_OPEN_PARMS Open;
	Open.lpstrElementName = Filename;
	Open.dwStyle = WS_CHILD | WS_VISIBLE;
	Open.hWndParent = Parent->GetDlgItem(Attr.Id);
	if (DeviceOpen) {
		devID = DeviceID;
	}
	else devID = 0;
	DWORD ErrCode = mciSendCommand(devID,
		MCI_OPEN, flags, (DWORD)(LPVOID) &Open);
	if (!ErrCode) {
		DeviceOpen = TRUE;
		DeviceID = Open.wDeviceID;
	}
	return ErrCode;
}

DWORD
TVideoControl::PlayVideo()
{
	DWORD flags = MCI_NOTIFY;
	MCI_PLAY_PARMS Play;
	Play.dwCallback = MAKELONG(HWindow,0);
	DWORD ErrCode = mciSendCommand(DeviceID,
		MCI_PLAY, flags, (DWORD)(LPVOID) &Play);
	return ErrCode;
}

RECT
TVideoControl::GetVideoRect()
{
	MCI_OVLY_RECT_PARMS Parms;
	DWORD flags = MCI_WAIT | MCI_OVLY_WHERE_SOURCE;
	mciSendCommand(DeviceID, MCI_WHERE, flags, (DWORD)(LPVOID) &Parms);
	return Parms.rc;
}

void
TVideoControl::RewindVideo()
{
	MCI_SEEK_PARMS Seek;
	mciSendCommand(DeviceID, MCI_SEEK,
		MCI_SEEK_TO_START, (DWORD)(LPVOID) &Seek);
}

BOOL
TVideoControl::CheckError(DWORD errCode)
{
	switch (errCode) {
		case MCIERR_DEVICE_NOT_INSTALLED :
		case MCIERR_CANNOT_LOAD_DRIVER :
		case MCIERR_FILE_NOT_FOUND :
		case MCIERR_OUT_OF_MEMORY :
		if (DeviceOpen) mciSendCommand(DeviceID, MCI_CLOSE, 0, NULL);
		DeviceOpen = FALSE;
// the following three statements are for diagnostics. use them for
// debugging but you may want to take them out of the final product
//		char ErrMsg[256];
//		mciGetErrorString(ErrCode, ErrMsg, sizeof(ErrMsg));
//		MessageBox(0, ErrMsg, "Error", MB_OK);
		return TRUE;
	}
	return FALSE;
}
