#if !defined(__tsplash_h)
#define __tsplash_h


#include <owl\owlpch.h>
#pragma hdrstop


#include "tsplash.rh"
#include "bmpctl.h"
#include "vidctl.h"

#define WM_DELETESPLASHDLG WM_USER + 1

class Splash
{
public:
	enum Style {
			HideMainWindow			= 0x0001,
			RandomBitmaps			= 0x0002,
			Video						= 0x0008,
			Bmp						= 0x0010
	};

};

typedef struct tagSPLASHINFO
{
	Splash::Style	style;
	int				numBitmaps;
	int   			baseId;
	int				timeOut;

	char* far 		title;
	char* far 		info;
	char* far 		vidFilename;
} SPLASHINFO;

class TVideoSplash : public TDialog {
public:

	TVideoSplash( SPLASHINFO far* lpSplashInfo, TWindow* parent = 0,
					TResId resId = IDD_SPLASHDIALOG,	TModule* module = 0);

	virtual ~TVideoSplash ();
	Splash::Style Style;

	virtual void SetupWindow ();
	virtual void CloseWindow (int retVal = 0);

protected:
	 void EvLButtonDown (uint modKeys, TPoint& point);
	 void EvTimer (uint timerId);
	 LRESULT	EvVideoDone(WPARAM, LPARAM);

	 void		SetupSplashBmp ();
	 void		SetupSplashVideo ();
	 void		CenterWindow ();
	 int		GetBitmapResId ();
	 virtual char far* GetClassName() {return "VideoSplash:Russ";}

private:
	 TBitmapControl*	bc;
	 TVideoControl*	VideoWindow;
	 TStatic*			Border;
	 TStatic*			TitleStat;
	 TStatic*			InfoStat;

	 int					NumBitmaps;
	 int					BaseId;
	 int					TimeOut;
	 int					StaticHeight;
	 int					TimesPlayed;

	 char	Title[200];
	 char	Info[200];
	 char	Filename[200];

DECLARE_RESPONSE_TABLE(TVideoSplash);
};

#endif

