/*********************************************************************
 Smallest.C demonstrates the minimum amount of C statements required
 to open a screen file, display a screen, accept data entry into the
 screen buffer and pass it back to the calling program.

 Step 1
    To use this file do the following..
     1 - Change "ScrDemo.003" to the name of your screen buffer.
     2 - Change "ScrDemo.Scr" to the name of your screen file.
     3 - Change "Dupe_Fields" to the name of your screen

 Step 2
    Next open a project file with the following lines (The names
    listed below will also be changed as listed above.)

	 Set (P)ROJECT/(O)PEN PROJECT/(L)OAD PROJECT FILE to "Smallest.prj"
	 press (INSert) and type "Smallest.C"
	 press (INSert) and type "ScrEditC.Lib"

 Step 3
    Next be sure that you..
	Set COMPILER/(P)RIMARY C FILE to SMALLEST.C

	Set OPTIONS/DIRECTORIES/(I)NCLUDE DIRECTORIES to include the
            directory where you have stored "ScrEditC.H".

	Set OPTIONS/DIRECTORIES/(L)IBRARY DIRECTORIES to include the
	    directory where you have stored "ScrEditC.Lib".
	
	Set OPTIONS/COMPILER/(C)ODE GENERATION (C)OMPACT

 Step 4
    Compile and run the program.

 After you performed the steps listed above this program will
 compile and run if the screen file and screen buffers are in the
 current directory.
 ********************************************************************/
#ifndef __COMPACT__
#error This demo requires the COMPACT memory model..
#endif
#include <dos.h>
#include "ScrEdit.H"
#include "ScrDemo.003"

void main()
{
s_init();
s_openscreenfile("ScrDemo.Scr");
initialize_Dupe_Fields_buf();
s_loadscreen("Dupe_Fields");
s_clearscreen(1);
s_cursor = S_INVERSENORMAL;
do{
  s_readscreen();
  if  (s_enter) strcpy(s_usermsg,"PROCESS SCREEN");
  }
while (!s_esc);
s_closescreenfile();
gotoxy(1,25);
}