/*----------------------------------------------------------------------------
                        Turbo ScrEdit Skeleton v.1.0

                       for Turbo Pascal 4.0, 5.0, 5.5

Refer to TURBO SCREDIT TUTOR - PART 2 for a complete discussion on how
this file is to be used.

----------------------------------------------------------------------------*/
/*----
 Skeleton.C compiling instructions. 

 To compile and run the generated programs you must do the following steps.

 First open a project file with the following lines 

  Set (P)ROJECT/(O)PEN PROJECT/(L)OAD PROJECT FILE to "Your_Program_Name.prj"
  press (INSert) and type "Your_Program_Name.C"
  press (INSert) and type "ScrEditC.Lib"

 Next be sure that you..
	Set COMPILER/(P)RIMARY C FILE to Your_Program_Name.C

	Set OPTIONS/DIRECTORIES/(I)NCLUDE DIRECTORIES to include the
            directory where you have stored "ScrEditC.H".

	Set OPTIONS/DIRECTORIES/(L)IBRARY DIRECTORIES to include the
	    directory where you have stored "ScrEditC.Lib".
	
	Set OPTIONS/COMPILER/(C)ODE GENERATION (C)OMPACT

 After you performed the steps listed above this program will
 compile and run if the screen file and screen buffers are in the
 current directory.

----*/
#ifndef __COMPACT__
#error Turbo ScrEdit Evaluation Version uses the COMPACT memory model..
#endif
/*----
Refer to TURBO SCREDIT TUTOR - PART 2 for a complete discussion on how
this file is to be used and how you can modify it if you choose.

This skeleton file is used by Turbo ScrEdit when it generates the basic
program needed for access the screens selected on the source code generation
screen (Main menu option "G").

If you do not wish to have these descriptive comments included in your
programs when you generate them set the F5 configuration line on the
Turbo ScrEdit logo screen to read "Comments:Suppressed".

If you are short of disk space feel free to delete any comments in this file
that begin with a slash "/" and "*----".

    DO NOT DELETE OF ALTER ANY COMMENTS THAT BEGIN WITH "/" and "*--*".



The "Version" header marks the place in the skeleton file where Turbo ScrEdit
will place the header files clause constructed for the compiler that you are using.
----*/
#include <conio.h>
/*--**Version**-*/




/*----
The "Buffers" header marks where Turbo ScrEdit will insert the buffer
handling code according to the setting of the F3 configuration option
set on the logo screen.
You will either find a group of #include statements here or the actual
screen buffer definitions and initialization procedures will have been
copied into the file at this point.
----*/
/*--**Buffers**-*/




/*---- **User Variables**
The "user variables" section can be completely removed in your programs.
The variables defined here are used to allow the default program file
generated by Turbo ScrEdit to change screens when F1 is pressed. You
not need this in your programs.
----*/
int Demo_Screen_Pointer;
int Demo_Current_Screen;
int Demo_Load_Screen;
int Demo_Mode;




/*---- ** Example of loading and displaying screens**
The code in this section is also used to switch screens when F1 key
is pressed. You will only be interested in the "LoadScreen" statements
that have the screen names inside of quotes. The reset of the text you
can delete.
----*/
void Load_Screen()
{
s_num = -1;
while (s_num == -1)
    {
    Demo_Screen_Pointer++;
    switch (Demo_Screen_Pointer)
       {

/*----
This is where the screen file is opened and the screens inside the file
are made available to the program. You must always open a screen file
before you can access the screens stored in it.
----*/
/*--**Screens**-*/

       }
    if (s_num == -1) Demo_Screen_Pointer = 0;
    }
strcpy(s_usermsg,
   "<F1> change screen  <ESC> exit  Press special keys for demo ");
}




void Initialize_Program()
{


/*----
This is where the screen file is opened and the screens inside the file
are made available to the program. You must always open a screen file
before you can access the screens stored in it.
----*/
/*--**ScreenFileName**-*/



/*----
This is where Turbo ScrEdit performs the initialization procedures for
the screens that will be accessed by this program. There are two things
to know here..
   1 - You must always initialize screens EACH TIME A screen file is
       opened. If you are using two screen files you would initialize
       the screens each time you switch screen files.
   2 - You can never have two screen files open at the same time. If
       you do you will get unpredictable results.
   3 - You must initialize a screen before your attempt to user it.
       failure to do so can result in unpredictable results.
----*/
/*--**InitRoutines**-*/



/*---- **System Switches
This next section contains the switches and global variables that you
can use to customize how Turbo ScrEdit processes screens. See PART II
and PART III or the tutor for additional information on using these
switches, changing field NORMAL, DISPLAY, and PROMPT colors programmaticaly,
change screen text color assignments, changing field display and data entry
types, and more.
----*/

/*----
These fields control the colors and sounds used when error messages
are displayed.
----*/
s_errorsound   = 1;
s_errorfreq    = 300;
s_errordur     = 50;
s_errorbg      = RED;
s_errorfg      = YELLOW;

/*----
These fields control the colors and sounds used when help messages
are displayed.
----*/
s_helpsound    = 1;
s_helpfreq     = 200;
s_helpdur      = 50;
s_helpbg       = BLUE;
s_helpfg       = CYAN;

/*----
These fields control the color and sounds used when messages that you
assign to "S_UserMsg" are displayed on the screen.

Any time your program wants to display a message to the user you can
assign the message to "S_UserMsg". Then, when your program calls
S_ReadScreen, S_ReadField, or S_ReadKey the message will be displayed.
----*/
s_usersound    = 1;
s_userfreq     = 100;
s_userdur      = 50;
s_userbg       = BLACK;
s_userfg       = WHITE;
s_usermsg[0]   = 0;

/*----
These variables are used to change the colors used to display the keyboard
status line. If you do not wish to have the status line displayed just
set S_ShowStatus to False;
----*/
s_showstatus   = 1;
s_stbg         = BLACK;
s_stfg         = GREEN;
s_stlabelbg    = LIGHTGRAY;
s_stlabelfg    = BLACK;

/*-----
This variable change the way the ENTER key is used by your program.
By default the TAB key causes the cursor to move from field to field and
pressing the ENTER key ends the procedures that accept data into
the screen fields and passes the screen to the data validation routines
that inspect the data according to the field processing specs that have
been assigned the fields.
If you with to make the ENTER key act like the TAB key you can do it by
setting this switch to TRUE.

When set to FALSE Turbo ScrEdit will continue reading data into the
screens on a field until the ENTER key or one of the other function

keys is pressed.
When set to TRUE Turbo ScrEdit will tread the ENTER key just as though
you pressed the TAB key. SHIFT ENTER is the same as SHIFT TAB.
----*/
s_enterastab           = 0;

/*-----
Note TRUE = 1  False = 0

This variable only comes in to play when S_EnterAsTab is set to TRUE.
Assign this variable the field number (See the field listing generated
by the F5 main main menu option) of a data entry field on the screen.
When your user press the TAB (or ENTER) key while the cursor is on this
field, Turbo ScrEdit will force a the ENTER key to TRUE and data entry
on the screen will end.. Field validation will be performed just as
though the ENTER key was press when S_EnterAsTab is set to false.

When this field is set to zero (0) it has no effect, data entry will
continue on a screen until one of the function keys or special keypad
keys is pressed. NO FIELD VALIDATION WILL OCCUR AUTOMATICALLY YOU MUST
CODE A CALL TO S_VALIDATESCREEN (see the description in the programmers
reference manual for detailed instructions.)
----*/
s_enterafterfield      = -1;

/*----
When set to TRUE, any field help messages that have been
assigned to fields will be displayed when the cursor enters the field.

When this variable is set to FALSE the messages are only displayed if
the user holds down the SHIFT and types a "?".
----*/
s_autohelp             = 0;

/*----
This switch used only with S_ReadScreen.

When set to TRUE this variable causes Turbo ScrEdit to verify that a
fields value is valid according to that fields processing statements
before the cursor can leave the field and move to the next.

When set to FALSE field validation will only occur when the ENTER key
is pressed and all the fields on the screen are verified at the same
time.
----*/
s_autovalidate         = 0;

/*----
When set to TRUE this variable will cause the cursor to skip to the
next field on the screen when the user keys the character that causes
the field to become full of characters.

When set to FALSE the cursor stops at the end of the field and remains
on the last character typed. The user must press the TAB key to move
the cursor to the next field on the screen.
----*/
s_clearifnotrightarrow = 0;

/*----
When set to TRUE the first character typed into the first character
must be a RIGHT ARROW key if the user wishes to edit the contents of
a field. If any other key is pressed the field is cleared and the key
typed will appear as the first character of the new value that is to
be entered into the field.

When set to FALSE the first character typed in the field will simply
overlay the original character at the cursor.
----*/
s_tabatendoffield      = 0;

/*----
The variable set the cursor type that Turbo ScrEdit will use use
in data entry fields. See the programmers reference manual for
descriptions of the cursor you can choose from.
----*/
s_cursor               = S_NORMAL;

/*----
This variable is assigned the field number that you wish to have
Turbo ScrEdit place the cursor on when you call one of the "read"
procedures.
----*/
s_point                = -1;



/*---- ** 1st Example Code
This code is just initializing the variables used for the basic
screen swapping when the F1 key is pressed. You may delete this
code.
----*/
Demo_Current_Screen = -1;
Demo_Mode           = 1;
Load_Screen();
}


void Process_Current_Screen()
{
/*---- ** Demo mode 2  -  Individual Field Mode
If you need to process the field on your screens individually you can
use this as a basic example of how to access each screen. You will
find better examples in the Tutor PART III and the in the programmers
reference manual.
----*/
if (Demo_Mode == 2)
   {
   if (s_indx->A.s_compiledind[s_num] < 3)
      s_readkey();
   else
       do
         {
         if  (s_point > s_indx->A.s_count[s_num]) s_point = -1;
         while ((s_point==-1)||(s_field->C.s_type[s_point]>9))
             if (++s_point >= s_indx->A.s_count[s_num]) s_point = -1;
         if  (s_usermsg[0]!=0)
             {
             itoa(s_point,s_newstr,10);
             strcpy(s_usermsg,"Field <");
             strcat(s_usermsg,s_newstr);
             strcat(s_usermsg,">");
             }
         s_readfield();
         if  ((s_enter)||(s_tab))
             s_point++;
         }
      while ((!s_alt)&&(!s_ctrl) && (!s_fkey) && (!s_enter));
   }



/*---- ** Demo mode 1  -  Full Screen Mode
When Demo_Mode is set to one this file will use basic full screen
read procedure. In most cases your programs will use S_ReadScreen to
process screens.
----*/
if (Demo_Mode != 2)
   s_readscreen();


/*---- ** Example code for demonstration mode
This code can be deleted.
----*/
if  ((s_f1) && (Demo_Mode>0))
    {
    strcpy(s_usermsg,"Press any key to load the next screen");
    s_readkey();
    Load_Screen();
    }


/*---- **Special Key Testing
This section of code demonstrates the variety of keys strokes and
status check that you can perform following a call that reads
data from the keyboard into the screen. Pressing any of the keys
while running this skeleton program will cause the message build to
be displayed on the bottom line of the screen. You can delete test for
any keys that your program is not monitoring.
----*/
if  ((s_fkey) && (!s_f1))
    {
    strcpy(s_usermsg,"< >");
    if  (s_ch > 31) s_usermsg[1]=s_ch;

    if  (s_scrolllock)  strcat(s_usermsg,"<Scroll Lock>");
    if  (s_numlock)     strcat(s_usermsg,"<Num Lock>");
    if  (s_caps)        strcat(s_usermsg,"<Caps>");
    if  (s_insertmode)  strcat(s_usermsg,"<Insert Mode>");
    if  (s_leftshift)   strcat(s_usermsg,"<Left Shift>");
    if  (s_rightshift)  strcat(s_usermsg,"<Right Shift>");
    if  (s_alt)         strcat(s_usermsg,"< Alt  >");
    if  (s_ctrl)        strcat(s_usermsg,"< Ctrl >");
    if  (s_esc)         strcat(s_usermsg,"<Escape>");
    if  (s_f1)          strcat(s_usermsg,"<F1>");
    if  (s_f2)          strcat(s_usermsg,"<F2>");
    if  (s_f3)          strcat(s_usermsg,"<F3>");
    if  (s_f4)          strcat(s_usermsg,"<F4>");
    if  (s_f5)          strcat(s_usermsg,"<F5>");
    if  (s_f6)          strcat(s_usermsg,"<F6>");
    if  (s_f7)          strcat(s_usermsg,"<F7>");
    if  (s_f8)          strcat(s_usermsg,"<F8>");
    if  (s_f9)          strcat(s_usermsg,"<F9>");
    if  (s_f10)         strcat(s_usermsg,"<F10>");
    if  (s_f11)         strcat(s_usermsg,"<F11>");
    if  (s_f12)         strcat(s_usermsg,"<F12>");
    if  (s_home)        strcat(s_usermsg,"<Home>");
    if  (s_end)         strcat(s_usermsg,"<End>");
    if  (s_pgup)        strcat(s_usermsg,"<PgUp>");
    if  (s_pgdn)        strcat(s_usermsg,"<PgDn>");
    if  (s_left)        strcat(s_usermsg,"<Left>");
    if  (s_right)       strcat(s_usermsg,"<Right>");
    if  (s_up)          strcat(s_usermsg,"<Up>");
    if  (s_down)        strcat(s_usermsg,"<Down>");
    if  (s_ins)         strcat(s_usermsg,"<Insert>");
    if  (s_del)         strcat(s_usermsg,"<Delete>");
    if  (s_tab)         strcat(s_usermsg,"<Tab>");
    if  (s_bksp)        strcat(s_usermsg,"<Back Space>");
    if  (s_enter)       strcat(s_usermsg,"<Enter>");
    }
}


void main()
{
Initialize_Program();

while (!s_esc) Process_Current_Screen();

/*---- ** Closing the Screen file
Closing the screen file is only required if you have changed the
cursor and wish to restore the system cursor before the program
ends.
----*/;
s_closescreenfile();
}
