
// tpxclass.hpp
//-----------------------------------------------------------------------------

#if !defined(tpxclass_hpp)

#define tpxclass_hpp

//-----------------------------------------------------------------------------

extern "C" {

#include <mem.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

}

#include <pxengine.h>

//-----------------------------------------------------------------------------

//---------PX Table-----------------

class PX_Table{

  private:
    char field_count,
         index_count,
         secondary_index_count,
         current_field_count,
         current_index_count,
         current_secondary_index_count,
         **field_name,
         **field_type;

    FIELDHANDLE *index_field_handles,
                *secondary_index_field_handles;

    void free_descriptors(void);

  public:
    char *data_buf;
    TABLEHANDLE table_handle;
    char table_path[80];

    RECORDNUMBER total_records;
    FIELDHANDLE  total_fields;

    PX_Table(void);
    void set_data_buf(char *dbuf);
    void set_path(char *dpath);
    void set_name(char *fname);
    int init_descriptors(char fcount, char icount, char sicount);
    void add_field(char *type, char *name);
    void add_secondary_index(FIELDHANDLE fh);
    int init_data_file(void);
    int pxtbladd(char *tpath);
    int pxtblclose(void);
    int pxtblcopy(char *tpath);
    int pxtbldecrypt(void);
    int pxtbldelete(void);
    int pxtblempty(void);
    int pxtblencrypt(char *psw);
    int pxtblexist(int *exist_flag);
    int pxtblname(int buflen, char *buf);
    int pxtblnrecs(void);
    int pxtblopen(void);
    int pxtblprotected(int *protect_flag);
    int pxtblrename(char *tpath);

};

//---------PX File------------------

class PX_File : public PX_Table{

  public:
    RECORDHANDLE record_handle;
    RECORDNUMBER record_number;
    FIELDHANDLE field_handle;
    LOCKHANDLE lock_handle;

    PX_File(void);
    int pxfldblank(int *blank_flag);
    int pxfldblank(char *field_name, int *blank_flag);
    int pxfldhandle(char *field_name);
    int pxfldname(char *field_name);
    int pxfldtype(char *field_type);
    int pxfldtype(char *field_name, char *field_type);
    int pxgetalpha(int buf_size, char *buf);
    int pxgetalpha(char *field_name, int buf_size, char *buf);
    int pxgetdate(DATE *buf);
    int pxgetdate(char *field_name, DATE *buf);
    int pxgetdouble(double *buf);
    int pxgetdouble(char *field_name, double *buf);
    int pxgetlong(long *buf);
    int pxgetlong(char *field_name, long *buf);
    int pxgetshort(short *buf);
    int pxgetshort(char *field_name, short *buf);
    int pxneterruser(char *user);
    int pxnetfilelock(int lock_type);
    int pxnetfileunlock(int lock_type);
    int pxnetreclock(void);
    int pxnetrecunlock(void);
    int pxnetreclocked(int *lock_flag);
    int pxnetrecgotolock(void);
    int pxnettblchanged(int *change_flag);
    int pxnettbllock(int lock_type);
    int pxnettblunlock(int lock_type);
    int pxnettblrefresh(void);
    int pxnetusername(char *buf);
    int pxputalpha(char *buf);
    int pxputalpha(char *field_name, char *buf);
    int pxputblank(void);
    int pxputblank(char *field_name);
    int pxputdate(DATE buf);
    int pxputdate(char *field_name, DATE buf);
    int pxputdouble(double buf);
    int pxputdouble(char *field_name, double buf);
    int pxputlong(long buf);
    int pxputlong(char *field_name, long buf);
    int pxputshort(short buf);
    int pxputshort(char *field_name, short buf);
    int pxrecappend(void);
    int pxrecbufclose(void);
    int pxrecbufcopy(RECORDHANDLE rhandle);
    int pxrecbufempty(void);
    int pxrecbufopen(void);
    int pxrecdelete(void);
    int pxrecfirst(void);
    int pxrecget(void);
    int pxrecgoto(RECORDNUMBER rnum);
    int pxrecinsert(void);
    int pxreclast(void);
    int pxrecnext(void);
    int pxrecnflds(void);
    int pxrecnum(void);
    int pxrecprev(void);
    int pxrecupdate(void);
    int pxsrchfld(int mode);
    int pxsrchfld(char *field_name, int mode);
    int pxsrchkey(int num_key_fields, int mode);

};

//-----------------------------------------------------------------------------
// TPXFile
//-----------------------------------------------------------------------------

#define NOVELL_MINVER            2
#define NOVELL_MINSUBVER         10
#define NOVELL_MINREV            'a'
#define NOVELL_MINSFT            1
#define NOVELL_MINTTS            0

#define LOAD_RECORDS             1
#define NO_LOAD_RECORDS          0

#define NETWORK_FOUND            1
#define NO_NETWORK_FOUND         0

class TPXFile : public PX_File{

  private:
    int *exception_list;

    void free_exceptions(void);
    int check_netware(char *buf);
    int put_field_value(int field_number, char load_flag);
    int get_field_value(int field_number);
    void reassemble_date(char *buf, int month, int day, int year);
    void disassemble_date(char *buf, int *month, int *day, int *year);
    void setstrsz(char *buf, int size);

  protected:
    int put_field_values(int start_field, int field_number);
    int get_field_values(void);

  public:
    static int network_flag;

    TPXFile(void);
    int add_exceptions(int *list);
    int check_exceptions(int code);
    int InitDriver(char *user_name);
    int OpenTable(void);
    int CloseTable(void);
    int GetFirstRecord(void);
    int GetNextRecord(void);
    int SearchRecord(char *fname, int num_key_fields, int *elist, int mode, char load_flag);
    int SearchLastRecord(char *fname, int num_key_fields, char load_flag);
    int FindRecord(char *fname, int *elist, int mode, char load_flag);
    int FindLastRecord(char *fname, char load_flag);
    int UpdateRecord(void);
    int InsertRecord(void);
    int DeleteRecord(void);
    int DeleteAllRecord(char *fname, int num_key_fields);

};

//-----------------------------------------------------------------------------

#endif
