#if !defined(__toolbar_h)              // Sentry, use file only if it's not already included.
#define __toolbar_h

/*  Project toolctrl
    DHB Software
    Copyright  1995. All Rights Reserved.

    SUBSYSTEM:    toolctrl.apx Application
    FILE:         toolbar.h
    AUTHOR:       David H. Borg


    OVERVIEW
    ========
    Class definition for ToolBar (TWindow).      
*/

#include <owl\owlpch.h>
#pragma hdrstop


#include <commctrl.h>			// Windows 95 Common Controls Header File
#include "tlctrlap.rh"            // Definition of all resources.


//{{TWindow = ToolBar}}
class ToolBar : public TWindow {
public:
    ToolBar (TWindow* parent, int id, int w = 0, int h = 0, bool size = false, bool text = false, TModule* module = 0);
    virtual ~ToolBar ();

    void SetBitmaps ( bool size);

protected:
	bool largeBmp, showText;
	int custBitmap;
 	TBBUTTON *tbButton;
	TBADDBITMAP tbSmallBmp, tbLargeBmp, custSmallBmp, custLargeBmp;

    void SetupToolBar ();

private:
	// make default constructor private.
    ToolBar (TWindow* parent, const char far* title = 0, TModule* module = 0);

//{{ToolBarVIRTUAL_BEGIN}}
public:
	void BnClicked();
	LRESULT EvCommonControlNotify( WPARAM wParam, LPARAM lParam);
    virtual char far* GetClassName ();
    virtual void SetupWindow ();
    virtual bool IdleAction (long idleCount);
//{{ToolBarVIRTUAL_END}}

//{{ToolBarRSP_TBL_BEGIN}}
protected:
    void EvPaint ();
//{{ToolBarRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(ToolBar);
};    //{{ToolBar}}


#endif                                      // __toolbar_h sentry.

