#if !defined(__tlctrlap_h)              // Sentry, use file only if it's not already included.
#define __tlctrlap_h

/*  Project ToolCtrl
    DHB Software
    Copyright  1995. All Rights Reserved.

    SUBSYSTEM:    toolctrl.exe Application
    FILE:         tlctrlap.h
    AUTHOR:       David H. Borg


    OVERVIEW
    ========
    Class definition for ToolCtrlApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop


#include "toolbar.h"			// Include newly created tool bar class
#include "tlctrlap.rh"            // Definition of all resources.


//
// FrameWindow must be derived to override Paint for Preview and Print.
//
//{{TDecoratedFrame = SDIDecFrame}}
class SDIDecFrame : public TDecoratedFrame {
public:
    SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, bool trackMenuSelection = false, TModule *module = 0);
    ~SDIDecFrame ();

//{{SDIDecFrameVIRTUAL_BEGIN}}
public:
    virtual void RemoveChild (TWindow* child);
//{{SDIDecFrameVIRTUAL_END}}

//{{SDIDecFrameRSP_TBL_BEGIN}}
protected:
//{{SDIDecFrameRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(SDIDecFrame);
	LRESULT EvCommonControlNotify( WPARAM wParam, LPARAM lParam);
};    //{{SDIDecFrame}}


//{{TApplication = ToolCtrlApp}}
class ToolCtrlApp : public TApplication {
private:

public:
    ToolCtrlApp ();
    virtual ~ToolCtrlApp ();

    TOpenSaveDialog::TData FileData;                    // Data to control open/saveas standard dialog.
    void OpenFile (const char *fileName = 0);

	ToolBar* tbar;			// pointer to Windows 95 Toolbar

protected:
	bool largeBmp, showText;	// use large bitmaps, show text on buttons


//{{ToolCtrlAppVIRTUAL_BEGIN}}
public:
    virtual void InitMainWindow();
//{{ToolCtrlAppVIRTUAL_END}}

//{{ToolCtrlAppRSP_TBL_BEGIN}}
protected:
    void CmFileNew ();
    void CmFileOpen ();
    void CmHelpAbout ();
    void CmToolBarLargeBitmaps ();
    void CmEnToolBarLargeBitmaps (TCommandEnabler &tce);
    void CmToolBarShowText ();
    void CmEnToolBarShowText (TCommandEnabler &tce);
    void CmToolBarCustomize ();
//{{ToolCtrlAppRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(ToolCtrlApp);
};    //{{ToolCtrlApp}}


#endif                                      // __tlctrlap_h sentry.
