/*  Project ToolCtrl
    DHB Software
    Copyright  1995. All Rights Reserved.

    SUBSYSTEM:    toolctrl.exe Application
    FILE:         tlctrlap.cpp
	AUTHOR:       David H. Borg


    OVERVIEW
    ========
    Source file for implementation of ToolCtrlApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop


#include "tlctrlap.h"
#include "tlctrlef.h"                        // Definition of client class.
#include "tlctrlad.h"                        // Definition of about dialog.       


//{{ToolCtrlApp Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(ToolCtrlApp, TApplication)
//{{ToolCtrlAppRSP_TBL_BEGIN}}
	EV_COMMAND(CM_FILENEW, CmFileNew),
	EV_COMMAND(CM_FILEOPEN, CmFileOpen),
	EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
    EV_COMMAND(CM_TOOLBARSHOW_TEXT, CmToolBarShowText),
    EV_COMMAND_ENABLE(CM_TOOLBARSHOW_TEXT, CmEnToolBarShowText),
    EV_COMMAND(CM_TOOLBARCUSTOMIZE, CmToolBarCustomize),
	EV_COMMAND(CM_TOOLBARLARGE_BITMAPS, CmToolBarLargeBitmaps),
    EV_COMMAND_ENABLE(CM_TOOLBARLARGE_BITMAPS, CmEnToolBarLargeBitmaps),
//{{ToolCtrlAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// ToolCtrlApp
// =====
//
ToolCtrlApp::ToolCtrlApp () : TApplication("ToolCtrl")
{

	// Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
	// computed in the member functions CmFileOpen, and CmFileSaveAs.
	FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
	FileData.SetFilter("All Files (*.*)|*.*|");

	// INSERT>> Your constructor code here.

	largeBmp = true;	// default to large bitmaps in the buttons
	showText = true;	// default to showing text on the buttons
}


ToolCtrlApp::~ToolCtrlApp ()
{
	// INSERT>> Your destructor code here.
}


//////////////////////////////////////////////////////////
// ToolCtrlApp
// =====
// Application intialization.
//
void ToolCtrlApp::InitMainWindow ()
{
	if (nCmdShow != SW_HIDE)
		nCmdShow = (nCmdShow != SW_SHOWMINNOACTIVE) ? SW_SHOWNORMAL : nCmdShow;

	SDIDecFrame *frame = new SDIDecFrame(0, GetName(), 0, false);

	//
	// Assign ICON w/ this application.
	//
	frame->SetIcon(this, IDI_SDIAPPLICATION);

	//
	// Menu associated with window and accelerator table associated with table.
	//
	frame->AssignMenu(SDI_MENU);

	//
	// Associate with the accelerator table.
	//
	frame->Attr.AccelTable = SDI_MENU;

	// Initialize CommonControls, Create the toolbar control window, and
	// Insert toolbar at the top of the TDecoratedFrame window
	// w=0 & h=0 if using autosize and standard windows bitmaps
	InitCommonControls();
	tbar = new ToolBar( frame, IDW_TOOLBAR, 0, 0, largeBmp, showText);
	frame->Insert(*tbar, TDecoratedFrame::Top);


	SetMainWindow(frame);

	frame->SetMenuDescr(TMenuDescr(SDI_MENU));
}


//////////////////////////////////////////////////////////
// ToolCtrlApp
// ===========
// Menu File New command
void ToolCtrlApp::CmFileNew ()
{
	ToolCtrlEditFile *client = TYPESAFE_DOWNCAST(GetMainWindow()->GetClientWindow(), ToolCtrlEditFile);     // Client window for the frame.
	client->NewFile();
}


//////////////////////////////////////////////////////////
// ToolCtrlApp
// ===========
// Menu File Open command
void ToolCtrlApp::CmFileOpen ()
{
	//
	// Display standard Open dialog box to select a file name.
	//
	*FileData.FileName = 0;

	ToolCtrlEditFile *client = TYPESAFE_DOWNCAST(GetMainWindow()->GetClientWindow(), ToolCtrlEditFile);     // Client window for the frame.
	if (client->CanClose())
		if (TFileOpenDialog(GetMainWindow(), FileData).Execute() == IDOK)
			OpenFile();
}


void ToolCtrlApp::OpenFile (const char *fileName)
{
	if (fileName)
		strcpy(FileData.FileName, fileName);

	ToolCtrlEditFile *client = TYPESAFE_DOWNCAST(GetMainWindow()->GetClientWindow(), ToolCtrlEditFile);     // Client window for the frame.
	client->ReplaceWith(FileData.FileName);
}


void ToolCtrlApp::CmToolBarLargeBitmaps ()
{
	// INSERT>> Your code here.

	largeBmp = !largeBmp;				// toggle bitmap size flag
	tbar->SetBitmaps( largeBmp);		// re-size the bitmaps

	// Reinstall toolbar into the frame to account for change in toolbar height
	SDIDecFrame* frame = TYPESAFE_DOWNCAST( GetMainWindow(), SDIDecFrame);
	frame->Insert(*tbar, TDecoratedFrame::Top);		// re-insert bitmap
	frame->Layout();                    
}


void ToolCtrlApp::CmEnToolBarLargeBitmaps (TCommandEnabler &tce)
{
	// INSERT>> Your code here.

	// Check and uncheck menu item
	if( largeBmp)
		tce.SetCheck( BF_CHECKED);
	else
		tce.SetCheck( BF_UNCHECKED);
}


void ToolCtrlApp::CmToolBarShowText ()
{
	// INSERT>> Your code here.

	showText = !showText;				// toggle bitmap text flag

	// Remove and destroy old toolbar and create another with or without text
	SDIDecFrame* frame = TYPESAFE_DOWNCAST( GetMainWindow(), SDIDecFrame);
	frame->RemoveChild(tbar);
	tbar->Destroy();
	delete tbar;

	//  Create new toolbar and install into the frame window.
	tbar = new ToolBar( frame, IDW_TOOLBAR, 100, 50, largeBmp, showText);
	tbar->Create();
	tbar->Show( SW_SHOW);
	frame->Insert( *tbar, TDecoratedFrame::Top);
	frame->Layout();
}


void ToolCtrlApp::CmEnToolBarShowText (TCommandEnabler &tce)
{
	// INSERT>> Your code here.

	// Check and uncheck menu item
	if( showText)
		tce.SetCheck( BF_CHECKED);
	else
		tce.SetCheck( BF_UNCHECKED);
}


void ToolCtrlApp::CmToolBarCustomize ()
{
	// INSERT>> Your code here.

	GetMainWindow()->SendDlgItemMessage( IDW_TOOLBAR, TB_CUSTOMIZE, 0, 0);
}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(SDIDecFrame, TDecoratedFrame)
//{{SDIDecFrameRSP_TBL_BEGIN}}
	EV_MESSAGE( WM_NOTIFY, EvCommonControlNotify),
//{{SDIDecFrameRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{SDIDecFrame Implementation}}


SDIDecFrame::SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, bool trackMenuSelection, TModule *module)
	: TDecoratedFrame(parent, title, clientWnd == 0 ? new ToolCtrlEditFile(0, 0, 0) : clientWnd, trackMenuSelection, module)
{
	// INSERT>> Your constructor code here.

}


SDIDecFrame::~SDIDecFrame ()
{
	// INSERT>> Your destructor code here.

}


// This function handles the messages sent by Windows 95 common controls.
// If WM_NOTIFY is received here it must have been sent by a commoncontrols
// customize dialog box. Send it to the child identified by pNmhdr->idFrom.
LRESULT SDIDecFrame::EvCommonControlNotify( WPARAM wParam, LPARAM lParam)
{
	NMHDR FAR *pNmhdr = (NMHDR FAR *)lParam;

	return SendDlgItemMessage( pNmhdr->idFrom, WM_NOTIFY, wParam, lParam);
}


void SDIDecFrame::RemoveChild (TWindow* child)
{
	TDecoratedFrame::RemoveChild(child);

	// INSERT>> Your code here.

	// this function is needed because TDecoratedFramm::RemoveChild(child)
	// is a protected function
}


//////////////////////////////////////////////////////////
// ToolCtrlApp
// ===========
// Menu Help About toolctrl.exe command
void ToolCtrlApp::CmHelpAbout ()
{
	//
	// Show the modal dialog.
	//
	ToolCtrlAboutDlg(MainWindow).Execute();
}


int OwlMain (int , char* [])
{
	try {
		ToolCtrlApp    app;
		return app.Run();
	}
	catch (xmsg& x) {
		::MessageBox(0, x.why().c_str(), "Exception", MB_OK);
	}

	return -1;
}

