
/*====================================

   Module: TOOLBARS
   Header-file (.HPP)
   (C) Copyright Greg Arakelian 1994,1995.
   All Rights Reserved.

  ===================================*/

#ifndef __TOOLBARS_HPP
#define __TOOLBARS_HPP


// ====================================
//  Include Files
// ====================================

//
// Class library
//

#ifndef __CLASSLIB_ARRAYS_H
#include "classlib\arrays.h"
#endif

#ifndef __CLASSLIB_TIME_H
#include <classlib\time.h>
#endif


//
// Standard
//

#ifndef __AUXDATA_HPP
#include "auxdata.hpp"
#endif

//
// Resources
//

#ifndef __TOOLBARS_RH
#include "toolbars.rh"
#endif


// ====================================
//  TToolbarButtonGadget CLASS DEFINITION
// ====================================

class TToolbarButtonGadget : public TGadget
{
public:
  enum TState {Up, Down, Indeterminate};
  enum TType {Command, Exclusive, NonExclusive};
protected:
  enum {
    CelNormal,				// Normal state
    CelDisabled,			// Disabled (grayed)
    CelIndeterm,			// Indeterminate-neither normal nor down
    CelDown,				// Down or checked
    CelsTotal };
  TResId ResId;				// resource id for bitmap
  TPoint BmpOrigin;			// Offset of button in TResId's bitmap
  TSize BmpSize;			// Size of button in TResId bitmap
  TCelArray *CelArray;			// array of images
  TState State;				// i.e. up, down, indeterminate
  TType Type;				// i.e. command, exclusive, non-exclusive
  bool NotchCorners;			// notched corners?
  bool Pressed;				// button pressed?
  bool AntialiasEdges;			// anti-alias edges?
  TWindow *CommandTarget;		// window where command is routed to
  virtual void Activate (TPoint &point);
  virtual void BeginPressed (TPoint &point);
  virtual void BuildCelArray();
  virtual void CancelPressed (TPoint &point);
  void CheckExclusively();
  virtual void CommandEnable();
  virtual TDib* GetGlyphDib();
  void Invalidate();
  virtual void LButtonDown(uint modKeys, TPoint &point);
  virtual void LButtonUp(uint modKeys, TPoint &point);
  virtual void MouseEnter(uint modKeys, TPoint &point);
  virtual void MouseLeave(uint modKeys, TPoint &point);
  virtual void MouseMove(uint modKeys, TPoint &point);
  virtual void Paint (TDC &dc);
  virtual void ReleaseGlyphDib (TDib *glyph);
  void SetHint();
  virtual void SysColorChange();
public:
  TToolbarButtonGadget (TResId resId, int id, TType type=Command,
    bool enabled=false, TState state=Up, bool repeat=false);
 ~TToolbarButtonGadget();
  TState GetButtonState() { return State; }
  TType GetButtonType() { return Type; }
  void GetDesiredSize (TSize &size);
  inline void SetAntialiasEdges (bool antialiasEdges=true) { AntialiasEdges=antialiasEdges; }
  void SetButtonState (TState state);
  void SetRect (TPoint bmpOrigin, TSize bmpSize) { BmpOrigin=bmpOrigin; BmpSize=bmpSize; }
  inline void SetCommandTarget (TWindow *commandTarget) { CommandTarget=commandTarget; }
  inline void SetNotchCorners (bool notchCorners=true) { NotchCorners = notchCorners; }
};


// ====================================
//  TToolbar CLASS DEFINITION
// ====================================

//
// The TBRS_ style is made up of an alignment style
// and a draw border style. The alignment styles are
// mutually exclusive; the border styles may be combined.
//

#define TBRS_ALIGN_LEFT		0x1000
#define TBRS_ALIGN_TOP		0x2000
#define TBRS_ALIGN_RIGHT	0x4000
#define TBRS_ALIGN_BOTTOM	0x8000
#define TBRS_ALIGN_ANY		0xF000
#define TBRS_BORDER_LEFT	0x0100
#define TBRS_BORDER_TOP		0x0200
#define TBRS_BORDER_RIGHT	0x0400
#define TBRS_BORDER_BOTTOM	0x0800
#define TBRS_BORDER_ANY		0x0F00
#define TBRS_BORDER_3D		0x0080
#define TBRS_FLOATING		0x0010
#define TBRS_HIDDEN		0x0020
#define TBRS_HIDE_INPLACE	0x0008
#define TBRS_ORIENT_HORZ	(TBRS_ALIGN_TOP|TBRS_ALIGN_BOTTOM)
#define TBRS_ORIENT_VERT	(TBRS_ALIGN_LEFT|TBRS_ALIGN_RIGHT)
#define TBRS_ORIENT_ANY		(TBRS_ORIENT_HORZ|TBRS_ORIENT_VERT)
#define TBRS_BORDER_HORZ	(TBRS_BORDER_TOP|TBRS_BORDER_BOTTOM)
#define TBRS_BORDER_VERT	(TBRS_BORDER_LEFT|TBRS_BORDER_RIGHT)
#define TBRS_LEFT		(TBRS_ALIGN_LEFT|TBRS_BORDER_RIGHT)
#define TBRS_TOP		(TBRS_ALIGN_TOP|TBRS_BORDER_BOTTOM)
#define TBRS_RIGHT		(TBRS_ALIGN_RIGHT|TBRS_BORDER_LEFT)
#define TBRS_BOTTOM		(TBRS_ALIGN_BOTTOM|TBRS_BORDER_TOP)

#define MAXNUMCASES 32

class TDockStation;
class TToolbarFrame;

class TToolbar : public TControlBar
{
public:
  typedef TIArrayAsVector<TToolbar> TToolbarArray;
  static TToolbarArray ToolbarArray;
protected:
  friend TDockStation;
  friend TToolbarFrame;
  static TDockStation *LeftDock;	// Left docking station
  static TDockStation *TopDock;		// Top docking station
  static TDockStation *RightDock;	// Right docking station
  static TDockStation *BottomDock;	// Bottom docking station
  static TDecoratedFrame *MainWindow;	// Application window
  int CommandId;			// Command Id (for hiding/showing)
  uint16 ValidAlignment;		// Alignments where docking is valid
  TWindow *HintWindow;			// Child window we're displaying hint for (if any)
  TToolbarFrame *ToolbarFrame;		// Floating frame if TBRS_FLOATING
  TToolbar *NextToolbar;		// Next toolbar in docking station
  TToolbar *PrevToolbar;		// Previous toolbar in docking station
  bool StartNewLine;			// true if starts new line (docking station)
  int DockOffset;			// X or Y offset in docking station
  bool Dragging;			// true if dragging window
  HBITMAP DragBitmap;			// Dragging bitmap
  HBRUSH DragBrush;			// Dragging brush
  uint16 DragStyle;			// Current drag style
  TPoint DragPoint;			// Last drag position
  TRect DragRect;			// Current drag rectangle
  TSize SizeHorz;			// Size of TBRS_ALIGN_TOP/TBRS_ALIGN_BOTTOM (for dragging)
  TSize SizeVert;			// Size of TBRS_ALIGN_LEFT/TBRS_ALIGN_RIGHT (for dragging)
  TRect DockRect;			// Rectangle bounding docking stations
  TSize Frame;				// Frame size in floating frame
  int CaptionHeight;			// Caption height in floating frame
  uint16 Style;				// Location of toolbar
  int NumCases;				// Number of unique cases (sizes)
  TSize CaseSize[MAXNUMCASES];		// Size of each case
  int CaseLines[MAXNUMCASES];		// Desired lines for each case
  int FloatingSize;			// Current case number (0..NumCases-1)
  TPoint NormalPos;			// Position (origin) when restored
  TPoint FramePosition;			// Position when maximized
  char far *SectionName;		// Section where toolbar settings stored 
  bool ShowDisabled;			// true to show disabled gadgets
  bool NewLine;				// true to add new line next insertion
  void CleanupWindow();
  void CmToolbars() { ForwardMessage(*MainWindow); }
  TSize Compose (uint16 style, int desiredLines, int *actualLines, bool UpdateGadgets);
  void CreateCases();
  void DrawDragRect (TRect &dragRect, uint16 dragStyle, bool Update);
  void DrawFocus (TDC &dc, TRect &rect, uint16 style);
  LRESULT EvCommand (uint id, HWND hWndCtl, uint notifyCode);
  HBRUSH EvCtlColor (HDC hDC, HWND hWndChild, uint ctlType);
  void EvLButtonDown (uint modKeys, TPoint&);
  void EvLButtonDblClk (uint, TPoint&);
  void EvLButtonUp (uint modKeys, TPoint &point);
  void EvMouseMove (uint modKeys, TPoint &clientPoint);
  void EvSize (uint sizeType, TSize &size);
  void EvSysColorChange();
  inline LPSTR GetClassName() { return "TToolbar"; }
  virtual void GetDesiredSize (TSize &size);
  bool GetGadget (uint16 style, TGadget *gadget, TSize &size, int &dx, bool &isSeparator);
  void GetGadgetTotals (uint16 style, int &TotalGadgetWidth, TSize &MinGadget, TSize &MaxGadget);
  void GetWindowClass (WNDCLASS& wc);
  void Paint(TDC &dc, bool erase, TRect &rect);
  bool PreProcessMsg (MSG &msg);
  void SetupWindow();
  virtual TRect TileGadgets();
public:
  TToolbar (TDecoratedFrame *mainWindow, const char far *title,
    uint16 style=TBRS_TOP, bool startNewLine=true,
    TFont *font=new TGadgetWindowFont(SysInfo.IsWin4()?8:10), TModule *module=0);
  ~TToolbar();
  inline TToolbar *GetNextToolbar() { return NextToolbar; }
  inline TToolbar *GetPrevToolbar() { return PrevToolbar; }
  inline int GetFloatingSize() { return FloatingSize; }
  TSize GetCaseSize (int caseNo);
  inline int GetCommandId() { return CommandId; }
  virtual void GetContextMenu (TContextMenu &contextMenu);
  TDockStation *GetDockedStation (uint style);
  inline bool GetShowDisabled() { return ShowDisabled; }
  inline uint16 GetValidAlignment() { return ValidAlignment; }
  inline void Hide() { SetStyle((uint16)(Style|TBRS_HIDDEN)); }
  virtual bool IsEnabled() { return MainWindow && MainWindow->IsWindowEnabled(); }
  inline bool IsHidden() { return (Style & TBRS_HIDDEN)!=0; }
  inline bool IsFloating() { return (Style & TBRS_FLOATING)!=0; }
  inline void Maximize() { SetStyle((uint16)(Style|TBRS_FLOATING)); }
  inline void Minimize() { SetStyle((uint16)(Style & ~TBRS_FLOATING)); }
  void SetCaseNo (int caseNo);
  inline void SetDockPosition (int dockOffset) { DockOffset=dockOffset; }
  void SetStyle (uint16 newStyle, bool savePosition=true);
  inline void SetShowDisabled (bool showDisabled) { ShowDisabled=showDisabled; }
  inline void SetValidAlignment (uint16 validAlignment) { ValidAlignment=validAlignment; }
  inline void Show() { SetStyle((uint16)(Style & ~TBRS_HIDDEN)); }
  DECLARE_RESPONSE_TABLE(TToolbar);
};


// ====================================
//  TDockStation METHODS
// ====================================

class TDockStation : public TWindow
{
protected:
  uint16 Style;				// Style of docking station
  bool AutoTightFit;			// true if force toolbars together
  bool Horizontal;			// true if horizontal orientation
  TToolbar *FirstToolbar;		// Pointer to first toolbar
  bool Create();
  void EvEnterIdle (uint source, HWND hWndDlg) { ForwardMessage(*Parent); }
  void EvMenuSelect (uint menuItemId, uint flags, HMENU hMenu) { ForwardMessage(*Parent); }
  uint EvNCCalcSize (bool calcValidRects, NCCALCSIZE_PARAMS far &calcSize);
  void EvNCPaint();
  void EvSysColorChange();
  bool IdleAction (long idleCount);
  void LayoutSession();
  bool PreProcessMsg (MSG &msg);
  void SetupWindow();
public:
  TDockStation(TWindow *parent, uint16 style, TModule *module=0);
  ~TDockStation();
  void Append (TToolbar *Toolbar, bool startNewLine);
  bool GetAutoTightFit() { return AutoTightFit; }
  inline LPSTR GetClassName() { return "TDockStation"; }
  inline TToolbar *GetFirstToolbar() { return FirstToolbar; }
  inline uint16 GetStyle() { return Style; }
  void GetWindowClass (WNDCLASS& wc);
  void Insert (TToolbar *Toolbar, TPoint controlOrigin);
  void Remove (TToolbar *Toolbar, bool DoLayout=false);
  void SetAutoTightFit (bool autoTightFit) { AutoTightFit=true; LayoutSession(); }
  DECLARE_RESPONSE_TABLE(TDockStation);
};


// ====================================
//  TToolbarFrame METHODS
// ====================================

class TToolbarFrame : public TFloatingFrame
{
protected:
  TToolbar *Toolbar;			// Toolbar we're framing
  TWindow *DockStation;			// Toolbar's docking station
  bool Ctl3dFrame;			// true if Ctl3dFrame
  bool IsActive;			// true if application is "active"
  TRect SizeRect;
  LRESULT EvMouseActivate (WPARAM, LPARAM);
  void DrawSizeRect (TRect &sizeRect, bool Update);
  void EvClose();
  void EvEnterIdle (uint, HWND) { ForwardMessage(*Parent); }
  void EvGetMinMaxInfo (MINMAXINFO far &minmaxInfo);
  void EvMenuSelect (uint menuItemId, uint flags, HMENU hMenu) { ForwardMessage(*Parent); }
  void EvMouseMove (uint modKeys, TPoint &point);
  bool EvNCActivate (bool active);
  bool EvNCCreate (CREATESTRUCT far &cs);
  uint EvNCHitTest (TPoint &point);
  void EvNCLButtonDown (uint hitTest, TPoint &screenPoint);
  void EvNCLButtonDblClk (uint hitTest, TPoint &screenPoint);
  void EvLButtonUp (uint modKeys, TPoint &point);
  void EvNCPaint();
  void EvSize (uint sizeType, TSize &size) { TWindow::EvSize(sizeType,size); }
  TSize GetCaseSize (int caseNo);
  void InvertSysBox();
  void PaintCaption (bool isActive);
  bool PreProcessMsg (MSG &msg);
public:
  TToolbarFrame::TToolbarFrame (TWindow *parent, char *title,
    TToolbar *toolBar, TPoint &position, TModule *module=0);
  ~TToolbarFrame();
  inline LPSTR GetClassName() { return "TToolbarFrame"; }
  bool IdleAction (long idleCount);
  void ResizeWindow();
  void SetupWindow();
  DECLARE_RESPONSE_TABLE(TToolbarFrame);
};


// ====================================
//  TStatusBar95 CLASS DEFINITION
// ====================================

class TStatusBar95 : public TStatusBar
{
protected:
  uint16 Style;
  uint EvNCCalcSize (bool calcValidRects, NCCALCSIZE_PARAMS far &calcSize);
  void EvNCPaint();
  void GetDesiredSize (TSize &size);
  DECLARE_RESPONSE_TABLE(TStatusBar95);
  DECLARE_CASTABLE;
public:
  TStatusBar95(TWindow *parent=0,
    TGadget::TBorderStyle borderStyle=TGadget::Recessed, uint modeIndicators=0,
    TFont *font=new TGadgetWindowFont(SysInfo.IsWin4()?8:10), TModule *module=0);
  ~TStatusBar95() {};
  void Insert (TGadget &gadget, TPlacement placement=After, TGadget *sibling=0);
  void SetHintText(const char* text);
};


#endif

