#include <ansi.h>
#include <xchar.h>
#define TRUE 1
#define FALSE 0
#define NUM_ENT 12
#define BOTTOM "\x1B[16;1f"

#define MAX_ENT_SIZE 26
#define menu_start_col 20

int last_pos;		/* last position selected */
int curpos;		/* position of selected item */
int mouse;		/* TRUE if mouse is available */
static char *items[NUM_ENT] =	/* menu items */
	{	"Initialize Mouse",
		"Show/Hide Mouse Cursor",
		"Cursor Position Setting",
		"Cursor Position Reading",
		"Button Press/Release",
		"Horizontal/Vertical Range",
		"Define Graphix Cursor",
		"Define Text Cursors",
		"Read Motion Counters",
		"Set Motion/Pixel Ratio",
		"Conditional Off",
		"Quit", };

main()
{
   int code;
   test_init();
   clear_screen();
   curpos = 0;
   last_pos = 0;
   box();
   display();
   while (TRUE)
   {
      update();
      code = getcode();
      switch (code)
      {
         case UP_ARR:
            if (curpos>0) --curpos;
            else curpos = NUM_ENT-1;
            break;
         case DN_ARR:
            if (curpos<NUM_ENT-1) ++curpos;
            else curpos = 0;
            break;
         case CRG_RETN:
            action(); 
            break;
      }
   }
}

display()
{
   int j;
   for (j=1;j<=NUM_ENT;j++)
   {
      printf(CUR_POS,j+1,menu_start_col);
      printf("%s\n", *(items+(j-1)));
      printf(NORMAL);
   }
}

update()
{
   printf(CUR_POS,last_pos+2,menu_start_col);
   printf("%s\n", *(items+last_pos));
   last_pos = curpos;
   printf(CUR_POS,curpos+2,menu_start_col);
   printf(REVERSE);
   printf("%s\n", *(items+curpos));
   printf(NORMAL);
   printf(BOTTOM);
}

getcode()
{
   char key, done;
   done = FALSE;
   while (!done)
   {
      key = getch();
      if (key==0)
      {
         key = getch();
         done = TRUE;
      }
      else
      {
         if (key==CRG_RETN)
            done = TRUE;
      }
   }
   return(key);
}

action()
{
   if ((curpos>=0) && (curpos <= NUM_ENT))
   {
      switch (curpos)
      {
         case 0:	/* Initialize Mouse */
            test_init();
            any_key();
            break;
         case 1:	/* Show/Hide Mouse Cursor */
            if (mouse) test_show_cursor();
            else nomouse();
            any_key();
            break;
         case 2:	/* Cursor Position Setting */
            if (mouse) test_position_set();
            else nomouse();
            any_key();
            break;
         case 3:	/* Cursor Position Reading */
            if (mouse) test_position_read();
            else nomouse();
            any_key();
            break;
         case 4:	/* Button Press/Release */
            if (mouse) test_button();
            else nomouse();
            any_key();
            break;
         case 5:	/* Horizontal/Vertical Range */
            if (mouse) test_horz_vert();
            else nomouse();
            any_key();
            break;
         case 6:	/* Define Graphix Cursor */
            if (mouse) test_graph_cursor();
            else 
            {
               nomouse();
               any_key();
            }
            break;
         case 7:	/* Define Text Cursors */
            if (mouse) test_text_cursor();
            else nomouse();
            any_key();
            break;
         case 8:	/* Read Motion Counters */
            if (mouse) test_motion_counter();
            else nomouse();
            any_key();
            break;
         case 9:	/* Set Motion/Pixel Ratio */
            if (mouse) test_motion_pixel();
            else nomouse();
            any_key();
            break;
         case 10:	/* Conditional Off */
            if (mouse) test_conditional_off();
            else nomouse();
            any_key();
            break;
         case 11:	/* Quit */
            exit();
      }
   }
}

nomouse()
{
   printf(CUR_POS,NUM_ENT+4,1);
   printf(REVERSE);
   printf(" NO MOUSE IS AVAILABLE...CANNOT ACCESS THIS FUNCTION ");
   printf(NORMAL);
}

any_key()
{
   printf(CUR_POS,24,1);
   printf("Press any key to continue . . .");
   getch();
   clear_bottom();
}

clear_bottom()
{
   int i;
   printf(CUR_POS,NUM_ENT+2,1);
   for (i=NUM_ENT+2;i<=24;i++)
      printf("\n%s",ERASE);
   printf(CUR_POS,NUM_ENT+4,1);
}

box()
{
   int j;
   int max_col, min_col;
   max_col = MAX_ENT_SIZE+3;
   min_col = menu_start_col-2;
   printf(CUR_POS,1,min_col);
   putch(201);
   for (j=1;j<=max_col;j++)
   {
      printf(CUR_POS,1,min_col+j);
      putch(205);
   }
   printf(CUR_POS,1,min_col+max_col);
   putch(187);
   for (j=2;j<=NUM_ENT+1;j++)
   {
      printf(CUR_POS,j,min_col);
      putch(186);
      printf(CUR_POS,j,min_col+max_col);
      putch(186);
   }
   printf(CUR_POS,NUM_ENT+2,min_col);
   putch(200);
   for (j=1;j<=max_col;j++)
   {
      printf(CUR_POS,NUM_ENT+2,min_col+j);
      putch(205);
   }
   printf(CUR_POS,NUM_ENT+2,min_col+max_col);
   putch(188);
}

test_init()
{
   int x;
   mouse = mouse_init(&x);
   printf(CUR_POS,NUM_ENT+4,1);
   if (mouse)
      printf("Mouse is available with %1d buttons\n",x);
   else
      printf("No mouse available\n");
}

test_show_cursor()
{
   unsigned int right_button, left_button;
   int hpos;
   int vpos;
   int button;
   show_cursor();
   set_cursor_pstn(320,96);
   right_button = FALSE;
   left_button = FALSE;
   button = 0;  hpos = 0; vpos = 0;
   printf(CUR_POS,NUM_ENT+4,1);
   printf("Press LEFT button to cause cursor to disappear");
   while (!left_button)
   {
      get_pstn_stat(&button,&hpos,&vpos);
      if (button==1)
         left_button = TRUE;
   }
   hide_cursor();
   printf(CUR_POS,NUM_ENT+4,1);
   printf(ERASE);
   printf("Press RIGHT button to cause cursor to reappear");
   while (!right_button)
   {
      get_pstn_stat(&button,&hpos,&vpos);
      if (button==2)
         right_button = TRUE;
   }
   show_cursor();
}

test_position_set()
{
   int h, v, x;
   h = v = x = 0;
   show_cursor();
   get_pstn_stat(&x,&h,&v);
   while ((h>=0) && (v>=0))
   {
      char string[20];
      printf(CUR_POS,NUM_ENT+4,1);
      printf("Horizontal : %3d   Vertical : %3d",h,v);
      printf(CUR_POS,NUM_ENT+5,1);
      printf(ERASE);
      printf("Enter Horizontal or negative to exit : ");
      gets(string);
      h=atoi(string);
      if ((h>=0) && (v>=0))
      {
         printf(CUR_POS,NUM_ENT+5,1);
         printf(ERASE);
         printf("Enter Vertical or negative to exit : ");
         gets(string);
         v=atoi(string);
      }
      if ((h>=0) && (v>=0))
      {
         set_cursor_pstn(h,v);
      }
   }
}	

test_position_read()
{
   unsigned int left_button;
   int button, hpos, vpos;
   int done;
   left_button = FALSE;
   done = FALSE;
   button = 0;
   hpos = 0;
   vpos = 0;
   button = hpos = vpos = 0;
   show_cursor();
   printf(CUR_POS,NUM_ENT+4,1);
   printf("Move mouse and press LEFT button to read position or RIGHT button to quit");
   while (!done)
   {
      while (!left_button && !done)
      {
         get_pstn_stat(&button,&hpos,&vpos);
         if (button==1)
            left_button = TRUE;
         if (button==2)
            done = TRUE;
      }
      left_button = FALSE;
      if (!done)
      {
         printf(CUR_POS,NUM_ENT+5,1);
         printf("Horizontal: %3d   Vertical: %3d",hpos,vpos);
      }
   }
}

test_button()
{
   int button, press, hpos, vpos;
   int plbut, plpress, plhpos, plvpos;
   int prbut, prpress, prhpos, prvpos;
   int rlbut, rlpress, rlhpos, rlvpos;
   int rrbut, rrpress, rrhpos, rrvpos;
   button = press = hpos = vpos = 0;
   plbut = plpress = plhpos = plvpos = 0;
   prbut = prpress = prhpos = prvpos = 0;
   rlbut = rlpress = rlhpos = rlvpos = 0;
   rrbut = rrpress = rrhpos = rrvpos = 0;
   show_cursor();
   press = 0;
   get_button_press(&button,&press,&hpos,&vpos);
   press = 0;
   get_button_release(&button,&press,&hpos,&vpos);
   press = 1;
   get_button_press(&button,&press,&hpos,&vpos);
   press = 1;
   get_button_release(&button,&press,&hpos,&vpos);
   printf(CUR_POS,NUM_ENT+4,1);
   printf("Will count the number of times you press & release the mouse buttons\n");
   printf("Press Left and Right buttons individually several times\n");
   printf("When done press both buttons at the same time");
   plbut = FALSE;
   while (!plbut)
   {
      get_pstn_stat(&button,&hpos,&vpos);
      if (button==3)
         plbut = TRUE;
   }
   press = 0;
   get_button_press(&button,&press,&hpos,&vpos);
   if (button==1) plbut = TRUE; else plbut = FALSE;
   plpress = press; plhpos = hpos; plvpos = vpos;
   press = 1;
   get_button_press(&button,&press,&hpos,&vpos);
   if (button==2) prbut = TRUE; else prbut = FALSE;
   prpress = press; prhpos = hpos; prvpos = vpos;
   press = 0;
   get_button_release(&button,&press,&hpos,&vpos);
   if (button==1) rlbut = TRUE; else rlbut = FALSE;
   rlpress = press; rlhpos = hpos; rlvpos = vpos;
   press = 1;
   get_button_release(&button,&press,&hpos,&vpos);
   if (button==2) rrbut = TRUE; else rrbut = FALSE;
   rrpress = press; rrhpos = hpos; rrvpos = vpos;
   clear_bottom();
   printf("                 BUTTON PRESS     BUTTON RELEASE\n");
   printf("                 Left   Right     Left     Right\n");
   printf("Status         : %3d    %3d       %3d      %3d\n",
                            plbut, prbut,    rlbut,   rrbut);
   printf("# Press/release: %3d    %3d       %3d      %3d\n",
                           plpress, prpress, rlpress, rrpress);
   printf("Last Horizontal: %3d    %3d       %3d      %3d\n",
                           plhpos, prhpos,   rlhpos,  rrhpos);
   printf("Last Vertical  : %3d    %3d       %3d      %3d\n",
                           plvpos, prvpos,   rlvpos,  rrvpos);
}

test_horz_vert()
{
   int button, lbut, hpos, vpos;	
   show_cursor();
   set_horiz_range(200,500);
   printf(CUR_POS,NUM_ENT+4,1);
   printf("Test of horizontal range setting\n");
   printf("The horizontal range is set to min:200 max:500\n");
   printf("Move the mouse to find the new horizontal limits\n");
   printf("Press any mouse button to continue\n");
   lbut = FALSE;
   button = hpos = vpos = 0;
   while (!lbut)
   {
      get_pstn_stat(&button,&hpos,&vpos);
      if (button!=0)
         lbut = TRUE;
   }
   show_cursor();
   set_vert_range(50,150);
   clear_bottom();
   printf(CUR_POS,NUM_ENT+4,1);
   printf("Test of vertical range setting\n");
   printf("The vertical range is now set to min:50 max:150\n");	
   printf("Move the mouse to find the new vertical limits\n");
   printf("Press any mouse button to continue\n");
   lbut = FALSE;
   button = hpos = vpos = 0;
   while (!lbut)
   {
      get_pstn_stat(&button,&hpos,&vpos);
      if (button!=0)
         lbut = TRUE;
   }
   set_horiz_range(0,639);
   set_vert_range(0,199);
}

test_graph_cursor()
{
   unsigned int cursor [2] [16] =
	      {	{ 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
		  0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
		  0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
		  0xffff },   /* screen mask */
		{ 0x8000, 0xf000, 0xf800, 0xff00, 0xd800,
		  0x0c00, 0x0600, 0x0300, 0x0000, 0x0000,
		  0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		  0x0000 } }; /* cursor mask */
   set_screen_mode(4);
   printf(CUR_POS,1,1);
   printf("Graphics Cursor Test\n");
   show_cursor();
   define_graph_cursor(0,0,cursor);
   printf(CUR_POS,24,1);
   printf("Press any key to continue . . .");
   getch();
   set_screen_mode(3);
   box();
   display();
   update();
}

test_text_cursor()
{
   unsigned int cursor_mask;
   unsigned int screen_mask;
   int cursor;		/* 0: software, 1: hardware */
   int button, lbut, hpos, vpos;

	   /* hardware cursor */
   printf(CUR_POS,NUM_ENT+4,1);
   printf("Hardware Cursor\n");
   printf("\nPress any mouse key to continue...\n");
   cursor_mask = 2;
   screen_mask = 1;
   cursor = 1;
   define_text_cursor(cursor,screen_mask,cursor_mask);
   show_cursor();
   lbut = FALSE;
   button = hpos = vpos = 0;
   while (!lbut)
   {
      get_pstn_stat(&button,&hpos,&vpos);
      if (button!=0)
         lbut = TRUE;
   }

  	   /* software cursor */
   clear_bottom();
   printf(CUR_POS,NUM_ENT+4,1);
   printf("Software Cursor\n");
   cursor_mask = 0xff00;
   screen_mask = 0x0000;
   cursor = 0;
   define_text_cursor(cursor,screen_mask,cursor_mask);
}

test_motion_counter()
{
   unsigned int but;
   int hcnt, vcnt;
   int button, hpos, vpos;
   show_cursor();
   printf(CUR_POS,NUM_ENT+4,1);
   printf("Press the left mouse button to start\n");
   button = hpos = vpos = 0;
   but = FALSE;
   while (!but)
   {
      get_pstn_stat(&button,&hpos,&vpos);
      if (button==1)
         but = TRUE;
   }
   read_motion_cntr(&hcnt,&vcnt);
   printf(CUR_POS,NUM_ENT+5,1);
   printf("Move the mouse and press the right mouse button to stop\n");
   button = 0;  hpos = 0; vpos = 0;
   but = FALSE;
   while (!but)
   {
      get_pstn_stat(&button,&hpos,&vpos);
      if (button==2)
         but = TRUE;
   }
   read_motion_cntr(&hcnt,&vcnt);
   printf(CUR_POS,NUM_ENT+6,1);
   printf("Horizontal [1/200 inch] : %6d     Vertical [1/200 inch] : %6d\n",
           hcnt,vcnt);
}

test_motion_pixel()
{
   unsigned int but;
   int button, hpos, vpos;
   show_cursor();
   printf(CUR_POS,NUM_ENT+4,1);
   printf("Setting the motion to pixel ratio = Horiz = 2:1   Vert = 4:1\n");
   printf("Move the mouse to test new ratio...press left button to continue\n");
   set_motion_pixel_ratio(16,32);
   button = hpos = vpos = 0;
   but = FALSE;
   while (!but)
   {
      get_pstn_stat(&button,&hpos,&vpos);
      if (button==1)
         but = TRUE;
   }
   clear_bottom();
   printf(CUR_POS,NUM_ENT+4,1);
   printf("Setting the motion to pixel ratio = Horiz = 0.5:1   Vert = 1:1\n");
   printf("Move the mouse to test new ratio\n");
   set_motion_pixel_ratio(4,8);
}

test_conditional_off()
{
   unsigned int but;
   int button, hpos, vpos;
   show_cursor();
   printf(CUR_POS,NUM_ENT+4,1);
   printf("Setting the cursor off [Horiz: 0 to 100, Vert: 0 to 100]\n");
   printf("Move the mouse to test...press any mouse button when finished\n");
   conditional_off(0,100,0,100);
   button = hpos = vpos = 0;
   but = FALSE;
   while (!but)
   {
      get_pstn_stat(&button,&hpos,&vpos);
      if (button!=0)
         but = TRUE;
   }
   show_cursor();
}
