/*---------------------------------------------------------------------------*
 *
 *  Placed in Public Domain By Damir Nadramija.
 *
 *  Module:         CLOCKTST.C 
 *  Purpose:        Clock hardware interrupt service routine used as a driver
 *                  for the "Small Multi-Threader" project.
 *                                                                            
 *  Created by:     Damir Nadramija 
 *  Date:           September 18, 1993                                            
 *--------------------------------------------------------------------------*/
#include <alloc.h>
#include <string.h>
#include <stdlib.h>
#include <bios.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <time.h>
#include <process.h>
#include <stdarg.h>
#include <fcntl.h>
#include <\sys\stat.h>
#include <io.h>
#include <setjmp.h>
#include <ctype.h>
#include <tools.h>
#include <clockint.h>

/*Global variables residing here*/
int  DebugPrint;
int  AutoKillFlag;
long LifeCount = 10000L;
MessageWindow Message = {5, 10, 75, 22, 2, YELLOW + (RED << 4), 0, 1, 0, 0};

/*Global variables referenced here*/
extern unsigned int _stklen = 8000;

/* Local prototypes */
void PrintTimes(void);
int  GetTaskIndex(void);
int  WaitForUserResponse(void);
void TaskStatus(int taskindex);
static atexit_t ClockExit(void);

/*--------------------------------------------------------------------------*
 *  Function:       SimpleTask
 *  Description:    Example of a task function using video memory and
 *                  exercising main 'Small Multi-Threader Engine' functions.
 *                                                                           
 *--------------------------------------------------------------------------*/
void SimpleTask(void)
{
    static int lasttaskindex;
    struct text_info t;
    unsigned long count;
    int x, y, c, a, index;
    char buffer[20], attr = (YELLOW + BLUE << 4);

    randomize();
    a  = random(7) << 4;
    a += random(15);
    x  = random(80);
    y  = random(24);
    c  = random(78) + 49;

    count = 0;
    if (DebugPrint) Cputs("Task starting ...", a, 10, 20);
    while (count++ < LifeCount)
    {
        gettextinfo(&t);
        window(1, 1, t.screenwidth, t.screenheight);
        if ((lasttaskindex != CurrTaskIndex) && DebugPrint)
        {
            sprintf(buffer, "Task index %u ", CurrTaskIndex);
            Cputs(buffer, attr, 60, 1);
            lasttaskindex = CurrTaskIndex;
        }
        if (random(80) > 40) x--;
        else x++;
        if (random(50) < 25) y--;
        else y++;

        if (x < 1) x = 1;
        if (x > t.screenwidth)  x = t.screenwidth;
        if (y < 1) y = 1;
        if (y > t.screenheight) y = t.screenheight;

        Putc(c, a, x, y);

        window(t.winleft, t.wintop, t.winright, t.winbottom);
        textattr(t.attribute);
        gotoxy(t.curx, t.cury);

    }
    if (DebugPrint) Cputs("Task completed ...", a, 40, 20);
    if (AutoKillFlag) KillTask(CurrTaskIndex);
    while(TRUE)     
    ;
}

/*--------------------------------------------------------------------------*
 *  Function:       DiskTask
 *  Description:    Example of a task function using disk IO. 
 *                                                                           
 *--------------------------------------------------------------------------*/
void DiskTask(void)
{
    static int fcount;
    static char a = (RED << 4) + WHITE;
    struct text_info t;
    unsigned long count;
    char fname[20], buffer[80]; 
    int row = 1, col = 1, handle;
    
    fcount++;
    count = 0;
    if (a > ((RED << 4) + LIGHTGRAY)) a--;
    else a = (RED << 4) + WHITE;

    sprintf(fname, "testfile.%03d", fcount);
    Semafore++; 
    handle = open(fname, O_CREAT|O_TRUNC|O_RDWR, S_IREAD|S_IWRITE);
    Semafore--; 
    if (handle != -1)
    {
        sprintf(buffer, "\n Task %d started. ", CurrTaskIndex);
        write(handle, buffer, strlen(buffer));
        if (DebugPrint) Cputs(buffer, a, 20, 2);
        while (count++ < 1000)
        {
            sprintf(buffer, "\n %lu ", count);
            write(handle, buffer, strlen(buffer));
            if (DebugPrint)
            {
                gettextinfo(&t);
                sprintf(buffer, "\n %lu ", count);
                window(1, 1, t.screenwidth, t.screenheight);
                Cputs(buffer, a, col, row);
                if  (row < 24) row++;
                else row = 1;                
                if  (col < 80) col++;
                else col = 1;                
                window(t.winleft, t.wintop, t.winright, t.winbottom);
            }
        }
        sprintf(buffer, "\n Task %d completed ", CurrTaskIndex);
        write(handle, buffer, strlen(buffer));
        if (DebugPrint) Cputs(buffer, a, 20, 3);
        Semafore++; 
        close(handle);
        Semafore--; 
    }
    else if (DebugPrint) Cputs("DISK TASK FAILED", ((RED <<4) + YELLOW), 20, 3);
    KillTask(CurrTaskIndex);
    while(TRUE)     /* Wait here untill killed and removed */
    ;
}

void main(int argc, string argv[])
{
    int c, stayhere = TRUE, priority, attr = YELLOW + (BLUE << 4), index;
    
    if (argc > 1) DebugPrint = atoi(argv[1]);
    if (argc > 2) FastClock  = atoi(argv[2]);
    if (argc > 3) LifeCount  = atol(argv[3]);

    clrscr();
    SetUpSystem();
    CursorOff();

    atexit((atexit_t) ClockExit);

    while (stayhere)
    {
	    c = toupper(WaitForUserResponse());
        switch (c)
        {
            case 'A':   AutoKillFlag = !AutoKillFlag;
			            break;

            case 'C':   DialogBoxMgr(0);
                        while (!kbhit()) PrintTimes();
			            DialogBoxMgr(1);
			            break;

            case 'D':   DialogBoxMgr(0);
                        PrintTimes();
        			    WaitForUserResponse();
        			    DialogBoxMgr(1);
        			    break;

    	    case 'K':   disable();
                        Semafore++;    
                        enable();
                        index = GetTaskIndex();
                        KillTask(index);
                        disable();
                        Semafore--;    
                        enable();
                        break;

    	    case 'L':   Semafore++; 
                        priority = 5;
                        index = ActivateTask(SimpleTask, NULL, priority);
                        Semafore--;
                        break;

    	    case 'M':   Semafore++;
                        priority = 10;
                        index = ActivateTask(DiskTask, NULL, priority);
                        Semafore--;
                        break;

    	    case 'Q':   stayhere = FALSE;
	    		        printf("\n\n Bye .. ");
		    	        break;

    	    case 'S':   disable();
                        Semafore++;    
                        enable();
                        index = GetTaskIndex();
                        SuspendTask(index);
                        disable();
                        Semafore--;    
                        enable();
                        break;

    	    case 'T':   disable();
                        Semafore++;    
                        enable();
                        index = GetTaskIndex();
                        TaskStatus(index);
                        disable();
                        Semafore--;    
                        enable();
                        break;

    	    case 'U':   disable();
                        Semafore++;    
                        enable();
                        index = GetTaskIndex();
                        UnSuspendTask(index);
                        disable();
                        Semafore--;    
                        enable();
                        break;

    	    default:    DialogBoxMgr(0);
                        Cputs("Unrecognized command. ", attr, 10, 3);
			            WaitForUserResponse();
			            DialogBoxMgr(1);
			            break;
	    }
    }
    RestoreSystem();
    CursorOn();
}


/*--------------------------------------------------------------------------*
 *  Function:       WaitForUserResponse
 *  Description:    
 *--------------------------------------------------------------------------*/
int WaitForUserResponse(void)
{
    while (!kbhit())
    ;
    return(getch());
}


/*--------------------------------------------------------------------------*
 *  Function:       GetTaskIndex
 *  Description:    
 *--------------------------------------------------------------------------*/
int GetTaskIndex(void)
{
    int index, size;
    char attr = YELLOW + (BLUE << 4);
    char prompt[30], entry[10], *filter = " 123456789";

    DialogBoxMgr(0);
    sprintf(entry, "      ");
    sprintf(prompt, "Enter task index (1 - %u) ", LastTaskIndex());
    Cputs(prompt, attr, 10, 3);
    size = strlen(entry);
    GetString(3, 12 + strlen(prompt), attr, entry, filter, size);
    DialogBoxMgr(1);
    index = atoi(entry);
    return(index);
}

/*--------------------------------------------------------------------------*
 *  Function:       PrintTimes
 *  Description:    Print values of timing variables within a window
 *--------------------------------------------------------------------------*/
void PrintTimes(void)
{
    char buffer[80], attr = YELLOW + (BLUE << 4);

    sprintf(buffer, "Timer ticks %lu ", Timer.Ticks);
    Cputs(buffer, attr, 10, 3);
    sprintf(buffer, "DOS  ticks %lu ", Timer.DOSTicks);
    Cputs(buffer, attr, 10, 4);
    sprintf(buffer, "Timer millisecs %u ", Timer.MiliSecs);
    Cputs(buffer, attr, 10, 5);
}


/*--------------------------------------------------------------------------*
 *  Function:         TaskStatus
 *  Description:      Displays task's status
 *                                                                             
 *--------------------------------------------------------------------------*/
void TaskStatus(int taskindex)
{
    struct text_info t;
    static char message[80];
    int saved = 0, *buffer = NULL;

    if (DebugPrint)
    {
        gettextinfo(&t);
        buffer = (int *) malloc(sizeof(int) * (71 - 30 + 1) * (14 - 5 + 1));
        if (buffer != NULL) saved = gettext(30, 5, 71, 14, buffer);
        PaintBox(30, 5, 70, 13, 2, 1, YELLOW + (RED << 4)," Task Status ");
        sprintf(message, "Task active :      %4u ", IsTaskActive(taskindex));
        Cputs(message, 78, 40, 7);
        sprintf(message, "Task killed :      %4u ", IsTaskToBeKilled(taskindex));
        Cputs(message, 78, 40, 8);
        sprintf(message, "Task suspended :   %4u ", IsTaskSuspended(taskindex));
        Cputs(message, 78, 40, 9);
        sprintf(message, "Task timer :       %4u ", GetTaskTimer(taskindex));
        Cputs(message, 78, 40, 10);
        sprintf(message, "Task sleep timer : %4lu ",GetTaskSleepTimer(taskindex));
        Cputs(message, 78, 40, 11);
 	    WaitForUserResponse();
        if (saved) puttext(30, 5, 71, 14, buffer);
        window(t.winleft, t.wintop, t.winright, t.winbottom);
    }

} /* End of TaskStatus */


/*--------------------------------------------------------------------------*
 *  Function:       ClockExit
 *  Description:    Actual exit function called by C runtime at exit. 
 *                                                                           
 *--------------------------------------------------------------------------*/
static atexit_t ClockExit(void)
{
    RestoreSystem();
    CursorOn();
    return(0);
}
