/*
;;tbengine.cpp
;;
;;  Requires utils.cpp
;;
;;  TDBF, a class derived from KDBF, written by:
;;    Buc Rogers (buc@mcs.com),
;;
;;  With major help from:
;;    Chris Smith (ccas@mcs.com)
;;    Jacques Doornebos
;;
  Design notes:
    950520
      o TUtil:: exceptions thrown should be caught and transferred, preserving
          the TUtil:: errMsg

          Note that any exceptions thrown and caught within same class must take
          care to not be using that class's throwExc()

      o All exceptions should delete dynamically allocated objects before being
          thrown (other than those normally deleted in the destructor)
*/

#pragma   hdrstop

#include  <utils.hpp>

#include  <tdbf.hpp>

/*
;;TBEngine::TBEngine()
;;  : BEngine()
;;
*/
TBEngine::TBEngine()
  : BEngine()
{
  if ( DBIERR_NONE != lastError )
  {
    string buf = "IDAPI Error#: ";
    buf += TIntString( lastError );
    buf += ": ";
    buf += getErrorMessage( lastError );
    lastError = DBIERR_NONE; //Set so getErrorMessage() not called by app
    throwExc( "TBEngine()", "BEngine() constructor", buf.c_str() );
  }
  init();
}

/*
;;TBEngine::TBEngine(BEngineType eType)
;;  : BEngine( eType )
;;
;;  This constructor makes a C++ BEngine object and actually opens the
;;  Paradox engine in the requested mode using default parameters.
;;
*/
TBEngine::TBEngine(BEngineType eType)
  : BEngine( eType )
{
  if ( DBIERR_NONE != lastError )
  {
    string buf = "IDAPI Error#: ";
    buf += TIntString( lastError );
    buf += ": ";
    buf += getErrorMessage( lastError );
    lastError = DBIERR_NONE; //Set so getErrorMessage() not called by app
    throwExc( "TBEngine()", "BEngine() constructor", buf.c_str() );
  }
  init();
}

/*
;;TBEngine::TBEngine(const BEnv& env)
;;  : BEngine( env )
;;
;;  This constructor makes a C++ BEngine object and actually opens the
;;  Paradox engine in the requested mode using suppiled parameters.
;;
*/
TBEngine::TBEngine(const BEnv& env)
  : BEngine( env )
{
  if ( DBIERR_NONE != lastError )
  {
    string buf = "IDAPI Error#: ";
    buf += TIntString( lastError );
    buf += ": ";
    buf += getErrorMessage( lastError );
    lastError = DBIERR_NONE; //Set so getErrorMessage() not called by app
    throwExc( "TBEngine()", "BEngine() constructor", buf.c_str() );
  }
  init();
}

/*
;;virtual
;;TBEngine::~TBEngine()
;;
*/
TBEngine::~TBEngine()
{
  DELETE_A_SAFE( bufCallBackData );
}

/*
;;Retcode
;;TBEngine::checkExc()
;;
;;  Returns:
;;      DBIERR_NONE if lastError is a "sanctioned" (non-thrown) error, otherwise
;;      returns lastError
;;
*/
Retcode
TBEngine::checkExc()
{
#if 0//950520
  if ( DBIERR_NONE != lastError ) //? Any error
  {
    throw ( lastError );
  }
  return ( lastError );           //(Always DBIERR_NONE)
#else
  return ( lastError );
#endif//950520
}

/*
;;protected:
;;void
;;TBEngine::init()
;;
*/
void
TBEngine::init()
{
  bufCallBackData = NULL;
  try
  {
    setDebugLayerOptions( 0 ); //Disa Debug layer (which was ena
                               //  in BEngine constructor)
  }
  catch ( const TTdbfExc& )
  {
    throwExc( "init()" );
  }
  readCfgFile ( "\\SYSTEM\\INIT", 0 ) ; //Initialize idapi.cfg data members
}

/*
;;protected:
;;void
;;TBEngine::readCfgFile( pCHAR CfgPath,
;;                       INT16 Level )
;;
;;  DbiOpenCfgInfoList() helper function
;;
;;    Derived from snipit\config.c
;;
*/
void
TBEngine::readCfgFile (pCHAR CfgPath, INT16 Level)
{
    //DBIResult   rslt;       // Value to return
    hDBICur     hCur;       // Handle to the cursor
    pCHAR       szNode;     // String which contains the name of the node
    pCFGDesc    CfgDesc;    // Configuration descriptor
    INT16       iLoop;      // Loop variable - used for indenting
    //INT16       BaseSize;   // Length of the current node

    // Open the Configuration file - returns the configuration options
    //   for the current level in a schema table referenced by hCur.
    lastError = DbiOpenCfgInfoList(NULL, dbiREADONLY, cfgPersistent, CfgPath,
                              &hCur);
#if 0//950520
    if ( checkExc() == DBIERR_NONE )
#else
    if ( checkExc() != DBIERR_NONE )
    {
      throwExc( "readCfgFile()" );
    }
#endif//950520
    {
        // Allocate resources - make block large enough to contain all
        //   information.
        szNode = new char[ 512 ];
        if (! szNode)
        {
          throwExc( "readCfgFile()", "szNode" );
        }

        CfgDesc = new CFGDesc;
        if (! CfgDesc)
        {
          throwExc( "readCfgFile()", "CfgDesc" );
        }

        // Initialize descriptor to 0.
        memset((void *)CfgDesc, 0, sizeof(CFGDesc));

        // Process all nodes/paths.
        //   Get the next record in the table - contains the next option
        //   of the given level in the tree.
        while (DbiGetNextRecord(hCur, dbiNOLOCK, (pBYTE) CfgDesc, NULL)
               == DBIERR_NONE)
        {
            // Clear the szNode variable.
            szNode[0] = 0;

            // Indent according to the depth of the configuration option.
            for (iLoop = 0; iLoop < Level; iLoop++)
            {
                strcat(szNode, "    ");
            }

            // Output this node, copying the name of the node to the
            //   szNode variable.
            strcat(szNode, CfgDesc->szNodeName);
            //Screen(szNode);

            // Process this node if it has sub-nodes.
             if (CfgDesc->bHasSubnodes)
            {
#if 0//950506
                // Determine if this is a base node.
                if (Level == 0)
                {
                    sprintf(szNode, "%s%s", CfgPath, CfgDesc->szNodeName);
                }
                else // If not a base node.
                {
                    sprintf(szNode, "%s\\%s", CfgPath,
                            CfgDesc->szNodeName);
                }

                // Recursively call this function to get information about
                //   sub-nodes.
                readCfgFile(szNode, (Level + 1));
#else
                continue; //Skip this subnode node
#endif//950506
            }
            else    // No sub-nodes...
            {
#if 0//950506
                // Clear the szNode variable.
                szNode[0] = 0;

                // Indent according to the depth of the config option.
                for (iLoop = 0; iLoop <= Level; iLoop++)
                {
                    strcat(szNode, "    ");
                }

                // Determine the length of the string.
                BaseSize = strlen(szNode);

                // Display the remaining information & description.
                sprintf(&szNode[BaseSize], "Desc: %s",
                        CfgDesc->szDescription);
                //Screen(szNode);

                // Display the type of the node.
                sprintf(&szNode[BaseSize], "Type: %d",
                        CfgDesc->iDataType);
                //Screen(szNode);

                // Display the value of the node.
                sprintf(&szNode[BaseSize], " Val: %s", CfgDesc->szValue);
#else
                if ( 0 == strcmp( szCFGLOWMEMLIMIT, CfgDesc->szNodeName ) )
                {
                  maxSysLowMem = atoi( CfgDesc->szValue );
                }
                if ( 0 == strcmp( szCFGSYSMAXBUF, CfgDesc->szNodeName ) )
                {
                  maxSysBufSize = atol( CfgDesc->szValue );
                }
                if ( 0 == strcmp( szCFGMAXFILEHANDLES, CfgDesc->szNodeName ) )
                {
                  maxSysFileHandles = atoi( CfgDesc->szValue );
                }
                if ( 0 == strcmp( szCFGSYSLOCALSHARE, CfgDesc->szNodeName ) )
                {
                  prmSysLocalShare = CfgDesc->szValue;
                }
                if ( 0 == strcmp( szCFGSYSNETDIR, CfgDesc->szNodeName ) )
                {
                  prmSysNetDir = CfgDesc->szValue;
                }
                if ( 0 == strcmp( szCFGSYSNETTYPE, CfgDesc->szNodeName ) )
                {
                  prmSysNetType = CfgDesc->szValue;
                }
                if ( 0 == strcmp( szCFGSYSVERSION, CfgDesc->szNodeName ) )
                {
                  prmSysVer = CfgDesc->szValue;
                }
#endif//950506
                //Screen(szNode);
            }

            // Initialize descriptor to 0.
            memset((void *) CfgDesc, 0, sizeof(CFGDesc));
        }

        // Clean up.
        delete [] szNode;
        delete CfgDesc;
        if (hCur)
        {
            lastError = DbiCloseCursor(&hCur);
            if ( DBIERR_NONE != checkExc() )
            {
              throwExc( "readCfgFile()" );
            }
        }
    }
}

/*
;;Retcode
;;TBEngine::registerAllCallBacks( void* fnAll )
;;
*/
void
TBEngine::registerAllCallBacks( pfDBICallBack fnAll )
{
  char* bufCallBackData = new char[ sizbufCallBackData ]; //Shared by all callbacks
  if ( DBIERR_NONE != registerCallBack( cbBATCHRESULT,
                                        (UINT32) bufCallBackData,
                                        sizeof( TRsltCallback ),
                                        &rsltCallback,
                                        fnAll ) )
  {
    throwExc( "registerAllCallBacks()" );
  }
  if ( DBIERR_NONE != registerCallBack( cbGENPROGRESS,
                                        (UINT32) bufCallBackData,
                                        sizeof( TRsltCallback ),
                                        &rsltCallback,
                                        fnAll ) )
  {
    throwExc( "registerAllCallBacks()" );
  }
  if ( DBIERR_NONE != registerCallBack( cbRESTRUCTURE,
                                        (UINT32) bufCallBackData,
                                        sizeof( TRsltCallback ),
                                        &rsltCallback,
                                        fnAll ) )
  {
    throwExc( "registerAllCallBacks()" );
  }
  if ( DBIERR_NONE != registerCallBack( cbTABLECHANGED,
                                        (UINT32) bufCallBackData,
                                        sizeof( TRsltCallback ),
                                        &rsltCallback,
                                        fnAll ) )
  {
    throwExc( "registerAllCallBacks()" );
  }
}

/*
;;void
;;TBEngine::setDebugLayerOptions( UINT16 opt,
;;                                const char* fn = NULL )
;;
*/
void
TBEngine::setDebugLayerOptions( UINT16 opt, const char* fn )
{
  lastError = DbiDebugLayerOptions( opt, (pCHAR) fn );
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "setDebugLayerOptions()" );
  }
}

/*
;;Retcode
;;TBEngine::setPrivateDirAndCheck( const char *Directory )
;;
;;  Differs from BEngine::setPrivateDir() in checking
;;    to see if dir exists, returning error if it does not
;;
;;  Does NOT set IDAPI privdir if dir does not exist
;;
;;  Returns one of the following:
;;    DBIERR_NONE
;;    throw ( lastError )
;;      (usually "dir does not exist") )
;;
*/
Retcode
TBEngine::setPrivateDirAndCheck(const char *Directory)
{
  if ( ! TUtil::IsValidPath( Directory ) ) //? Dir does not exist
  {
#if 0//950520
    lastError = ERRCODE_INVALIDDIR + ERRCAT_INVALIDREQ;
    return ( lastError );
#else
    string buf;
    buf = Directory;
    buf += " does not exist";
    throwExc( "setPrivateDirAndCheck()", buf.c_str() );
#endif//950520
  }
  BEngine::setPrivateDir( Directory );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "setPrivateDirAndCheck()" );
  }
  return ( lastError );
}

/*
;;protected:
;;void
;;TBEngine::throwExc( const char* fnArg,
;;                    const char* errArg = NULL,
;;                    const char* infoArg = NULL )
;;
*/
void
TBEngine::throwExc( const char* fnArg,
                    const char* errArg,
                    const char* infoArg )
{
  TTdbfExc::ThrowExc( fnArg,
                   errArg,
                   infoArg,
                   getClassName(),
                   lastError );
}

