/*
;;tbdataba.cpp
;;
;;  Class inherited from BDatabase
;;
;;  Design notes
;;    950609
;;      x const TBDatabase& = NULL is supported in arglists for TBDatabase class
;;          functions via protected constructor kluge
;;
*/

#pragma   hdrstop

#include  <stdcpp.hpp>
#include  <tdbf.hpp>

#ifdef __DLL__
   #define EXPORT _export
#else
   #define EXPORT
#endif

//Non-member functs
Retcode EXPORT GetOptionalParams(pCHAR szDriver, UINT16 *iFields,
                                 pFLDDesc pfldDesc, pCHAR szData);


#if 0//950609
TBDatabase::TBDatabase( TBEngine *eng,
                      DBIOpenMode openMode,
                      DBIShareMode shareMode )
  : BDatabase( eng, openMode, shareMode ),
    engine( eng )
{
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "TBDatabase()", "BDatabase() constructor" );
  }
}

TBDatabase::TBDatabase( TBEngine *eng,
                        const char *BDDriver,
                        const char *BDAlias,
                        const char *BDPassword,
                        DBIOpenMode openMode,
                        DBIShareMode shareMode )
  : BDatabase( eng, BDDriver, BDAlias, BDPassword,
                openMode, shareMode ),
    engine( eng )
{
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "TBDatabase()", "BDatabase() constructor", NULL, BDAlias );
  }
}

TBDatabase::TBDatabase( TBEngine *eng,
                        const char *BDDriver,
                        const char *BDAlias,
                        const char *BDPassword,
                        const char *BDUserName, //This is the new (SQL) parameter
                        DBIOpenMode openMode,
                        DBIShareMode shareMode )
  : BDatabase( eng, BDDriver, BDAlias, BDPassword, BDUserName,
                openMode, shareMode ),
    engine( eng )
{
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "TBDatabase()", "BDatabase() constructor", NULL, BDAlias );
  }
}
#endif 0//950609

/*
;;TBDatabase::TBDatabase( TBEngine& eng,
;;                        DBIOpenMode openMode = dbiREADWRITE,
;;                        DBIShareMode shareMode = dbiOPENSHARED)
;;  : BDatabase( &eng, openMode, shareMode )
;;
;;  Constructor for TBDatabase, 'universal' form
;;
;;  Throws exception on failure
;;
*/
TBDatabase::TBDatabase( TBEngine& eng,
                      DBIOpenMode openMode,
                      DBIShareMode shareMode )
  : BDatabase( &eng, openMode, shareMode ),
    engine( &eng )
{
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "TBDatabase()", "BDatabase() constructor" );
  }
}

/*
;;TBDatabase::TBDatabase( TBEngine& eng,
;;                        const char *BDDriver,
;;                        const char *BDAlias = "",
;;                        const char *BDPassword = "",
;;                        DBIOpenMode openMode = dbiREADWRITE,
;;                        DBIShareMode shareMode = dbiOPENSHARED)
;;  : BDatabase( &eng, BDDriver, BDAlias, BDPassword,
;;                openMode, shareMode )
;;
;;  Constructor for TBDatabase, explicit form
;;
;;  Throws exception on failure
;;
*/
TBDatabase::TBDatabase( TBEngine& eng,
                        const char *BDDriver,
                        const char *BDAlias,
                        const char *BDPassword,
                        DBIOpenMode openMode,
                        DBIShareMode shareMode )
  : BDatabase( &eng, BDDriver, BDAlias, BDPassword,
                openMode, shareMode ),
    engine( &eng )
{
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "TBDatabase()", "BDatabase() constructor", NULL, BDAlias );
  }
}

/*
;;TBDatabase::TBDatabase( TBEngine& eng,
;;                        const char *BDDriver,
;;                        const char *BDAlias,
;;                        const char *BDPassword,
;;                        const char *BDUserName, //This is the new (SQL) parameter
;;                        DBIOpenMode openMode = dbiREADWRITE,
;;                        DBIShareMode shareMode = dbiOPENSHARED)
;;  : BDatabase( &eng, BDDriver, BDAlias, BDPassword,
;;                openMode, shareMode )
;;
;;  Constructor for TBDatabase, explicit form
;;
;;  Throws exception on failure
;;
*/
TBDatabase::TBDatabase( TBEngine& eng,
                        const char *BDDriver,
                        const char *BDAlias,
                        const char *BDPassword,
                        const char *BDUserName, //This is the new (SQL) parameter
                        DBIOpenMode openMode,
                        DBIShareMode shareMode )
  : BDatabase( &eng, BDDriver, BDAlias, BDPassword, BDUserName,
                openMode, shareMode ),
    engine( &eng )
{
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "TBDatabase()", "BDatabase() constructor", NULL, BDAlias );
  }
}

/*
;;virtual
;;TBDatabase::~TBDatabase()
;;
;;  Destructor for TBDatabase
;;
*/
TBDatabase::~TBDatabase()
{
}

/*
;;Retcode
;;TBDatabase::appendTable( const char *srcTable,  //(This database)
;;                         const char *destTable, //(This or other database)
;;                         const char *destType,
;;                         TBDatabase &dbDest,
;;                         eBATMode xBatMode = batAppend )
;;
;;  Throws TTdbfExc exception on any error
;;
;;  Changes by //BR to KDBF original
;;    941112
;;      -Made sure destTblDesc is cleared initially
;;
;;  Additions by //BR
;;    941123
;;      -Removed 'xBatMode' arg from BDatabase (moved to TBDatabase class)
;;    941112
;;      -Added 'xBatMode' arg
;;
*/
//BR END
// Append records of a table to the destination table.
Retcode
TBDatabase::appendTable(const char *srcTable,
                        const char *destTable,
                        const char *destType,
                        TBDatabase &dbDest,
                        eBATMode xBatMode )
{
    BATTblDesc  srcTblDesc;
    BATTblDesc  destTblDesc;

    if (!isOpen)
    {
        return (lastError = PXERR_DBNOTOPEN);
    }

    memset((pVOID)&srcTblDesc, 0, sizeof(BATTblDesc));
    memset((pVOID)&destTblDesc, 0, sizeof(BATTblDesc));

    // Source table values
    //   Database
    srcTblDesc.hDb = hDb;
    //   tablename
    strcpy(srcTblDesc.szTblName, srcTable);
    //   Table Type
    strcpy(srcTblDesc.szTblType, Driver);

    // Destinarion table
    //   Database
    if (&dbDest == NULL)
    {
        destTblDesc.hDb = hDb;
    }
    else
    {
        destTblDesc.hDb = dbDest.hDb;
    }

    //   Table Name
    strcpy(destTblDesc.szTblName, destTable);

    //   Table Type
    if (destType == NULL)
    {
        strcpy(destTblDesc.szTblType, Driver);
    }
    else
    {
        strcpy(destTblDesc.szTblType, destType);
    }

    lastError = DbiBatchMove(&srcTblDesc, NULL, &destTblDesc, NULL, xBatMode,
                             NULL, NULL, NULL, NULL, NULL, NULL, NULL,
                             NULL, NULL, NULL, NULL, TRUE, TRUE,
                             NULL, TRUE);
    if ( lastError != DBIERR_NONE )
    {
      throwExc( "appendTable()" );
    }
    return lastError;
}

/*
;;Retcode
;;TBDatabase::appendTable( const TBCursor& ptCsrSource,        //MUST be Csr of THIS database
;;                         const char *destTableName,   //This or other database
;;                         const char *destType,
;;                         TBDatabase &dbDest,
;;                         eBATMode xBatMode = batAPPEND )
;;
;;  Throws TTdbfExc exception on any error
;;
;;  Additions by //BR
;;    11/06/94
;;      -New function: appendTable with BCursor source
;;
*/
Retcode
TBDatabase::appendTable(const TBCursor& ptCsrSource,
                       const char *destTable,
                       const char *destType,
                       TBDatabase &dbDest,
                       eBATMode xBatMode )
{
    BATTblDesc  destTblDesc;

    if (!isOpen)
    {
        return (lastError = PXERR_DBNOTOPEN);
    }

    memset((pVOID)&destTblDesc, 0, sizeof(BATTblDesc));
    // Destinarion table
    //   Database
    if (&dbDest == NULL)
    {
        destTblDesc.hDb = hDb;
    }
    else
    {
        destTblDesc.hDb = dbDest.hDb;
    }

    //   Table Name
    strcpy(destTblDesc.szTblName, destTable);

    //   Table Type
    if (destType == NULL)
    {
        strcpy(destTblDesc.szTblType, Driver);
    }
    else
    {
        strcpy(destTblDesc.szTblType, destType);
    }
    lastError = ptCsrSource.gotoBegin();
    if ( DBIERR_NONE != lastError )
    {
      return ( lastError );
    }

    lastError = DbiBatchMove(NULL, ptCsrSource.tabH, &destTblDesc, NULL, xBatMode,
                             NULL, NULL, NULL, NULL, NULL, NULL, NULL,
                             NULL, NULL, NULL, NULL, TRUE, TRUE,
                             NULL, TRUE);

    if ( lastError != DBIERR_NONE )
    {
      throwExc( "appendTable()" );
    }
    ptCsrSource.gotoBegin(); //Return source cursor to beginning after add
    return ( lastError );
}

/*
;;Retcode
;;TBDatabase::appendTable(const char* srcTable,   //This database
;;                       TBCursor& ptCsrDest,     //MUST be Csr of THIS database
;;                       eBATMode xBatMode = batAPPEND )
;;
;;  Throws TTdbfExc exception on any error
;;
;;  Additions by //BR
;;    11/06/94
;;      -New function: appendTable with BCursor dest.
;;
*/
Retcode
TBDatabase::appendTable(const char *srcTable,
                       TBCursor& ptCsrDest,
                       eBATMode xBatMode )
{
    BATTblDesc  srcTblDesc;

    if (!isOpen)
    {
        return (lastError = PXERR_DBNOTOPEN);
    }

    memset((pVOID)&srcTblDesc, 0, sizeof(BATTblDesc));

    // Source table values
    //   Database
    srcTblDesc.hDb = hDb;
    //   tablename
    strcpy(srcTblDesc.szTblName, srcTable);
    //   Table Type
    strcpy(srcTblDesc.szTblType, Driver);

    lastError = DbiBatchMove(&srcTblDesc, NULL, NULL, ptCsrDest.tabH, xBatMode,
                             NULL, NULL, NULL, NULL, NULL, NULL, NULL,
                             NULL, NULL, NULL, NULL, TRUE, TRUE,
                             NULL, TRUE);

    if ( lastError != DBIERR_NONE )
    {
      throwExc( "appendTable()" );
    }
    return lastError;
}

/*
;;Retcode
;;TBDatabase::appendTable(const TBCursor& ptCsrSrc,   //MUST be Csr of THIS database
;;                       TBCursor& ptCsrDest,  //MUST be Csr of THIS database
;;                       eBATMode xBatMode = batAPPEND )
;;
;;  Throws TTdbfExc exception on any error
;;
;;    11/06/94
;;      -New function: appendTable with BCursor src., dest.
;;
*/
Retcode
TBDatabase::appendTable( const TBCursor& ptCsrSrc,
                         TBCursor& ptCsrDest,
                         eBATMode xBatMode )
{
    if (!isOpen)
    {
        return (lastError = PXERR_DBNOTOPEN);
    }

    lastError = ptCsrSrc.gotoBegin();
    if ( DBIERR_NONE != lastError )
    {
      return ( lastError );
    }
    lastError = DbiBatchMove(NULL, ptCsrSrc.tabH, NULL, ptCsrDest.tabH, xBatMode,
                             NULL, NULL, NULL, NULL, NULL, NULL, NULL,
                             NULL, NULL, NULL, NULL, TRUE, TRUE,
                             NULL, TRUE);

    if ( lastError != DBIERR_NONE )
    {
      throwExc( "appendTable()" );
    }
    ptCsrSrc.gotoBegin(); //Return source cursor to beginning after add
    return lastError;
}

/*
;;Retcode
;;TBDatabase::beginTransaction( eXILType tranType )
;;
;;  Throws TTdbfExc exception on any error
;;
*/
Retcode
TBDatabase::beginTransaction( eXILType tranType )
{
  hDBIXact tranHandle;
  BDatabase::beginTransaction( tranHandle, tranType );
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "beginTransaction()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBDatabase::beginTransaction(hDBIXact &tranHandle, eXILType tranType)
;;
;;  Throws TTdbfExc exception on any error
;;
*/
Retcode
TBDatabase::beginTransaction(hDBIXact &tranHandle, eXILType tranType)
{
  BDatabase::beginTransaction( tranHandle, tranType );
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "beginTransaction()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBDatabase::createTable( const char *tableName,
;;                         int numFields, const FieldDesc *fldDescs,
;;                         ValidityDesc *valDesc, RefDesc *refDesc )
;;
;;  Throws TTdbfExc on any error
;;
*/
Retcode
TBDatabase::createTable( const char *tableName,
                         int numFields, const FieldDesc *fldDescs,
                         ValidityDesc *valDesc, RefDesc *refDesc )
{
#if 0
#if 0//950703
#else
  //Delete table 1st for possible IDAPI bug deleting on its own
  deleteTableIfExists( tableName );
#endif//950703
#endif//0
  BDatabase::createTable( tableName, numFields, fldDescs, valDesc, refDesc );
  if ( lastError != DBIERR_NONE )
  {
    throwExc( "createTable()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBDatabase::createTableBorrow( const char* psTblName,
;;                               const char* psBorrowFrom,
;;                               const TBDatabase& ptDbFrom = NULL )
;;
;;  New function added by //BR
;;
;;  Creates table in home database or specified path, using
;;    structure of the BorrowFrom table (also in the home database)
;;
;;  Throws (TTdbfExc) exception on any error
;;
*/
Retcode
TBDatabase::createTableBorrow( const char* psTblName, const char* psBorrowFrom,
                               const TBDatabase& ptDbFrom )
{
  int         nFld;
  FieldDesc*  ptFldDescs = NULL;
  const TBDatabase* dbFrom = &ptDbFrom;
  //
  if ( NULL == dbFrom )
  {
    dbFrom = this;
  }
  try
  {
    dbFrom->getDescVector( (char*) psBorrowFrom, nFld, ptFldDescs );
  }
  catch (const TTdbfExc& exc )
  {
    DELETE_A_SAFE( ptFldDescs );
    lastError = dbFrom->lastError;
    throwExc( "createTableBorrow()", NULL, "getDescVector()", NULL, psTblName  );
  }
  try
  {
    deleteTableIfExists( psTblName ); //Delete 1st to ensure createTable doesn't choke
  }
  catch (const TTdbfExc& exc )
  {
    DELETE_A_SAFE( ptFldDescs );
    throwExc( "createTableBorrow()", exc.ErrInfo().c_str(), "deleteTableIfExists()", NULL, psTblName );
  }
  try
  {
    createTable( psTblName, nFld, ptFldDescs );
  }
  catch (const TTdbfExc& exc )
  {
    DELETE_A_SAFE( ptFldDescs );
    throwExc( "createTableBorrow()", exc.ErrInfo().c_str(), "createTable()", NULL, psTblName );
  }
  DELETE_A_SAFE( ptFldDescs );
  return ( lastError );
}

/*
;;Retcode
;;TBDatabase::deleteTable( const char *tableName )
;;
;;  Throws TTdbfExc exception on any error
;;
*/
Retcode
TBDatabase::deleteTable( const char *tableName )
{
    if ( ! isOpen )
    {
      lastError = PXERR_DBNOTOPEN;
      throwExc( "deleteTable()" );
    }

    lastError = DbiDeleteTable(hDb, (pCHAR)tableName, Driver);
    if ( lastError != DBIERR_NONE )
    {
      throwExc( "deleteTable()", NULL, "DbiDeleteTable()" );
    }

    resetDBTableList();
    if ( lastError != DBIERR_NONE )
    {
      throwExc( "deleteTable()", NULL, "resetDBTableList()" );
    }
    return ( lastError );
}

/*
;;Retcode
;;TBDatabase::deleteTableIfExists( const char* tblName )
;;
;;  Deletes table only if it exists. Use this instead of deleteTable()
;;    since IDAPI deletetable function appears to have bug when table
;;    does not exist.
;;
;;  Returns: DBIERR_NONE if table did not exist or did exist and was deleted
;;
;;  Errors: Exceptions thrown on errors (anything but DBIERR_NONE return)
;;
*/
Retcode
TBDatabase::deleteTableIfExists( const char* tblName )
{
  try
  {
    if ( tableExists( tblName ) )
    {
      try
      {
        deleteTable( tblName );
      }
      catch ( const TTdbfExc& excTdbf )
      {
        throwExc( "deleteTableIfExists()", NULL, "deleteTable()", NULL, tblName );
      }
    }
  }
  catch ( const TTdbfExc& excTdbf )
  {
    throwExc( "deleteTableIfExists()", excTdbf.ErrInfo().c_str(), "tableExists()", NULL, tblName );
  }
  lastError = DBIERR_NONE;
  return ( lastError );
}

/*
;;Retcode
;;TBDatabase::emptyTable(const char *tableName)
;;
;;  Throws TTdbfExc on any error
;;
*/
Retcode
TBDatabase::emptyTable(const char *tableName)
{
  BDatabase::emptyTable( tableName );
  if ( lastError != DBIERR_NONE )
  {
    throwExc( "emptyTable" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBDatabase::endTransaction( eXEnd tranType )
;;
;;  Throws TTdbfExc exception on any error
;;
*/
Retcode
TBDatabase::endTransaction( eXEnd tranType )
{
#if 0//950520
    if (!isOpen)
    {
        lastError = PXERR_DBNOTOPEN;
        return lastError;
    }

    lastError = DbiEndTran(hDb, NULL, tranType);
    return lastError;
#else
  BDatabase::endTransaction( tranType );
  if ( DBIERR_NONE != lastError )
  {
    throwExc ( "endTransaction()" );
  }
  return ( lastError );
#endif//950520
}

/*
;;Retcode
;;TBDatabase::forceWrite()
;;
;;  Force writing out to disk all open buffers associated with this
;;  database (applies to local tables only)
;;
;;  Returns with no error if not applicable (isRemote() )
;;
*/
Retcode
TBDatabase::forceWrite()
{
  if ( isRemote() )
  {
    lastError = DBIERR_NONE;
  }
  else//non-SQL, is applicable
  {
    if ( BDatabase::forceWrite() != DBIERR_NONE )
    {
      throwExc( "forceWrite()" );
    }
  }
  return ( lastError );
}

/*
;;string
;;TBDatabase::getAliasName()
;;
;;  Return alias in a string object
;;
*/
string
TBDatabase::getAliasName()
{
  string buf;
  if ( isOpen ) //Only if isOpen is Alias valid
  {
    buf = Alias;
  }
  return ( buf );
}

/*
;;Retcode
;;TBDatabase::getDescVector( char *tableName,
;;                           int& numFields,
;;                            FieldDesc*& desc ) const
;;
*/
Retcode
TBDatabase::getDescVector( char *tableName,
                           int& numFields, FieldDesc*& desc ) const
{
  BDatabase::getDescVector( tableName, numFields, desc );
  if ( lastError != DBIERR_NONE )
  {
    throwExc( "getDescVector()" );
  }
  return ( lastError );
}

/*
;;bool
;;TBDatabase::isRemote()
;;
;;  Returns bTrue if database is remote (sql) (as opposed to ISAM pdox/dbase)
;;
*/
bool
TBDatabase::isRemote()
{
  return ( (bool)( ! ( 0 == strcmp( szPARADOX, getDriver () ) ) ) );
}

/*
;protected:
;Retcode
;TBDatabase::query(const char *qryString, BCursor &answer,
;                         DBIQryLang qryLang)
;
*/
Retcode
TBDatabase::query(const char *qryString, BCursor &answer,
                         DBIQryLang qryLang)
{
  return ( BDatabase::query( qryString, answer, qryLang ) );
}

/*
;;Retcode
;;TBDatabase::query(const char *qryString, TBCursor &answer,
;;                         DBIQryLang qryLang)
;;
;;  Use for only for queries returning an answer cursor (select, etc.)
;;    Throws an exception if query does not return an answer cursor
;;
*/
Retcode
TBDatabase::query(const char *qryString, TBCursor &answer,
                         DBIQryLang qryLang)
{
    TABLEHANDLE tabH = 0;

    if (!isOpen)
    {
        return (lastError = PXERR_DBNOTOPEN);
    }

    lastError = DbiQExecDirect(hDb, qryLang, (pCHAR)qryString, &tabH);
        //If tabH == 0 then attach() below will throw an error
#if 0//950525
    if ( 0 == tabH ) //? No answer cursor returned
    {
      throwExc( "query()", "No expected answer cursor returned" );
    }
    if (lastError)
    {
        return lastError;
    }
#else
    if (lastError)
    {
        return lastError;
    }
    if ( 0 == tabH ) //? No answer cursor returned
    {
      throwExc( "query()", "No expected answer cursor returned" );
    }
#endif//950525
#if 0//950609
    lastError = answer.attach(this, tabH);
#else
    lastError = answer.attach( *this, tabH );
#endif//950609

    DbiCloseCursor(&tabH);

    return lastError; //All errors returned to caller
}

/*
;;Retcode
;;TBDatabase::queryNoAnswer(const char *qryString,
;;                         DBIQryLang qryLang)
;;
;;  Use only for queries returning no answer cursor (delete, etc.)
;;    Throws an exception if query does return an answer cursor
;;
*/
Retcode
TBDatabase::queryNoAnswer(const char *qryString,
                         DBIQryLang qryLang)
{
    TABLEHANDLE tabH = 0;

    if (!isOpen)
    {
      return (lastError = PXERR_DBNOTOPEN);
    }

    lastError = DbiQExecDirect(hDb, qryLang, (pCHAR)qryString, &tabH);
    if (lastError)
    {
      return lastError;
    }
    if ( 0 != tabH ) //Returned an answer (was not supposed to)
    {
      DbiCloseCursor(&tabH);
      throwExc( "queryNoAnswer()", "Unexpected answer cursor returned" );
    }
    return lastError; //All errors returned to caller
}

/*
;;Retcode
;;TBDatabase::sortTable( const char* psTblname,
;;                       TSortTable& rtSortTable )
;;
;;  Sort (unkeyed, local) table to itself
;;  FieldNumber args
;;
*/
Retcode
TBDatabase::sortTable( const char* psTblname,
                       TSortTable& rtSortTable )
{
  int i;
  for ( i = 0; DBIMAXFLDSINKEY > i; i++ )
  {
    if ( 0 == rtSortTable.ahSortFlds_[ i ] )
    {
      break;
    }
  }
  //i == Num of sort fields
  rtSortTable.nSortFlds_ = i;
  lastError = DbiSortTable( hDb,
                            (pCHAR) psTblname,
                            Driver,
                            NULL,
                            NULL,
                            NULL,
                            NULL,
                            rtSortTable.nSortFlds_,
                            (pUINT16) &rtSortTable.ahSortFlds_,
                            NULL,
                            NULL,
                            NULL,
                            false,
                            NULL,
                            NULL );
  return ( lastError );
}

/*
;;Retcode
;;TBDatabase::sortTable( const char* psTblname,
;;                       TSortTableFldName& rtSortTableFldName )
;;
;;  Sort (unkeyed, local) table to itself
;;  FieldName args
;;
*/
Retcode
TBDatabase::sortTable( const char* psTblname,
                       TSortTableFldName& rtSortTableFldName )
{
  int         i;
  int         h;
  //
  {
    //Cursor open only during scope
    TBCursor    tCsr( *this, psTblname );
    TBRecord    tRec( tCsr );
    for ( i = 0; DBIMAXFLDSINKEY > i; i++ )
    {
      if ( 0 == strlen( rtSortTableFldName.psFldName_[ i ] ) ) //? End of fieldname args
      {
        break;
      }
      h = tRec.getFieldNumber( rtSortTableFldName.psFldName_[ i ] );
      if ( 0 == h ) //? Bad fieldname arg
      {
        lastError = ERRCODE_INVALIDPARAM;
        throw ( lastError );
      }
      rtSortTableFldName.ptSortTable_->ahSortFlds_[ i ] = h;
    }
  }
  //tCsr, tRec released
  return ( sortTable( psTblname, *rtSortTableFldName.ptSortTable_ ) );
}

/*
;;BOOL
;;TBDatabase::tableExists(const char *tableName)
;;
;;  See if a table exists in the database.
;;
;;  Returns: TRUE if table exists.
;;
;;  Errors: Throws exception on errors other than DBIERR_NOSUCHTABLE
;;
;;  Design notes:
;;    950524
;;      o Need to correct kluge that ignores helper function errors
;;
*/
BOOL
TBDatabase::tableExists(const char *tableName)
{
    BOOL        exists = FALSE;
    char        *tblName;
    TBLFullDesc tblDesc;
    CHAR        remoteName[DBIMAXNAMELEN+1];

    if (!isOpen)
    {
        lastError = PXERR_DBNOTOPEN;
        return exists;
    }

    if (isLocal)
    {
        tblName = _fstrtok((pCHAR)tableName, ".");
    }
    else
    {
        if ((!strcmp(Driver, "ORACLE")) ||
            (!strcmp(Driver, "SYBASE")))
        {
            strcpy(remoteName, userName);
            strcat(remoteName, ".");
            strcat(remoteName, tableName);
        }
        else
        {
            strcpy(remoteName, tableName);
        }
        tblName = (pCHAR)tableName;
    }

    if (tblName == NULL)
    {
        lastError = DBIERR_INVALIDTABLENAME;
        return FALSE;
    }

#if 1//950524
    resetDBTableList();
#else
    if ( DBIERR_NONE != resetDBTableList() )
    {
      throwExc( "tableExists()", "resetDBTableList()", NULL, NULL, tableName );
    }
#endif//950524

    lastError = TableList.gotoTop();
    if (lastError != DBIERR_NONE)
    {
#if 1//950524
        return FALSE;
#else
        throwExc( "tableExists()", "gotoTop()", NULL, NULL, tableName );
#endif//950524
    }

    while (TableList.getNextRecord(tblDesc) == DBIERR_NONE)
    {
        if (!stricmp(tblDesc.tblBase.szName, tblName))
        {
            // Check if the types match
            if (strcmp(tblDesc.tblBase.szType, Driver) && isLocal)
            {
                // keep searching it the table is of the wrong type
                continue;
            }
            lastError = DBIERR_NONE;
            return TRUE;
        }
    }

    lastError = DBIERR_NOSUCHTABLE;

    return exists;
}

/*
;;protected:
;;void
;;TBDatabase::throwExc( const char* fnArg,
;;                    const char* errArg = NULL,
;;                    const char* infoArg = NULL,
;;                    const char* aliasArg = NULL,
;;                    const char* tblArg = NULL ) const
;;
*/
void
TBDatabase::throwExc( const char* fnArg,
                      const char* errArg,
                      const char* infoArg,
                      const char* aliasArg,
                      const char* tblArg ) const
{
  const char* strAlias;
  if ( isOpen ) //Only if isOpen
  {
    strAlias = Alias;
  }
  else
  {
    strAlias = aliasArg;
  }
  TTdbfExc::ThrowExc( fnArg,
                   errArg,
                   infoArg,
                   getClassName(),
                   lastError,
                   strAlias,
                   tblArg );
}

/*
;;TSortTable::TSortTable()
;;
;;  Constructor for TSortTable class
;;
*/
TSortTable::TSortTable()
{
  int i;
  //
  for ( i = 0; DBIMAXFLDSINKEY > i; i++ )
  {
    ahSortFlds_[ i ] = 0;
  }
}

/*
;;TSortTableFldName::TSortTableFldName()
;;
;;  Constructor for TSortTableFldName class
;;
*/
TSortTableFldName::TSortTableFldName()
{
  ptSortTable_ = new TSortTable();
  int i;
  //
  for ( i = 0; DBIMAXFLDSINKEY > i; i++ )
  {
    psFldName_[ i ] = new char[ DBIMAXNAMELEN + 1 ];
    *psFldName_[ i ] = '\0';
  }
}

/*
;;TSortTableFldName::~TSortTableFldName()
;;
;;  Destructor for TSortTableFldName class
;;
*/
TSortTableFldName::~TSortTableFldName()
{
  delete ptSortTable_;
  int i;
  //
  for ( i = 0; DBIMAXFLDSINKEY > i; i++ )
  {
    delete [] psFldName_[ i ];
  }
}

