/*
;;tbcursor.cpp
;;
*/

#pragma   hdrstop

#include  <tdbf.hpp>

/*
;;TBCursor::TBCursor()
;;  : BCursor()
;;
*/
TBCursor::TBCursor()
  : BCursor(),
    //
    db( NULL ),
    recGeneric( NULL )
{
}

/*
;;TBCursor::TBCursor( TBDatabase& dbArg,
;;                    const char* tableName,
;;                    int indexID = 0,
;;                    BOOL saveEveryChange = FALSE,
;;                    DBIOpenMode openMode = dbiREADWRITE,
;;                    DBIShareMode shareMode = dbiOPENSHARED,
;;                    XLTMode xltMode = xltFIELD)
;;  : TBCursor( &dbArg, tableName, indexID, saveEveryChange, openMode, shareMode,
;;              xltMode )
;;
;;  Constructor; make a TBCursor object and open the specified Paradox table.
;;
;;  Throws a (TTdbfExc) exception on any error
;;
*/
TBCursor::TBCursor( TBDatabase& dbArg,
                  const char* tableName,
                  int indexID,
                  BOOL saveEveryChange,
                  DBIOpenMode openMode,
                  DBIShareMode shareMode,
                  XLTMode xltMode )
  : BCursor( &dbArg, tableName, indexID, saveEveryChange, openMode, shareMode,
              xltMode ),
    db( &dbArg ),
    recGeneric( NULL )

{
  //Checking for any error. ! isOpen should always have a (DBIERR_NONE != lastError )
  //  Should get a throw ( xalloc ) on memory error.
  if ( DBIERR_NONE != lastError )
  {
    TTdbfExc::ThrowExc( "TBCursor()", "BCursor constructor", NULL, "TBCursor",
                     lastError, db->Alias, tableName );
  }
  recGeneric = new TBRecord( *this );
}

/*
;;TBCursor::TBCursor( TBDatabase& dbArg,
;;                  const char* tableName,
;;                  const char *tableType,
;;                  int indexID,
;;                  DBIOpenMode openMode = dbiREADWRITE,
;;                  DBIShareMode shareMode = dbiOPENSHARED,
;;                  XLTMode xltMode = xltFIELD)
;;  : BCursor( &dbArg, tableName, tableType, indexID, openMode, shareMode, xltMode )
;;
;;  Constructor; make a TBCursor object and open the specified table of the
;;  specified type
;;
*/
TBCursor::TBCursor( TBDatabase& dbArg,
                  const char* tableName,
                  const char *tableType,
                  int indexID,
                  DBIOpenMode openMode,
                  DBIShareMode shareMode,
                  XLTMode xltMode )
  : BCursor( &dbArg, tableName, tableType, indexID, openMode, shareMode, xltMode ),
    db( &dbArg ),
    recGeneric( NULL )
{
  //Checking for any error. ! isOpen should always have a (DBIERR_NONE != lastError )
  //  Should get a throw ( xalloc ) on memory error.
  if ( DBIERR_NONE != lastError )
  {
    TTdbfExc::ThrowExc( "TBCursor()", "BCursor constructor", NULL, "TBCursor",
                     lastError, db->Alias, tableName );
  }
  recGeneric = new TBRecord( *this );
}

/*
;;TBCursor::TBCursor( TBDatabase& dbArg,
;;                  const char* tableName,
;;                  const char* indexName,
;;                  DBIOpenMode openMode = dbiREADWRITE,
;;                  DBIShareMode shareMode = dbiOPENSHARED,
;;                  XLTMode xltMode = xltFIELD )
;;  : BCursor()
;;
;;  Constructor; make a TBCursor object and open the specified table of the
;;  specified type. Use the indexName to identify the index. Note that for
;;  dBASE tables, the indexName is used as the indexTagName and the
;;  <tablename>.MDX is used as the indexname (idnetifying the production
;;  index).
;;
;;  941123
;;    -Added XPRIM reserved suffix support
;;
*/
TBCursor::TBCursor( TBDatabase& dbArg,
                  const char* tableName,
                  const char* indexName,
                  DBIOpenMode openMode,
                  DBIShareMode shareMode,
                  XLTMode xltMode )
  //: BCursor( dbArg, tableName, indexName, openMode, shareMode, xltMode )
  : BCursor(),
    db( &dbArg ),
    recGeneric( NULL )
{
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "TBCursor()", "BCursor constructor" );
  }
  try
  {
    open( *db, tableName, indexName, openMode, shareMode, xltMode );
        //Opens recGeneric
  }
  catch (TTdbfExc )
  {
    TTdbfExc::ThrowExc( "TBCursor()", "BCursor constructor", NULL, "TBCursor",
                     lastError, db->Alias, tableName );
  }
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "TBCursor()" );
  }
}

/*
;;TBCursor::TBCursor( TBDatabase& dbArg,
;;                  const char* tableName,
;;                  const char* indexName,
;;                  const char* indexTagName,
;;                  DBIOpenMode openMode = dbiREADWRITE,
;;                  DBIShareMode shareMode = dbiOPENSHARED,
;;                  XLTMode xltMode = xltFIELD)
;;  : BCursor( &dbArg, tableName, indexName, indexTagName, openMode, shareMode,
;;              xltMode )
;;
;;  Constructor; make a TBCursor object and open the specified table of the
;;  specified type. Use the indexName and indexTagName to identify the
;;  index. Needed for dBASE tables
;;
*/
TBCursor::TBCursor( TBDatabase& dbArg,
                  const char* tableName,
                  const char* indexName,
                  const char* indexTagName,
                  DBIOpenMode openMode,
                  DBIShareMode shareMode,
                  XLTMode xltMode )
  : BCursor( &dbArg, tableName, indexName, indexTagName, openMode, shareMode,
              xltMode ),
    db( &dbArg ),
    recGeneric( NULL )
{
  //Checking for any error. ! isOpen should always have a (DBIERR_NONE != lastError )
  //  Should get a throw ( xalloc ) on memory error.
  if ( DBIERR_NONE != lastError )
  {
    TTdbfExc::ThrowExc( "TBCursor()", "BCursor constructor", NULL, "TBCursor",
                     lastError, db->Alias, tableName );
  }
  recGeneric = new TBRecord( *this );
}

/*
;;
;;TBCursor::TBCursor(const TBCursor &copyCur)
;;     Copy Constructor
*/
TBCursor::TBCursor(const TBCursor &copyCur)
  : BCursor( copyCur ),
    //
    db( copyCur.db ),
    recGeneric( NULL )
{
  const char* str = NULL;
  if ( copyCur.isOpen )
  {
    str = tabname;
  }
  if ( DBIERR_NONE != lastError )
  {
    TTdbfExc::ThrowExc( "TBCursor()", "BCursor constructor", NULL, "TBCursor",
                     lastError, db->Alias, str );
  }
  if ( copyCur.isOpen )
  {
#if 0//950627
    recGeneric = new TBRecord( *this );
    //copyCur.RecRd().copyToSimilar( *recGeneric ); //Clone the genericRec contents as well
        //Note this will throw exception on returned answer cursor from remote SQL
        //  (have tried BRecord::copyTo(), but it does not copy blobs)
#else
    if ( copyCur.recGeneric == NULL )
    {
      TTdbfExc::ThrowExc( "TBCursor()", "recGeneric == NULL", NULL, "TBCursor",
                          lastError, db->Alias, str );
    }
    recGeneric = new TBRecord( *this );
    copyCur.recGeneric->copyTo( *recGeneric );
//delete recGeneric; //Delete right away and use other instead
//recGeneric = new TBRecord( *this );
#endif//950627
  }
}

/*
;;
;;TBCursor::operator =(const TBCursor &copyCur)
;;     Assignment of cursors
;;
*/
TBCursor&
TBCursor::operator =( const TBCursor &copyCur)
{
  if (this == &copyCur)
    return *this;

  BCursor::operator = ( copyCur );
  db = copyCur.db;
  const char* str = NULL;
  if ( copyCur.isOpen )
  {
    str = tabname;
#if 0//950627
    recGeneric = new TBRecord( *this );
    copyCur.RecRd().copyToSimilar( *recGeneric ); //Clone the genericRec contents as well
#else
    recGeneric = new TBRecord( *copyCur.recGeneric );
#endif//950627
  }
  if ( DBIERR_NONE != lastError )
  {
    TTdbfExc::ThrowExc( "operator =", "BCursor constructor", NULL, "TBCursor",
                     lastError, db->Alias, str );
  }
  return *this;
}

/*
;;virtual
;;TBCursor::~TBCursor()
;;
;;  Destructor; closes the engine if it's open.
;;
*/
TBCursor::~TBCursor()
{
  DELETE_SAFE( recGeneric );
}

/*
;protected:
;Retcode
;TBCursor::attach(BDatabase *dbArg, TABLEHANDLE tableHandle)
;
*/
Retcode
TBCursor::attach(BDatabase *dbArg, TABLEHANDLE tableHandle)
{
  return ( BCursor::attach( dbArg, tableHandle ) );
}

/*
;;Retcode
;;TBCursor::attach( TBDatabase& dbArg, TABLEHANDLE tableHandle )
;;
*/
Retcode
TBCursor::attach( TBDatabase& dbArg, TABLEHANDLE tableHandle )
{
  db = &dbArg;
  BCursor::attach( db, tableHandle );
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "attach()" );
  }
  if ( NULL != recGeneric )
  {
    throwExc( "attach()", "recGeneric already open" );
  }
  recGeneric = new TBRecord( *this );
  return ( lastError );
}

/*
;protected:
;Retcode
;TBCursor::appendRec(BRecord *rec)
;
*/
Retcode
TBCursor::appendRec(BRecord *rec)
{
  return ( BCursor::appendRec( rec ) );
}

/*
;;Retcode
;;TBCursor::appendRec( TBRecord& rec)
;;
;;  Throws a (TTdbfExc) exception on any error
;;
*/
Retcode
TBCursor::appendRec( TBRecord& rec )
{
  BCursor::appendRec( &rec );
#if 0//950705
  switch ( lastError )
  {
    case DBIERR_BLOBNOTOPENED : //This BLOB was never opened
    //case PXERR_BLOBNOTOPEN : //951114
      lastError = DBIERR_NONE;
      break;
    case DBIERR_NONE :
    default :
      break;
  }
#endif//950705
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "appendRec()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBCursor::appendRec()
;;
;;  Throws a (TTdbfExc) exception on anything but:
;;    DBIERR_NONE
;;    DBIERR_BOF
;;    DBIERR_EOF
;;    DBIERR_FILELOCKED     (likely for this funct.)
;;    DBIERR_KEYVIOL        (likely for this funct.)
;;    DBIERR_RECLOCKFAILED  (likely for this funct.)
;;    PXERR_INVCURRRECORD
;;
;;    (otherwise returns one of the above)
;;
*/
Retcode
TBCursor::appendRec()
{
  return ( appendRec( *recGeneric ) );
}

/*
;;Retcode
;;TBCursor::appendRec(const void far *buffer, int size)
;;
;;  Throws a (TTdbfExc) exception on any error
;;
*/
Retcode
TBCursor::appendRec(const void far *buffer, int size)
{
  BCursor::appendRec( buffer, size );
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "appendRec()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBCursor::clearRec()
;;
*/
Retcode
TBCursor::clearRec()
{
  return ( clearRec( *recGeneric ) );
}

/*
;protected:
;Retcode
;TBCursor::clearRec( BRecord* rec )
;
*/
Retcode
TBCursor::clearRec( BRecord* rec )
{
  return ( BCursor::clearRec( rec ) );
}

/*
;;Retcode
;;TBCursor::clearRec( TBRecord& rec )
;;
;;  Used to clear any open blobs. This function should be called
;;  if any blobs have been written to a record, but appendRec(),
;;  insertRec() or updateRec() was never called successfully.
;;
;;  For example, if there is a locking conflict, and a decision
;;  is made not to post a record having had blobs written to its
;;  record buffer, clearRec() should be called to free those blob
;;  resources. clearRec() may be called even after the blobs have
;;  already been closed by appendRec(), insertRec() or updateRec().
;;
;;  In summary, whenever a blob is written to a BRecord, it MUST
;;  be followed by a successfull call to one of the following BCursor
;;  functions, or BLOB resources will not be freed:
;;    appendRec()
;;    clearRec()
;;    insertRec()
;;    updateRec()
;;
;;  Throws a (TTdbfExc) exception on any error.
;;
*/
Retcode
TBCursor::clearRec( TBRecord& rec )
{
  BCursor::clearRec( &rec );
  switch ( lastError )
  {
    case DBIERR_NONE :
      break;
#if 0//950705
    case DBIERR_BLOBNOTOPENED : //appendRec(), insertRec() or updateRec()
                                //  must have already been called, or
                                //  this BLOB was never opened
    //case PXERR_BLOBNOTOPEN : //951114
      lastError = DBIERR_NONE;
      break;
#endif 0//950705
    default :
      throwExc( "clearRec()" );
  }
  return ( lastError );
}

/*
;;virtual
;;Retcode
;;TBCursor::close()
;;
*/
Retcode
TBCursor::close()
{
  if ( DBIERR_NONE != BCursor::close() )
  {
    throwExc( "close()" );
  }
  DELETE_SAFE( recGeneric );
  return ( lastError );
}

/*
;;virtual
;;Retcode
;;TBCursor::closeIfOpen() const
;;
*/
Retcode
TBCursor::closeIfOpen()
{
  if ( ! isOpen )
  {
    return ( DBIERR_NONE );
  }
  return ( close() );
}

/*
;;RECORDNUMBER
;;TBCursor::getCurRecNum() const
;;
;;  Throws TTdbfExc on any error
;;
*/
RECORDNUMBER
TBCursor::getCurRecNum() const
{
  RECORDNUMBER recnum;
  recnum = BCursor::getCurRecNum();
  if ( lastError != DBIERR_NONE )
  {
    throwExc( "getCurRecNum()" );
  }
  return ( recnum );
}

/*
;;Retcode
;;TBCursor::getFirstRecord( TBRecord& rec ) const
;;
;;  Throws a (TTdbfExc) exception on anything but:
;;    DBIERR_NONE
;;    DBIERR_EOF
;;    PXERR_INVCURRRECORD
;;
;;    (otherwise returns one of the above)
;;
*/
Retcode
TBCursor::getFirstRecord( TBRecord& rec ) const
{
  gotoBegin(); //Throws exc on any error
  return ( getNextRecord( rec ) );
}

/*
;;Retcode
;;TBCursor::getFirstRecord() const
;;
;;  Throws a (TTdbfExc) exception on anything but:
;;    DBIERR_NONE
;;    DBIERR_EOF
;;    PXERR_INVCURRRECORD
;;
;;    (otherwise returns one of the above)
;;
*/
Retcode
TBCursor::getFirstRecord() const
{
  return ( getFirstRecord( *recGeneric ) );
}

/*
;;Retcode
;;TBCursor::getLastRecord( TBRecord& rec ) const
;;
;;  Throws a (TTdbfExc) exception on anything but:
;;    DBIERR_NONE
;;    DBIERR_BOF
;;    PXERR_INVCURRRECORD
;;
;;    (otherwise returns one of the above)
;;
*/
Retcode
TBCursor::getLastRecord( TBRecord& rec ) const
{
  gotoEnd(); //Throws exc on any error
  return ( getPreviousRecord( rec ) );
}

/*
;;Retcode
;;TBCursor::getLastRecord() const
;;
;;  Throws a (TTdbfExc) exception on anything but:
;;    DBIERR_NONE
;;    DBIERR_BOF
;;    PXERR_INVCURRRECORD
;;
;;    (otherwise returns one of the above)
;;
*/
Retcode
TBCursor::getLastRecord() const
{
  return ( getLastRecord( *recGeneric ) );
}

/*
;protected:
;Retcode
;TBCursor::getNextRecord(BRecord *rec) const
;
*/
Retcode
TBCursor::getNextRecord(BRecord *rec) const
{
  return ( BCursor::getNextRecord( rec ) );
}

/*
;;Retcode
;;TBCursor::getNextRecord(TBRecord& rec) const
;;
;;  Throws a (TTdbfExc) exception on anything but:
;;    DBIERR_NONE
;;    DBIERR_EOF
;;    PXERR_INVCURRRECORD
;;
;;    (otherwise returns one of the above)
;;
*/
Retcode
TBCursor::getNextRecord(TBRecord& rec) const
{
  BCursor::getNextRecord( &rec );
  if ( DBIERR_NONE != lastError && DBIERR_EOF != lastError && PXERR_INVCURRRECORD != lastError )
  {
    throwExc( "getNextRecord()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBCursor::getNextRecord() const
;;
;;  Throws a (TTdbfExc) exception on anything but:
;;    DBIERR_NONE
;;    DBIERR_EOF
;;    PXERR_INVCURRRECORD
;;
;;
;;    (otherwise returns one of the above)
;;
*/
Retcode
TBCursor::getNextRecord() const
{
  return ( getNextRecord( *recGeneric ) );
}

/*
;protected:
;Retcode
;TBCursor::getPreviousRecord(BRecord *rec ) const
;
*/
Retcode
TBCursor::getPreviousRecord(BRecord *rec) const
{
  return ( BCursor::getPreviousRecord( rec ) );
}

/*
;;Retcode
;;TBCursor::getPreviousRecord( TBRecord& rec ) const
;;
;;  Throws a (TTdbfExc) exception on anything but:
;;    DBIERR_NONE
;;    DBIERR_BOF
;;    PXERR_INVCURRRECORD
;;
;;    (otherwise returns one of the above)
;;
*/
Retcode
TBCursor::getPreviousRecord( TBRecord& rec ) const
{
  BCursor::getPreviousRecord( &rec );
  if ( DBIERR_NONE != lastError && DBIERR_BOF != lastError && PXERR_INVCURRRECORD != lastError )
  {
    throwExc( "getPreviousRecord()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBCursor::getPreviousRecord() const
;;
;;  Throws a (TTdbfExc) exception on anything but:
;;    DBIERR_NONE
;;    DBIERR_BOF
;;    PXERR_INVCURRRECORD
;;
;;    (otherwise returns one of the above)
;;
*/
Retcode
TBCursor::getPreviousRecord() const
{
  return ( getPreviousRecord( *recGeneric ) );
}

/*
;;RECORDNUMBER
;;TBCursor::getRecCount() const
;;
*/
RECORDNUMBER
TBCursor::getRecCount() const
{
  RECORDNUMBER recnum = BCursor::getRecCount();
  if ( lastError != DBIERR_NONE )
  {
    throwExc( "getRecCount()" );
  }
  return ( recnum );
}

/*
;protected:
;Retcode
;TBCursor::getRecord(BRecord *rec) const
;
*/
Retcode
TBCursor::getRecord(BRecord *rec) const
{
  return ( BCursor::getRecord( rec ) );
}

/*
;;Retcode
;;TBCursor::getRecord( TBRecord& rec ) const
;;
;;  Throws a (TTdbfExc) exception on any error
;;
*/
Retcode
TBCursor::getRecord(TBRecord& rec) const
{
  BCursor::getRecord( &rec );
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "getRecord()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBCursor::getRecord() const
;;
;;  Throws a (TTdbfExc) exception on any error
;;
*/
Retcode
TBCursor::getRecord() const
{
  return ( getRecord( *recGeneric ) );
}

/*
;;Retcode
;;TBCursor::getRecord(void far *buffer, int size)
;;
;;  Throws a (TTdbfExc) exception on any error
;;
*/
Retcode
TBCursor::getRecord(void far *buffer, int size)
{
  BCursor::getRecord( buffer, size );
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "getRecord()" );
  }
  return ( lastError );
}

/*
;;string
;;TBCursor::getTableName()
;;
*/
string
TBCursor::getTableName()
{
  string buf;
  if ( isOpen ) //tabname valid only if isOpen
  {
    buf = tabname;
  }
  return ( buf );
}

/*
;;Retcode
;;TBCursor::gotoBegin() const
;;
*/
Retcode
TBCursor::gotoBegin() const
{
  BCursor::gotoBegin();
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "gotoBegin()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBCursor::gotoEnd() const
;;
*/
Retcode
TBCursor::gotoEnd() const
{
  BCursor::gotoEnd();
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "gotoEnd()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBCursor::gotoRec( RECORDNUMBER recNum ) const
;;
;;  Throws TTdbfExc on any error
;;
*/
Retcode
TBCursor::gotoRec( RECORDNUMBER recNum ) const
{
  BCursor::gotoRec( recNum );
  if ( lastError != DBIERR_NONE )
  {
    string str;
    str = "recNum: ";
    str += TIntString( recNum );
    throwExc( "gotoRec()", str.c_str() );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBCursor::gotoRecGet( RECORDNUMBER recNum ) const
;;
;;  Throws TTdbfExc on any error
;;
*/
Retcode
TBCursor::gotoRecGet( RECORDNUMBER recNum ) const
{
  return ( gotoRecGet( recNum, *recGeneric ) );
}

/*
;;Retcode
;;TBCursor::gotoRecGet( RECORDNUMBER recNum, TBRecord& rec ) const
;;
;;  Throws TTdbfExc on any error
;;
*/
Retcode
TBCursor::gotoRecGet( RECORDNUMBER recNum, TBRecord& rec  ) const
{
  try
  {
    gotoRec( recNum );
  }
  catch ( const TTdbfExc& exc )
  {
    throwExc( "gotoRecGet()", exc.ErrMsg().c_str(), "gotoRec()" );
  }
  try
  {
    getRecord( rec );
  }
  catch ( const TTdbfExc& exc )
  {
    throwExc( "gotoRecGet()", exc.ErrMsg().c_str(), "getRecord()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBCursor::insertRec()
;;
;;  Throws a (TTdbfExc) exception on any error
;;
*/
Retcode
TBCursor::insertRec()
{
  return ( insertRec( *recGeneric ) );
}

/*
;protected:
;Retcode
;TBCursor::insertRec(BRecord *rec)
;
*/
Retcode
TBCursor::insertRec(BRecord *rec)
{
  return ( BCursor::insertRec( rec ) );
}

/*
;;Retcode
;;TBCursor::insertRec(TBRecord& rec)
;;
;;  Throws a (TTdbfExc) exception on any error
;;
*/
Retcode
TBCursor::insertRec(TBRecord& rec)
{
  BCursor::insertRec( &rec );
#if 0//950705
  switch ( lastError )
  {
    case DBIERR_BLOBNOTOPENED : //This BLOB was never opened
    //case PXERR_BLOBNOTOPEN : //951114
      lastError = DBIERR_NONE;
      break;
    case DBIERR_NONE :
    default :
      break;
  }
#endif 0//950705
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "insertRec()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBCursor::insertRec(const void far *buffer, int size)
;;
;;  Throws a (TTdbfExc) exception on any error
;;
*/
Retcode
TBCursor::insertRec(const void far *buffer, int size)
{
  BCursor::insertRec( buffer, size );
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "insertRec()" );
  }
  return ( lastError );
}

/*
;protected:
;Retcode
;TBCursor::open( BDatabase *dbArg,
;                const char *tableName,
;                int indexID = 0,
;                BOOL saveEveryChange = FALSE,
;                DBIOpenMode openMode = dbiREADWRITE,
;                DBIShareMode shareMode = dbiOPENSHARED,
;                XLTMode xltMode = xltFIELD)
;
;  Throws a (TTdbfExc) exception on any error
;
*/
Retcode
TBCursor::open( BDatabase *dbArg,
                const char *tableName,
                int indexID,
                BOOL saveEveryChange,
                DBIOpenMode openMode,
                DBIShareMode shareMode,
                XLTMode xltMode)
{
  return ( BCursor::open( (TBDatabase*) dbArg, tableName, indexID, saveEveryChange, openMode, shareMode, xltMode ) );
}

/*
;protected:
;Retcode
;TBCursor::open( BDatabase *dbArg,
;                const char *tableName,
;                const char *tableType,
;                int indexID,
;                DBIOpenMode openMode = dbiREADWRITE,
;                DBIShareMode shareMode = dbiOPENSHARED,
;                XLTMode xltMode = xltFIELD)
;
;  Throws a (TTdbfExc) exception on any error
;
*/
Retcode
TBCursor::open( BDatabase *dbArg,
                const char *tableName,
                const char *tableType,
                int indexID,
                DBIOpenMode openMode,
                DBIShareMode shareMode,
                XLTMode xltMode )
{
  return ( BCursor::open( (TBDatabase*) dbArg, tableName, tableType, indexID, openMode, shareMode, xltMode ) );
}

/*
;protected:
;Retcode
;TBCursor::open( BDatabase *dbArg,
;                const char *tableName,
;                const char *indexName,
;                DBIOpenMode openMode,
;                DBIShareMode shareMode,
;                XLTMode xltMode)
;
;  Throws a (TTdbfExc) exception on any error
;
;  941123
;    -Added XPRIM reserved suffix support
;
*/
Retcode
TBCursor::open( BDatabase *dbArg,
                const char *tableName,
                const char *indexName,
                DBIOpenMode openMode,
                DBIShareMode shareMode,
                XLTMode xltMode )
{
  return ( BCursor::open( (TBDatabase*) dbArg, tableName, indexName, openMode, shareMode, xltMode ) );
}

/*
;protected:
;Retcode
;TBCursor::open( BDatabase *dbArg,
;                const char *tableName,
;                const char *indexName,
;                const char *indexTagName,
;                DBIOpenMode openMode = dbiREADWRITE,
;                DBIShareMode shareMode = dbiOPENSHARED,
;                XLTMode xltMode = xltFIELD)
;
;  Throws a (TTdbfExc) exception on any error
;
*/
Retcode
TBCursor::open( BDatabase *dbArg,
                const char *tableName,
                const char *indexName,
                const char *indexTagName,
                DBIOpenMode openMode,
                DBIShareMode shareMode,
                XLTMode xltMode )
{
  return ( BCursor::open( ( TBDatabase*) dbArg, tableName, indexName, indexTagName, openMode, shareMode, xltMode ) );
}

/*
;;Retcode
;;TBCursor::open( TBDatabase& dbArg,
;;                const char* tableName,
;;                int indexID = 0,
;;                BOOL saveEveryChange = FALSE,
;;                DBIOpenMode openMode = dbiREADWRITE,
;;                DBIShareMode shareMode = dbiOPENSHARED,
;;                XLTMode xltMode = xltFIELD)
;;
;;  Throws a (TTdbfExc) exception on any error
;;
*/
Retcode
TBCursor::open( TBDatabase& dbArg,
                const char* tableName,
                int indexID,
                BOOL saveEveryChange,
                DBIOpenMode openMode,
                DBIShareMode shareMode,
                XLTMode xltMode)
{
  db = &dbArg;
  BCursor::open( db, tableName, indexID, saveEveryChange, openMode, shareMode, xltMode );
  if ( DBIERR_NONE != lastError )
  {
    TTdbfExc::ThrowExc( "open()", NULL, NULL, "TBCursor",
                     lastError, db->Alias, tableName );
  }
  if ( NULL != recGeneric )
  {
    throwExc( "attach()", "recGeneric already open" );
  }
  recGeneric = new TBRecord( *this );
  return ( lastError );
}

/*
;;Retcode
;;TBCursor::open( TBDatabase& dbArg,
;;                const char* tableName,
;;                const char* tableType,
;;                int indexID,
;;                DBIOpenMode openMode = dbiREADWRITE,
;;                DBIShareMode shareMode = dbiOPENSHARED,
;;                XLTMode xltMode = xltFIELD)
;;
;;  Throws a (TTdbfExc) exception on any error
;;
*/
Retcode
TBCursor::open( TBDatabase& dbArg,
                const char* tableName,
                const char* tableType,
                int indexID,
                DBIOpenMode openMode,
                DBIShareMode shareMode,
                XLTMode xltMode )
{
  db = &dbArg;
  BCursor::open( db, tableName, tableType, indexID, openMode, shareMode, xltMode );
  if ( DBIERR_NONE != lastError )
  {
    TTdbfExc::ThrowExc( "open()", NULL, NULL, "TBCursor",
                     lastError, db->Alias, tableName );
  }
  if ( NULL != recGeneric )
  {
    throwExc( "attach()", "recGeneric already open" );
  }
  recGeneric = new TBRecord( *this );
  return ( lastError );
}

/*
;;Retcode
;;TBCursor::open( TBDatabase& dbArg,
;;                const char* tableName,
;;                const char* indexName,
;;                DBIOpenMode openMode,
;;                DBIShareMode shareMode,
;;                XLTMode xltMode)
;;
;;  Throws a (TTdbfExc) exception on any error
;;
;;  941123
;;    -Added XPRIM reserved suffix support
;;
*/
Retcode
TBCursor::open( TBDatabase& dbArg,
                const char* tableName,
                const char* indexName,
                DBIOpenMode openMode,
                DBIShareMode shareMode,
                XLTMode xltMode )
{
  db = &dbArg;
  if ( 0 < strstr( indexName, "XPRIM" ) ) //Assume upper case!
  {
    if ( 0 == strcmp( szPARADOX, db->getDriver() ) ) //? Paradox
    {
      BCursor::open( db, tableName, 0, openMode, shareMode, xltMode );
    }
    else //Non-Paradox, assume SQL
    {
      BCursor::open( db, tableName, indexName, openMode, shareMode, xltMode );
    }
  }
  else
  {
    BCursor::open( db, tableName, indexName, openMode, shareMode, xltMode );
  }
  //Checking for any error. ! isOpen should always have a (DBIERR_NONE != lastError )
  //  Should get a throw ( xalloc ) on memory error.
  if ( DBIERR_NONE != lastError )
  {
    TTdbfExc::ThrowExc( "open()", NULL, NULL, "TBCursor",
                     lastError, db->Alias, tableName );
  }
  if ( NULL != recGeneric )
  {
    throwExc( "attach()", "recGeneric already open" );
  }
  recGeneric = new TBRecord( *this );
  return ( lastError );
}

/*
;;Retcode
;;TBCursor::open( TBDatabase& dbArg,
;;                const char* tableName,
;;                const char* indexName,
;;                const char* indexTagName,
;;                DBIOpenMode openMode = dbiREADWRITE,
;;                DBIShareMode shareMode = dbiOPENSHARED,
;;                XLTMode xltMode = xltFIELD)
;;
;;  Throws a (TTdbfExc) exception on any error
;;
*/
Retcode
TBCursor::open( TBDatabase& dbArg,
                const char* tableName,
                const char* indexName,
                const char* indexTagName,
                DBIOpenMode openMode,
                DBIShareMode shareMode,
                XLTMode xltMode )
{
  db = &dbArg;
  BCursor::open( db, tableName, indexName, indexTagName, openMode, shareMode, xltMode );
  if ( DBIERR_NONE != lastError )
  {
    TTdbfExc::ThrowExc( "open()", NULL, NULL, "TBCursor",
                     lastError, db->Alias, tableName );
  }
  if ( NULL != recGeneric )
  {
    throwExc( "attach()", "recGeneric already open" );
  }
  recGeneric = new TBRecord( *this );
  return ( lastError );
}

/*
;;Retcode
;;TBCursor::searchIndex( TBRecord& keyRec,
;;                       PXSearchMode mode,
;;                       int fldCnt = 1,
;;                       bool doGetRecord = false ) const
;;
*/
Retcode
TBCursor::searchIndex( TBRecord& keyRec,
                       PXSearchMode mode, int fldCnt, bool doGetRecord ) const
{
  BCursor::searchIndex( (BRecord*) &keyRec, mode, fldCnt );
  switch ( lastError )
  {
    case DBIERR_NONE : //Find successful
      if ( doGetRecord )
      {
        getRecord( keyRec );
      }
      break;
    case DBIERR_RECNOTFOUND :
      break;
    default :
      throwExc( "searchIndex()" );
  }
  return ( lastError );
}

/*
;protected:
;Retcode
;TBCursor::searchIndex( const BRecord* keyRec,
;                       PXSearchMode mode,
;                       int fldCnt = 1)
;
*/
Retcode
TBCursor::searchIndex( const BRecord* keyRec,
                       PXSearchMode mode, int fldCnt )
{
  return ( BCursor::searchIndex( keyRec, mode, fldCnt ) );
}

/*
;protected:
;Retcode
;TBCursor::searchIndex(PXSearchMode mode, int fldCnt, ...)
;
*/
Retcode
TBCursor::searchIndex(PXSearchMode , int , ...)
{
  throwExc( "searchIndex", "... arglist not supported in TDBF" );
  return ( lastError );
}

/*
;;Retcode
;;TBCursor::searchIndexRec( PXSearchMode mode,
;;                          int fldCnt = 1,
;;                          bool doGetRecord = false ) const
;;
;;  Search using TBCursor::Rec() field value(s)
;;
*/
Retcode
TBCursor::searchIndexRec( PXSearchMode mode, int fldCnt, bool doGetRecord ) const
{
  return ( searchIndex( *recGeneric, mode, fldCnt, doGetRecord ) );
}

/*
;;Retcode
;;TBCursor::searchNonIndex( const char* psFldName,
;;                          const char* psFldvalExpr,
;;                          bool    bLikePattern = false,
;;                          bool    doSearch = false )
;;
;;  Search on single non-indexed field. Table must have a unique key index.
;;    1.) Runs query on table, returns ERRCODE_RECNOTFOUND if 0 recs result
;;    2.) Otherwise uses searchIndex() to return first found occurence
;;          in this TBCursor
;;
;;  Note if bLikePattern is true, SQL-style wildcards (not QBE) apply
;;
    941202
      o Change so query returns only key fields and search field
      o Need non-indexed search--for now, just say found, don't move cursor
*/
Retcode
TBCursor::searchNonIndex( const char* psFldName, const char* psFldvalExpr,
                          bool bLikePattern, bool doSearch )
{
  TBCursor* ptCsr;
  TBRecord* ptRec;
  TQuery tQry( db->engine, db );
  strstream tSql;
  //
  tSql.flush();
  tSql << "select * "
          "from " << tabname << " "
          "where " << psFldName << " ";
  if ( bLikePattern )
  {
    tSql << "like '" << psFldvalExpr << "' ";
  }
  else
  {
    tSql << "= '" << psFldvalExpr << "' ";
  }
  lastError = tQry.Query( &tSql, ptCsr, ptRec );
  if( DBIERR_NONE != lastError )
  {
    return ( lastError );
  }
  if ( 0 == ptCsr->getRecCount() )
  {
    lastError = DBIERR_RECNOTFOUND;
    return ( lastError );
  }
  lastError = ptCsr->getNextRecord( ptRec );
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "searchNonIndex()", NULL, "getNextRecord()" );
  }
  //Have key value to locate
  if ( doSearch )
  {
    IDXDesc tIdxDesc;
    lastError = DbiGetIndexDesc(tabH, 0, &tIdxDesc);
    if ( DBIERR_NONE != lastError )
    {
      throwExc( "searchNonIndex()", NULL, "DbiGetIndexDesc()" );
    }
    if ( 0 == tIdxDesc.iFldsInKey )
    {
      throwExc( "searchNonIndex()", "0 fields in key" );
          //Need non-indexed search--for now, throw exception
    }
    else
    {
      if ( DBIERR_NONE != searchIndex( *ptRec, (PXSearchMode) keySEARCHEQ, tIdxDesc.iFldsInKey ) )
      {
        throwExc( "searchNonIndex()" );
            //Could not find key that was queried above
      }
    }
  }
  return ( lastError );
}

/*
;;protected:
;;void
;;TBCursor::throwExc( const char* fnArg,
;;                    const char* errArg = NULL,
;;                    const char* infoArg = NULL ) const
;;
*/
void
TBCursor::throwExc( const char* fnArg,
                    const char* errArg,
                    const char* infoArg ) const
{
  const char* strAlias = NULL;
  const char* strTabname = NULL;
  if ( isOpen ) //Only if isOpen
  {
    strAlias = db->Alias;
    strTabname = tabname;
  }
  TTdbfExc::ThrowExc( fnArg,
                   errArg,
                   infoArg,
                   getClassName(),
                   lastError,
                   strAlias,
                   strTabname );
}

/*
;;Retcode
;;TBCursor::updateRec()
;;
;;  Throws a (TTdbfExc) exception on any error
;;
*/
Retcode
TBCursor::updateRec()
{
  return ( updateRec( *recGeneric ) );
}

/*
;protected:
;Retcode
;TBCursor::updateRec(BRecord *rec)
;
*/
Retcode
TBCursor::updateRec(BRecord *rec)
{
  return ( BCursor::updateRec( rec ) );
}

/*
;;Retcode
;;TBCursor::updateRec(TBRecord& rec)
;;
;;  Throws a (TTdbfExc) exception on any error
;;
*/
Retcode
TBCursor::updateRec(TBRecord& rec)
{
  BCursor::updateRec( &rec );
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "updateRec()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBCursor::updateRec(const void far *buffer, int size)
;;
;;  Throws a (TTdbfExc) exception on any error
;;
*/
Retcode
TBCursor::updateRec(const void far *buffer, int size)
{
  BCursor::updateRec( buffer, size );
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "updateRec()" );
  }
  return ( lastError );
}

