/*
;;utils.hpp
;;
;;  General utilities, including kdbf- and tdbf- related ones
;;
*/

#ifdef		I_TUTIL
#else
#define 	I_TUTIL

#if 0
#include  <envdef.h> //KDBF include file for BTimeStamp
#else
#include  <tdbf.hpp>
#endif//0

#include  <cstring.h>
#include  <errno.h>
#include  <time.h>

#include  <stdcpp.hpp>


#define   knBufSizTimestamp 24 + 1

/*
;;class
;;TIntString
;;
;;===================================================================
;;   CLASS TIntString   -- Integer to String conversions
;;===================================================================
;;
*/
class
TIntString
{
  public:
  //
  //  Member Functions
  //
/*
;;TIntString::TIntString( long n )
;;
*/
                    TIntString( long n );

/*
;;TIntString::operator string()
;;
*/
    operator string()
    {
      return str;
    };
  private:
  //
  //  Member Data
  //
    string          str;
};

/*
;;class
;;TUtil
;;
;;	Fully-static class (no instantiation needed, call all functions using
;;		TUtil:: prefix)
;;
*/
class
TUtil
{
	public:
    static int        ChDir( const char* psPath );
    static bool   CnvStrToUnix( const char* psdTime, long& rdTime );

    static bool   CnvTimestampToUnix( BTimeStamp* pdTimestamp, long& rdTime );

    static bool   CnvTimestrToSec( const char* psdTime, long& rdTime );

    static bool   CnvTimeToBTime( const char* psTime, BTime& rBTime );

    static bool   CnvUnixToStr( long dTime, char* psTime );

    static string     CnvUnixToString( long dTime );

    static int        GetCWD( char* ps, int nBufLen );

		static char*	    GetDateTime( int hours = 0, int minutes = 0,
                                   int seconds = 0, time_t external_time = 0 );

    static long       GetTimeFromMidnight();

    static bool   IsValidPath( const char* path );

		static int 		    LookUp( char*, char** );

    static void       MakePath( const char* psFrom, char* psTo );

    static bool   SetDriveAndCwd( const char* psPath );

    static unsigned char* TrimXStr( unsigned char* psBuf );

	private:
		static char		sDateTimeString[ 80 ];
};

#endif//I_TUTIL

