/*
;;tquery_2.hpp
;;
*/

#ifdef    I_TQUERY_2
#else
#define   I_TQUERY_2

#include  <cstring.h>
#include  <strstrea.h>
#include  <stdc.h>
#include  <heapptr.h>
#if 0//950524
#include  <kdbf.h>
class TBEngine;        class TBCursor;
class TBDatabase;      class TBRecord;
#else
#include  <tdbf.hpp>
#endif//950524

//===========================================================
//   CLASS TQueryBase  --  Query Object Base Class
//===========================================================

class
TQueryBase
{
  public:
  //
  //  Member Functions
  //
                    TQueryBase( TBDatabase& theDatabase );
    virtual         ~TQueryBase();

/*
;;inline
;;Retcode
;;TQueryBase::Error()
;;
*/
    Retcode         Error() const
                    {
                      return lastError;
                    };
/*
;;inline
;;DBIQryLang
;;TQueryBase::Language()
;;
*/
    DBIQryLang      Language() const
                    {
                      return myLanguage;
                    };

    virtual Retcode Run() = 0;

    const string&   QueryString() const;
/*
;;inline
;;void
;;TQueryBase::SetLanguage( DBIQryLang newLang )   //  Override Query
;;
*/
    void            SetLanguage( DBIQryLang newLang ) const   //  Override Query
                    {
                      const_cast<TQueryBase*>(this)->myLanguage = newLang;
                    };      //    Language
/*
;;inline
;;void
;;TQueryBase::SetQuery( const string & QueryText) //  Lazy way to
;;
*/
    void            SetQuery( const string & QueryText) const //  Lazy way to
                    {
                      const_cast<TQueryBase*>(this)->strm << QueryText;
                    };         //    load Query
/*
;;inline
;;strstream&
;;TQueryBase::Text()
;;
*/
    strstream&      Text() const
                    {
                      return const_cast<TQueryBase*>(this)->strm;
                    };
  protected:
  //
  //  Member Functions
  //
/*
;;pure virtual
;;const char*
;;ClassName()
;;
;;  Used by ThrowExc() in all derived classes
;;
*/
    virtual const char* ClassName() const = 0;               //  Used by ThrowExc()
/*
;;protected:
;;inline
;;TBDatabase*
;;TQueryBase::Db()
;;
*/
    TBDatabase*     Db() const
                    {
                      return db;
                    };
/*
;;protected:
;;inline
;;TBEngine*
;;TQueryBase::Engine()
;;
*/
    TBEngine*       Engine() const
                    {
                      return engine;
                    };
/*
;;protected:
;;inline
;;void
;;TQueryBase::SetError( Retcode err )        //  Override Error
;;
*/
    void            SetError( Retcode err ) const        //  Override Error
                    {
                      const_cast<TQueryBase*>(this)->lastError = err;
                    };        //    State...
    void            ThrowExc( const char * fnArg,
                              const char * errArg = NULL,
                              const char * infoArg = NULL ) const;
  protected:
    string          buf;            //Query string in string form
  private:
  //
  //  Member Data
  //
    Retcode         lastError;     // Error State
    DBIQryLang      myLanguage;    // Language of Query Text (default: SQL)
    strstream       strm;          // Query Text
    TBDatabase*     db;            // Source DB
    TBEngine*       engine;        // DB engine
};

/*
;;class
;;TQueryAnswerRO
;;  : public TQueryBase
;;
;;===========================================================
;;   CLASS TQueryAnswerRO     --  Query returning Result Table
;;===========================================================
;;
*/
class TQueryAnswerRO
  : public TQueryBase
{
  public:
  //
  //  Member Functions
  //
                    TQueryAnswerRO( TBDatabase& theDatabase );
    virtual         ~TQueryAnswerRO();

/*
;;inline
;;const TBCursor&
;;TQueryAnswerRO::Csr() const
;;
*/
    const TBCursor& Csr() const                       //  Access Query Cursor
                    {
                      return ( *const_cast<TQueryAnswerRO*>(this)->cursor );
                    };

/*
;;inline
;;const TBCursor
;;TQueryAnswerRO::CloneCursor() const
;;
*/
    const TBCursor  CloneCursor() const                        //  Copy Query Cursor
                    {
                      return ( *const_cast<TQueryAnswerRO*>(this)->cursor );
                    };

/*
;;inline
;;const TBRecord&
;;TQueryAnswerRO::Rec() const
;;
*/
    const TBRecord& Rec() const                         //  Access Query Record
                    {
                      return ( const_cast<TQueryAnswerRO*>(this)->cursor->Rec() );
                    };

    virtual Retcode Run();            // Execute the Query

/*
;;inline
;;void
;;TQueryAnswerRO::SetResultTbl( TBDatabase& tblDB,
;;                              const string& tblname )
;;
*/
    void            SetResultTbl( TBDatabase & tblDB,
                                  const string & tblname ) const
                    {
                      const_cast<TQueryAnswerRO*>(this)->resultDB = &tblDB;
                      const_cast<TQueryAnswerRO*>(this)->resultTbl = tblname;
                    };

  protected:
  //
  //  Member Functions
  //
/*
;;protected:
;;inline
;;virtual
;;const char*
;;TQueryAnswerRO::ClassName()
;;
*/
    virtual const char *  ClassName() const
                          {
                            return "TQueryAnswerRO";
                          };

  private:
  //
  //  Data Members
  //
    TBDatabase *          resultDB;      // Description of (optional) result table
    string                resultTbl;
    THeapPtr<TBCursor>    cursor;     // Managed Resorces
};

/*
;;class
;;TQueryAnswerRW
;;  : public TQueryBase
;;
;;===========================================================
;;   CLASS TQueryAnswerRW     --  Query returning Result Table
;;===========================================================
;;
*/
class TQueryAnswerRW
  : public TQueryBase
{
  public:
  //
  //  Member Functions
  //
                    TQueryAnswerRW( TBDatabase& theDatabase,
                                    TBDatabase& dbPriv,
                                    const string& nameQueriedTable );

    virtual         ~TQueryAnswerRW();

/*
;;inline
;;const TBCursor&
;;TQueryAnswerRW::Csr() const
;;
*/
    TBCursor& Csr()
                    {
                      return ( *cursor );
                    };

/*
;;inline
;;TBCursor
;;TQueryAnswerRW::CloneCursor() const
;;
*/
    TBCursor        CloneCursor() const
                    {
                      return ( *cursor );
                    };

/*
;;inline
;;TBRecord&
;;TQueryAnswerRW::Rec()
;;
*/
    TBRecord&       Rec()
                    {
                      return ( cursor->Rec() );
                    };

    virtual Retcode Run();            // Execute the Query

    void            Update();

  protected:
  //
  //  Member Functions
  //
/*
;;protected:
;;inline
;;virtual
;;const char*
;;TQueryAnswerRW::ClassName()
;;
*/
    virtual const char *  ClassName() const
                          {
                            return "TQueryAnswerRW";
                          };

  private:
  //
  //  Data Members
  //
    TBDatabase*           resultDB;      // Description of (optional) result table
    string                resultTbl;
    TBCursor*             cursor;     // Managed Resources
};

/*
;;class
;;TQueryNoAnswer
;;  : public TQueryBase
;;
;;===========================================================
;;   CLASS TQueryNoAnswer  --  Query without Results
;;===========================================================
;;
*/
class TQueryNoAnswer
  : public TQueryBase
{
  public:
  //
  //  Member Functions
  //
/*
;;inline
;;TQueryNoAnswer::TQueryNoAnswer( TBDatabase* theDatabase )
;;  : TQueryBase( theDatabase )
;;
*/
                    TQueryNoAnswer( TBDatabase& theDatabase )
                      : TQueryBase( theDatabase )
                    {
                    };
    virtual         ~TQueryNoAnswer();

    virtual Retcode Run();            // Execute the Query

  protected:
  //
  //  Member Functions
  //
/*
;;inline
;;virtual
;;const char*
;;TQueryNoAnswer::ClassName()
;;
*/
    virtual const char* ClassName() const
                        {
                          return "TQueryNoAnswer";
                        };
};

#endif//I_TQUERY

