/*
;;tbrecord.hpp
;;
;;  TBRecord class, inherited from BRecord
;;
*/

#ifdef    I_TBRECORD
#else
#define   I_TBRECORD

#include  <kdbf.h>

#include  <tbcursor.hpp>

/*
;;class TBRecord
;;  : public BRecord
;;
;;  This class adds the following functionality beyond BRecord:
;;    -Throws exception to app for getField(), putField(), et al.
;;
*/
class TBRecord
  : public BRecord
{
  public:
#if 0//950609
                    TBRecord(TBCursor *cursor = 0);
#else
                    TBRecord();
  protected:
                    TBRecord(TBCursor *cursor );
                        //This constructor present to avoid inheritence problems,
                        //  and is protected since that is its only reason for existence
  public:
#endif 0//950609
                    TBRecord( TBCursor& cursor );
                    TBRecord( const TBRecord &copyCur );

    TBRecord&       operator =( const TBRecord &copyCur );

    virtual         ~TBRecord();

#if 0//950609
    virtual Retcode attach( TBCursor *curArg );
#endif 0//950609
    virtual Retcode attach( TBCursor& curArg );

    Retcode         clear();

    Retcode         clearRec();
    Retcode         clearRec( TBRecord& rec );

    Retcode         closeBlob(FIELDNUMBER fldnbr,
                              BOOL bAccept = TRUE) const;
    Retcode         closeBlob(const char* psFldName,
                              BOOL bAccept = TRUE) const;

    Retcode         copyTo( TBRecord& destRec, bool doBlobs = true ) const;

    Retcode         copyToSimilar( TBRecord& ptRecDest ) const;

    Retcode         dropBlob(FIELDNUMBER fldnbr) const;
    Retcode         dropBlob(const char* psFldName) const;

    UINT32          getBlob(FIELDNUMBER fldnbr,
                            long nOffset,
                            string& buf,
                            UINT16 nSize = 0 ) const;
    Retcode         getBlob(FIELDNUMBER fldnbr,
                            unsigned int nSize,
                            long nOffset,
                            void far *pvBuffer) const;
    UINT32          getBlob(const char* psFldName,
                            long nOffset,
                            string& buf,
                            UINT16 nSize = 0 ) const;
    Retcode         getBlob(const char* psFldName,
                            unsigned int nSize,
                            long nOffset,
                            void far *pvBuffer) const;

    Retcode         getBlobHeader(FIELDNUMBER fldnbr,
                                  int nSize,
                                  void* pvBuffer,
                                  int& rnBytesRead) const;
    Retcode         getBlobHeader(const char* psFldName,
                                  int nSize,
                                  void* pvBuffer,
                                  int& rnBytesRead) const;

    unsigned long   getBlobSize(FIELDNUMBER fldnbr) const;
    unsigned long   getBlobSize(const char* psFldName) const;

/*
;;inline
;;virtual
;;const char*
;;TBRecord::getClassName()
;;
*/
    virtual const char* getClassName() const
                        {
                          return ( "TBRecord" );
                        };

    Retcode         getField(FIELDNUMBER fldnbr, string& buf ) const;
    Retcode         getField(FIELDNUMBER fldnbr, char *buf,
                             int bufLen ) const;
    Retcode         getField(FIELDNUMBER fldnbr, void *buf,
                             int bufLen ) const;
    Retcode         getField(FIELDNUMBER fldnbr, double& val ) const;
    Retcode         getField(FIELDNUMBER fldnbr, INT16& val ) const;
    Retcode         getField(FIELDNUMBER fldnbr, INT32& val ) const;
    Retcode         getField(FIELDNUMBER fldnbr, UINT16& val ) const;
    Retcode         getField(FIELDNUMBER fldnbr, UINT32& val ) const;
    Retcode         getField(FIELDNUMBER fldnbr, FMTBcd& val ) const;
    Retcode         getField(FIELDNUMBER fldnbr, BDate& val ) const;
    Retcode         getField(FIELDNUMBER fldnbr, BTime& val ) const;
    Retcode         getField(FIELDNUMBER fldnbr, BTimeStamp& val ) const;
    Retcode         getField(FIELDNUMBER fldnbr, char *buf,
                             int bufLen, BOOL& fNull) const;
    Retcode         getField(FIELDNUMBER fldnbr, void *buf,
                             int bufLen, BOOL& fNull) const;
    Retcode         getField(FIELDNUMBER fldnbr, double& val, BOOL& fNull) const;
    Retcode         getField(FIELDNUMBER fldnbr, INT16& val, BOOL& fNull) const;
    Retcode         getField(FIELDNUMBER fldnbr, INT32& val, BOOL& fNull) const;
    Retcode         getField(FIELDNUMBER fldnbr, UINT16& val, BOOL& fNull) const;
    Retcode         getField(FIELDNUMBER fldnbr, UINT32& val, BOOL& fNull) const;
    Retcode         getField(FIELDNUMBER fldnbr, FMTBcd& val, BOOL& fNull) const;
    Retcode         getField(FIELDNUMBER fldnbr, BDate& val, BOOL& fNull) const;
    Retcode         getField(FIELDNUMBER fldnbr, BTime& val, BOOL& fNull) const;
    Retcode         getField(FIELDNUMBER fldnbr, BTimeStamp& val, BOOL& fNull) const;
    Retcode         getField(char *fldName, char *buf, int bufLen,
                               BOOL& fNull) const;
    Retcode         getField(char *fldName, void *buf, int bufLen,
                               BOOL& fNull) const;
    Retcode         getField(char *fldName, double& val, BOOL& fNull) const;
    Retcode         getField(char *fldName, INT16& val, BOOL& fNull) const;
    Retcode         getField(char *fldName, INT32& val, BOOL& fNull) const;
    Retcode         getField(char *fldName, UINT16& val, BOOL& fNull) const;
    Retcode         getField(char *fldName, UINT32& val, BOOL& fNull) const;
    Retcode         getField(char *fldName, FMTBcd& val, BOOL& fNull) const;
    Retcode         getField(char *fldName, BDate& val, BOOL& fNull) const;
    Retcode         getField(char *fldName, BTime& val, BOOL& fNull) const;
    Retcode         getField(char *fldName, BTimeStamp& val, BOOL& fNull) const;
    Retcode         getField(const char *fldName, string& buf ) const;
    Retcode         getField(const char *fldName, char *buf, int bufLen ) const;
    Retcode         getField(const char *fldName, void *buf, int bufLen ) const;
    Retcode         getField(const char *fldName, double& val ) const;
    Retcode         getField(const char *fldName, INT16& val ) const;
    Retcode         getField(const char *fldName, INT32& val ) const;
    Retcode         getField(const char *fldName, UINT16& val ) const;
    Retcode         getField(const char *fldName, UINT32& val ) const;
    Retcode         getField(const char *fldName, FMTBcd& val ) const;
    Retcode         getField(const char *fldName, BDate& val ) const;
    Retcode         getField(const char *fldName, BTime& val ) const;
    Retcode         getField(const char *fldName, BTimeStamp& val ) const;

    FIELDNUMBER     getFieldNumber( const char *fldName ) const;

    int             getFieldCount() const;

    Retcode         getFieldDesc( FIELDNUMBER fldnbr, FieldDesc& desc ) const;

    string          getFieldName( FIELDNUMBER h ) const;

    double          getFloat( const string& fldName ) const;
    INT32           getInt32( const string& fldName ) const;
    string          getString( const string& fldName ) const;
    BTimeStamp      getTimestamp( const string& fldName ) const;

    BOOL            isNull(FIELDNUMBER fldnbr) const;
    BOOL            isNull(const char *fldname) const;

    Retcode         openBlobRead(FIELDNUMBER fldnbr,
                                  BOOL usePrivateCopy = FALSE) const;
    Retcode         openBlobRead(const char* psFldName,
                                  BOOL usePrivateCopy = FALSE) const;

    Retcode         openBlobWrite(FIELDNUMBER fldnbr,
                                  long nSize = 0,
                                  BOOL bCopyOld = FALSE);
    Retcode         openBlobWrite(const char* psFldName,
                                  long nSize = 0,
                                  BOOL bCopyOld = FALSE);

    Retcode         putBlob(FIELDNUMBER fldnbr,
                            unsigned long nOffset,
                            const string& buf );
    Retcode         putBlob(FIELDNUMBER fldnbr,
                            unsigned long nSize,
                            unsigned long nOffset,
                            void far *pvBuffer);
    Retcode         putBlob(const char* psFldName,
                            unsigned long nOffset,
                            const string& buf );
    Retcode         putBlob(const char* psFldName,
                            unsigned long nSize,
                            unsigned long nOffset,
                            void far *pvBuffer);

    Retcode         putField(FIELDNUMBER fldnbr, const string& buf );
    Retcode         putField(FIELDNUMBER fldnbr, const char *buf);
    Retcode         putField(FIELDNUMBER fldnbr, const void *buf);
    Retcode         putField(FIELDNUMBER fldnbr, double val);
    Retcode         putField(FIELDNUMBER fldnbr, INT16 val);
    Retcode         putField(FIELDNUMBER fldnbr, INT32 val);
    Retcode         putField(FIELDNUMBER fldnbr, UINT16 val);
    Retcode         putField(FIELDNUMBER fldnbr, UINT32 val);
    Retcode         putField(FIELDNUMBER fldnbr, FMTBcd val);
    Retcode         putField(FIELDNUMBER fldnbr, const BDate& val);
    Retcode         putField(FIELDNUMBER fldnbr, const BTime& val);
    Retcode         putField(FIELDNUMBER fldnbr, const BTimeStamp& val);
    Retcode         putField(char *fldName, const string& buf );
    Retcode         putField(char *fldName, const char *buf);
    Retcode         putField(char *fldName, const void *buf);
    Retcode         putField(char *fldName, double val);
    Retcode         putField(char *fldName, INT16 val);
    Retcode         putField(char *fldName, INT32 val);
    Retcode         putField(char *fldName, UINT16 val);
    Retcode         putField(char *fldName, UINT32 val);
    Retcode         putField(char *fldName, FMTBcd val);
    Retcode         putField(char *fldName, const BDate& val);
    Retcode         putField(char *fldName, const BTime& val);
    Retcode         putField(char *fldName, const BTimeStamp& val);

    Retcode         setNull(FIELDNUMBER fldnbr);
    Retcode         setNull(const char *fldName);

  protected:
    virtual Retcode attach( BCursor *curArg );

    Retcode         checkExc() const;

    Retcode         copyTo(BRecord *destRec) const
                    {
                      return ( DBIERR_NONE );
                    }

    Retcode         copyFrom(BRecord *srcRec)
                    {
                      return ( DBIERR_NONE );
                    }

    Retcode         getFieldDesc( FIELDNUMBER fldnbr,
                                  PXFieldType &fldType,
                                  PXFieldSubtype &fldSubtype, int &fldLen) const
                    {
                      if ( BRecord::getFieldDesc( fldnbr, fldType, fldSubtype, fldLen )
                           != DBIERR_NONE )
                      {
                        throwExc( "getFieldDesc()" );
                      }
                      return ( lastError );
                    }

    void            throwExc( const char* fnArg,
                              const char* errArg = NULL,
                              const char* infoArg = NULL,
                              const char* fldArg = NULL ) const;
    //
    TBCursor*       csr;
  private:
    friend class TBCursor;
 };

//Declare any KDBF utility function prototypes referenced
Retcode
convertFld( void *srcPtr, PXFieldType srcType, int srcLen,
            void *destPtr, PXFieldType destType, int destLen);

#endif//I_TBRECORD

